/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpiderModel
extends EntityModel<LivingEntityRenderState> {
    private static final String BODY_0 = "body0";
    private static final String BODY_1 = "body1";
    private static final String RIGHT_MIDDLE_FRONT_LEG = "right_middle_front_leg";
    private static final String LEFT_MIDDLE_FRONT_LEG = "left_middle_front_leg";
    private static final String RIGHT_MIDDLE_HIND_LEG = "right_middle_hind_leg";
    private static final String LEFT_MIDDLE_HIND_LEG = "left_middle_hind_leg";
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart rightMiddleFrontLeg;
    private final ModelPart leftMiddleFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public SpiderModel(ModelPart p_170984_) {
        super(p_170984_);
        this.head = p_170984_.getChild("head");
        this.rightHindLeg = p_170984_.getChild("right_hind_leg");
        this.leftHindLeg = p_170984_.getChild("left_hind_leg");
        this.rightMiddleHindLeg = p_170984_.getChild(RIGHT_MIDDLE_HIND_LEG);
        this.leftMiddleHindLeg = p_170984_.getChild(LEFT_MIDDLE_HIND_LEG);
        this.rightMiddleFrontLeg = p_170984_.getChild(RIGHT_MIDDLE_FRONT_LEG);
        this.leftMiddleFrontLeg = p_170984_.getChild(LEFT_MIDDLE_FRONT_LEG);
        this.rightFrontLeg = p_170984_.getChild("right_front_leg");
        this.leftFrontLeg = p_170984_.getChild("left_front_leg");
    }

    public static LayerDefinition createSpiderBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 15;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f), PartPose.offset(0.0f, 15.0f, -3.0f));
        partdefinition.addOrReplaceChild(BODY_0, CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset(0.0f, 15.0f, 0.0f));
        partdefinition.addOrReplaceChild(BODY_1, CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 12.0f), PartPose.offset(0.0f, 15.0f, 9.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(18, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        float f = 0.7853982f;
        float f1 = 0.3926991f;
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offsetAndRotation(-4.0f, 15.0f, 2.0f, 0.0f, 0.7853982f, -0.7853982f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder1, PartPose.offsetAndRotation(4.0f, 15.0f, 2.0f, 0.0f, -0.7853982f, 0.7853982f));
        partdefinition.addOrReplaceChild(RIGHT_MIDDLE_HIND_LEG, cubelistbuilder, PartPose.offsetAndRotation(-4.0f, 15.0f, 1.0f, 0.0f, 0.3926991f, -0.58119464f));
        partdefinition.addOrReplaceChild(LEFT_MIDDLE_HIND_LEG, cubelistbuilder1, PartPose.offsetAndRotation(4.0f, 15.0f, 1.0f, 0.0f, -0.3926991f, 0.58119464f));
        partdefinition.addOrReplaceChild(RIGHT_MIDDLE_FRONT_LEG, cubelistbuilder, PartPose.offsetAndRotation(-4.0f, 15.0f, 0.0f, 0.0f, -0.3926991f, -0.58119464f));
        partdefinition.addOrReplaceChild(LEFT_MIDDLE_FRONT_LEG, cubelistbuilder1, PartPose.offsetAndRotation(4.0f, 15.0f, 0.0f, 0.0f, 0.3926991f, 0.58119464f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offsetAndRotation(-4.0f, 15.0f, -1.0f, 0.0f, -0.7853982f, -0.7853982f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder1, PartPose.offsetAndRotation(4.0f, 15.0f, -1.0f, 0.0f, 0.7853982f, 0.7853982f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(LivingEntityRenderState p_362661_) {
        super.setupAnim(p_362661_);
        this.head.yRot = p_362661_.yRot * ((float)Math.PI / 180);
        this.head.xRot = p_362661_.xRot * ((float)Math.PI / 180);
        float f = p_362661_.walkAnimationPos * 0.6662f;
        float f1 = p_362661_.walkAnimationSpeed;
        float f2 = -(Mth.cos(f * 2.0f + 0.0f) * 0.4f) * f1;
        float f3 = -(Mth.cos(f * 2.0f + (float)Math.PI) * 0.4f) * f1;
        float f4 = -(Mth.cos(f * 2.0f + 1.5707964f) * 0.4f) * f1;
        float f5 = -(Mth.cos(f * 2.0f + 4.712389f) * 0.4f) * f1;
        float f6 = Math.abs(Mth.sin(f + 0.0f) * 0.4f) * f1;
        float f7 = Math.abs(Mth.sin(f + (float)Math.PI) * 0.4f) * f1;
        float f8 = Math.abs(Mth.sin(f + 1.5707964f) * 0.4f) * f1;
        float f9 = Math.abs(Mth.sin(f + 4.712389f) * 0.4f) * f1;
        this.rightHindLeg.yRot += f2;
        this.leftHindLeg.yRot -= f2;
        this.rightMiddleHindLeg.yRot += f3;
        this.leftMiddleHindLeg.yRot -= f3;
        this.rightMiddleFrontLeg.yRot += f4;
        this.leftMiddleFrontLeg.yRot -= f4;
        this.rightFrontLeg.yRot += f5;
        this.leftFrontLeg.yRot -= f5;
        this.rightHindLeg.zRot += f6;
        this.leftHindLeg.zRot -= f6;
        this.rightMiddleHindLeg.zRot += f7;
        this.leftMiddleHindLeg.zRot -= f7;
        this.rightMiddleFrontLeg.zRot += f8;
        this.leftMiddleFrontLeg.zRot -= f8;
        this.rightFrontLeg.zRot += f9;
        this.leftFrontLeg.zRot -= f9;
    }
}

