/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.RavagerRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RavagerModel
extends EntityModel<RavagerRenderState> {
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart neck;

    public RavagerModel(ModelPart p_170889_) {
        super(p_170889_);
        this.neck = p_170889_.getChild("neck");
        this.head = this.neck.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.rightHindLeg = p_170889_.getChild("right_hind_leg");
        this.leftHindLeg = p_170889_.getChild("left_hind_leg");
        this.rightFrontLeg = p_170889_.getChild("right_front_leg");
        this.leftFrontLeg = p_170889_.getChild("left_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 16;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(68, 73).addBox(-5.0f, -1.0f, -18.0f, 10.0f, 10.0f, 18.0f), PartPose.offset(0.0f, -7.0f, 5.5f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -20.0f, -14.0f, 16.0f, 20.0f, 16.0f).texOffs(0, 0).addBox(-2.0f, -6.0f, -18.0f, 4.0f, 8.0f, 4.0f), PartPose.offset(0.0f, 16.0f, -17.0f));
        partdefinition2.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(74, 55).addBox(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f), PartPose.offsetAndRotation(-10.0f, -14.0f, -8.0f, 1.0995574f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(74, 55).mirror().addBox(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f), PartPose.offsetAndRotation(8.0f, -14.0f, -8.0f, 1.0995574f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 36).addBox(-8.0f, 0.0f, -16.0f, 16.0f, 3.0f, 16.0f), PartPose.offset(0.0f, -2.0f, 2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 55).addBox(-7.0f, -10.0f, -7.0f, 14.0f, 16.0f, 20.0f).texOffs(0, 91).addBox(-6.0f, 6.0f, -7.0f, 12.0f, 13.0f, 18.0f), PartPose.offsetAndRotation(0.0f, 1.0f, 2.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(96, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(-8.0f, -13.0f, 18.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(96, 0).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(8.0f, -13.0f, 18.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(-8.0f, -13.0f, -5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(8.0f, -13.0f, -5.0f));
        return LayerDefinition.create(meshdefinition, 128, 128);
    }

    @Override
    public void setupAnim(RavagerRenderState p_362767_) {
        super.setupAnim(p_362767_);
        float f = p_362767_.stunnedTicksRemaining;
        float f1 = p_362767_.attackTicksRemaining;
        int i = 10;
        if (f1 > 0.0f) {
            float f2 = Mth.triangleWave(f1, 10.0f);
            float f3 = (1.0f + f2) * 0.5f;
            float f4 = f3 * f3 * f3 * 12.0f;
            float f5 = f4 * Mth.sin(this.neck.xRot);
            this.neck.z = -6.5f + f4;
            this.neck.y = -7.0f - f5;
            this.mouth.xRot = f1 > 5.0f ? Mth.sin((-4.0f + f1) / 4.0f) * (float)Math.PI * 0.4f : 0.15707964f * Mth.sin((float)Math.PI * f1 / 10.0f);
        } else {
            float f6 = -1.0f;
            float f8 = -1.0f * Mth.sin(this.neck.xRot);
            this.neck.x = 0.0f;
            this.neck.y = -7.0f - f8;
            this.neck.z = 5.5f;
            boolean flag = f > 0.0f;
            this.neck.xRot = flag ? 0.21991149f : 0.0f;
            this.mouth.xRot = (float)Math.PI * (flag ? 0.05f : 0.01f);
            if (flag) {
                double d0 = (double)f / 40.0;
                this.neck.x = (float)Math.sin(d0 * 10.0) * 3.0f;
            } else if ((double)p_362767_.roarAnimation > 0.0) {
                float f10 = Mth.sin(p_362767_.roarAnimation * (float)Math.PI * 0.25f);
                this.mouth.xRot = 1.5707964f * f10;
            }
        }
        this.head.xRot = p_362767_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_362767_.yRot * ((float)Math.PI / 180);
        float f7 = p_362767_.walkAnimationPos;
        float f9 = 0.4f * p_362767_.walkAnimationSpeed;
        this.rightHindLeg.xRot = Mth.cos(f7 * 0.6662f) * f9;
        this.leftHindLeg.xRot = Mth.cos(f7 * 0.6662f + (float)Math.PI) * f9;
        this.rightFrontLeg.xRot = Mth.cos(f7 * 0.6662f + (float)Math.PI) * f9;
        this.leftFrontLeg.xRot = Mth.cos(f7 * 0.6662f) * f9;
    }
}

