/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class PlayerCapeModel<T extends PlayerRenderState>
extends HumanoidModel<T> {
    private static final String CAPE = "cape";
    private final ModelPart cape;

    public PlayerCapeModel(ModelPart p_363402_) {
        super(p_363402_);
        this.cape = this.body.getChild(CAPE);
    }

    public static LayerDefinition createCapeLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh(CubeDeformation.NONE, 0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.clearChild("head");
        partdefinition1.clearChild("hat");
        PartDefinition partdefinition2 = partdefinition.clearChild("body");
        partdefinition.clearChild("left_arm");
        partdefinition.clearChild("right_arm");
        partdefinition.clearChild("left_leg");
        partdefinition.clearChild("right_leg");
        partdefinition2.addOrReplaceChild(CAPE, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, CubeDeformation.NONE, 1.0f, 0.5f), PartPose.offsetAndRotation(0.0f, 0.0f, 2.0f, 0.0f, (float)Math.PI, 0.0f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    public void setupAnim(T p_361567_) {
        super.setupAnim(p_361567_);
        this.cape.rotateBy(new Quaternionf().rotateY((float)(-Math.PI)).rotateX((6.0f + ((PlayerRenderState)((Object)p_361567_)).capeLean / 2.0f + ((PlayerRenderState)((Object)p_361567_)).capeFlap) * ((float)Math.PI / 180)).rotateZ(((PlayerRenderState)((Object)p_361567_)).capeLean2 / 2.0f * ((float)Math.PI / 180)).rotateY((180.0f - ((PlayerRenderState)((Object)p_361567_)).capeLean2 / 2.0f) * ((float)Math.PI / 180)));
    }
}

