/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.AbstractPiglinModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.PiglinRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PiglinModel
extends AbstractPiglinModel<PiglinRenderState> {
    public PiglinModel(ModelPart p_170810_) {
        super(p_170810_);
    }

    @Override
    public void setupAnim(PiglinRenderState p_362843_) {
        super.setupAnim(p_362843_);
        float f = 0.5235988f;
        float f1 = p_362843_.attackTime;
        PiglinArmPose piglinarmpose = p_362843_.armPose;
        if (piglinarmpose == PiglinArmPose.DANCING) {
            float f2 = p_362843_.ageInTicks / 60.0f;
            this.rightEar.zRot = 0.5235988f + (float)Math.PI / 180 * Mth.sin(f2 * 30.0f) * 10.0f;
            this.leftEar.zRot = -0.5235988f - (float)Math.PI / 180 * Mth.cos(f2 * 30.0f) * 10.0f;
            this.head.x += Mth.sin(f2 * 10.0f);
            this.head.y += Mth.sin(f2 * 40.0f) + 0.4f;
            this.rightArm.zRot = (float)Math.PI / 180 * (70.0f + Mth.cos(f2 * 40.0f) * 10.0f);
            this.leftArm.zRot = this.rightArm.zRot * -1.0f;
            this.rightArm.y += Mth.sin(f2 * 40.0f) * 0.5f - 0.5f;
            this.leftArm.y += Mth.sin(f2 * 40.0f) * 0.5f + 0.5f;
            this.body.y += Mth.sin(f2 * 40.0f) * 0.35f;
        } else if (piglinarmpose == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON && f1 == 0.0f) {
            this.holdWeaponHigh(p_362843_);
        } else if (piglinarmpose == PiglinArmPose.CROSSBOW_HOLD) {
            AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, p_362843_.mainArm == HumanoidArm.RIGHT);
        } else if (piglinarmpose == PiglinArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_362843_.maxCrossbowChageDuration, p_362843_.ticksUsingItem, p_362843_.mainArm == HumanoidArm.RIGHT);
        } else if (piglinarmpose == PiglinArmPose.ADMIRING_ITEM) {
            this.head.xRot = 0.5f;
            this.head.yRot = 0.0f;
            if (p_362843_.mainArm == HumanoidArm.LEFT) {
                this.rightArm.yRot = -0.5f;
                this.rightArm.xRot = -0.9f;
            } else {
                this.leftArm.yRot = 0.5f;
                this.leftArm.xRot = -0.9f;
            }
        }
    }

    @Override
    protected void setupAttackAnimation(PiglinRenderState p_362671_, float p_103352_) {
        float f = p_362671_.attackTime;
        if (f > 0.0f && p_362671_.armPose == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON) {
            AnimationUtils.swingWeaponDown(this.rightArm, this.leftArm, p_362671_.mainArm, f, p_362671_.ageInTicks);
        } else {
            super.setupAttackAnimation(p_362671_, p_103352_);
        }
    }

    private void holdWeaponHigh(PiglinRenderState p_361494_) {
        if (p_361494_.mainArm == HumanoidArm.LEFT) {
            this.leftArm.xRot = -1.8f;
        } else {
            this.rightArm.xRot = -1.8f;
        }
    }

    @Override
    public void setAllVisible(boolean p_361670_) {
        super.setAllVisible(p_361670_);
        this.leftSleeve.visible = p_361670_;
        this.rightSleeve.visible = p_361670_;
        this.leftPants.visible = p_361670_;
        this.rightPants.visible = p_361670_;
        this.jacket.visible = p_361670_;
    }
}

