/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LlamaRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LlamaModel
extends EntityModel<LlamaRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = LlamaModel::transformToBaby;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightChest;
    private final ModelPart leftChest;

    public LlamaModel(ModelPart p_170724_) {
        super(p_170724_);
        this.head = p_170724_.getChild("head");
        this.rightChest = p_170724_.getChild("right_chest");
        this.leftChest = p_170724_.getChild("left_chest");
        this.rightHindLeg = p_170724_.getChild("right_hind_leg");
        this.leftHindLeg = p_170724_.getChild("left_hind_leg");
        this.rightFrontLeg = p_170724_.getChild("right_front_leg");
        this.leftFrontLeg = p_170724_.getChild("left_front_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_170726_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -14.0f, -10.0f, 4.0f, 4.0f, 9.0f, p_170726_).texOffs(0, 14).addBox("neck", -4.0f, -16.0f, -6.0f, 8.0f, 18.0f, 6.0f, p_170726_).texOffs(17, 0).addBox("ear", -4.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, p_170726_).texOffs(17, 0).addBox("ear", 1.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, p_170726_), PartPose.offset(0.0f, 7.0f, -6.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(29, 0).addBox(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, p_170726_), PartPose.offsetAndRotation(0.0f, 5.0f, 2.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_chest", CubeListBuilder.create().texOffs(45, 28).addBox(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, p_170726_), PartPose.offsetAndRotation(-8.5f, 3.0f, 3.0f, 0.0f, 1.5707964f, 0.0f));
        partdefinition.addOrReplaceChild("left_chest", CubeListBuilder.create().texOffs(45, 41).addBox(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, p_170726_), PartPose.offsetAndRotation(5.5f, 3.0f, 3.0f, 0.0f, 1.5707964f, 0.0f));
        int i = 4;
        int j = 14;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(29, 29).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, p_170726_);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset(-3.5f, 10.0f, 6.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset(3.5f, 10.0f, 6.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset(-3.5f, 10.0f, -5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset(3.5f, 10.0f, -5.0f));
        return LayerDefinition.create(meshdefinition, 128, 64);
    }

    private static MeshDefinition transformToBaby(MeshDefinition p_361060_) {
        float f = 2.0f;
        float f1 = 0.7f;
        float f2 = 1.1f;
        UnaryOperator unaryoperator = p_359121_ -> p_359121_.translated(0.0f, 21.0f, 3.52f).scaled(0.71428573f, 0.64935064f, 0.7936508f);
        UnaryOperator unaryoperator1 = p_359123_ -> p_359123_.translated(0.0f, 33.0f, 0.0f).scaled(0.625f, 0.45454544f, 0.45454544f);
        UnaryOperator unaryoperator2 = p_359122_ -> p_359122_.translated(0.0f, 33.0f, 0.0f).scaled(0.45454544f, 0.41322312f, 0.45454544f);
        MeshDefinition meshdefinition = new MeshDefinition();
        for (Map.Entry<String, PartDefinition> entry : p_361060_.getRoot().getChildren()) {
            String s = entry.getKey();
            PartDefinition partdefinition = entry.getValue();
            UnaryOperator unaryoperator3 = switch (s) {
                case "head" -> unaryoperator;
                case "body" -> unaryoperator1;
                default -> unaryoperator2;
            };
            meshdefinition.getRoot().addOrReplaceChild(s, partdefinition.transformed(unaryoperator3));
        }
        return meshdefinition;
    }

    @Override
    public void setupAnim(LlamaRenderState p_364606_) {
        super.setupAnim(p_364606_);
        this.head.xRot = p_364606_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_364606_.yRot * ((float)Math.PI / 180);
        float f = p_364606_.walkAnimationSpeed;
        float f1 = p_364606_.walkAnimationPos;
        this.rightHindLeg.xRot = Mth.cos(f1 * 0.6662f) * 1.4f * f;
        this.leftHindLeg.xRot = Mth.cos(f1 * 0.6662f + (float)Math.PI) * 1.4f * f;
        this.rightFrontLeg.xRot = Mth.cos(f1 * 0.6662f + (float)Math.PI) * 1.4f * f;
        this.leftFrontLeg.xRot = Mth.cos(f1 * 0.6662f) * 1.4f * f;
        this.rightChest.visible = p_364606_.hasChest;
        this.leftChest.visible = p_364606_.hasChest;
    }
}

