/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.FelineRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FelineModel<T extends FelineRenderState>
extends EntityModel<T> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 10.0f, 4.0f, Set.of("head"));
    private static final float XO = 0.0f;
    private static final float YO = 16.0f;
    private static final float ZO = -9.0f;
    protected static final float BACK_LEG_Y = 18.0f;
    protected static final float BACK_LEG_Z = 5.0f;
    protected static final float FRONT_LEG_Y = 14.1f;
    private static final float FRONT_LEG_Z = -5.0f;
    private static final String TAIL_1 = "tail1";
    private static final String TAIL_2 = "tail2";
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart tail1;
    protected final ModelPart tail2;
    protected final ModelPart head;
    protected final ModelPart body;

    public FelineModel(ModelPart p_363438_) {
        super(p_363438_);
        this.head = p_363438_.getChild("head");
        this.body = p_363438_.getChild("body");
        this.tail1 = p_363438_.getChild(TAIL_1);
        this.tail2 = p_363438_.getChild(TAIL_2);
        this.leftHindLeg = p_363438_.getChild("left_hind_leg");
        this.rightHindLeg = p_363438_.getChild("right_hind_leg");
        this.leftFrontLeg = p_363438_.getChild("left_front_leg");
        this.rightFrontLeg = p_363438_.getChild("right_front_leg");
    }

    public static MeshDefinition createBodyMesh(CubeDeformation p_360911_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedeformation = new CubeDeformation(-0.02f);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().addBox("main", -2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, p_360911_).addBox("nose", -1.5f, -0.001f, -4.0f, 3, 2, 2, p_360911_, 0, 24).addBox("ear1", -2.0f, -3.0f, 0.0f, 1, 1, 2, p_360911_, 0, 10).addBox("ear2", 1.0f, -3.0f, 0.0f, 1, 1, 2, p_360911_, 6, 10), PartPose.offset(0.0f, 15.0f, -9.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(20, 0).addBox(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f, p_360911_), PartPose.offsetAndRotation(0.0f, 12.0f, -10.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(TAIL_1, CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, p_360911_), PartPose.offsetAndRotation(0.0f, 15.0f, 8.0f, 0.9f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(TAIL_2, CubeListBuilder.create().texOffs(4, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, cubedeformation), PartPose.offset(0.0f, 20.0f, 14.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, p_360911_);
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset(1.1f, 18.0f, 5.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset(-1.1f, 18.0f, 5.0f));
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, p_360911_);
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder1, PartPose.offset(1.2f, 14.1f, -5.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder1, PartPose.offset(-1.2f, 14.1f, -5.0f));
        return meshdefinition;
    }

    @Override
    public void setupAnim(T p_365420_) {
        super.setupAnim(p_365420_);
        float f = ((FelineRenderState)((Object)p_365420_)).ageScale;
        if (((FelineRenderState)((Object)p_365420_)).isCrouching) {
            this.body.y += 1.0f * f;
            this.head.y += 2.0f * f;
            this.tail1.y += 1.0f * f;
            this.tail2.y += -4.0f * f;
            this.tail2.z += 2.0f * f;
            this.tail1.xRot = 1.5707964f;
            this.tail2.xRot = 1.5707964f;
        } else if (((FelineRenderState)((Object)p_365420_)).isSprinting) {
            this.tail2.y = this.tail1.y;
            this.tail2.z += 2.0f * f;
            this.tail1.xRot = 1.5707964f;
            this.tail2.xRot = 1.5707964f;
        }
        this.head.xRot = ((FelineRenderState)((Object)p_365420_)).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((FelineRenderState)((Object)p_365420_)).yRot * ((float)Math.PI / 180);
        if (!((FelineRenderState)((Object)p_365420_)).isSitting) {
            this.body.xRot = 1.5707964f;
            float f1 = ((FelineRenderState)((Object)p_365420_)).walkAnimationSpeed;
            float f2 = ((FelineRenderState)((Object)p_365420_)).walkAnimationPos;
            if (((FelineRenderState)((Object)p_365420_)).isSprinting) {
                this.leftHindLeg.xRot = Mth.cos(f2 * 0.6662f) * f1;
                this.rightHindLeg.xRot = Mth.cos(f2 * 0.6662f + 0.3f) * f1;
                this.leftFrontLeg.xRot = Mth.cos(f2 * 0.6662f + (float)Math.PI + 0.3f) * f1;
                this.rightFrontLeg.xRot = Mth.cos(f2 * 0.6662f + (float)Math.PI) * f1;
                this.tail2.xRot = 1.7278761f + 0.31415927f * Mth.cos(f2) * f1;
            } else {
                this.leftHindLeg.xRot = Mth.cos(f2 * 0.6662f) * f1;
                this.rightHindLeg.xRot = Mth.cos(f2 * 0.6662f + (float)Math.PI) * f1;
                this.leftFrontLeg.xRot = Mth.cos(f2 * 0.6662f + (float)Math.PI) * f1;
                this.rightFrontLeg.xRot = Mth.cos(f2 * 0.6662f) * f1;
                this.tail2.xRot = !((FelineRenderState)((Object)p_365420_)).isCrouching ? 1.7278761f + 0.7853982f * Mth.cos(f2) * f1 : 1.7278761f + 0.47123894f * Mth.cos(f2) * f1;
            }
        }
        if (((FelineRenderState)((Object)p_365420_)).isSitting) {
            this.body.xRot = 0.7853982f;
            this.body.y += -4.0f * f;
            this.body.z += 5.0f * f;
            this.head.y += -3.3f * f;
            this.head.z += 1.0f * f;
            this.tail1.y += 8.0f * f;
            this.tail1.z += -2.0f * f;
            this.tail2.y += 2.0f * f;
            this.tail2.z += -0.8f * f;
            this.tail1.xRot = 1.7278761f;
            this.tail2.xRot = 2.670354f;
            this.leftFrontLeg.xRot = -0.15707964f;
            this.leftFrontLeg.y += 2.0f * f;
            this.leftFrontLeg.z -= 2.0f * f;
            this.rightFrontLeg.xRot = -0.15707964f;
            this.rightFrontLeg.y += 2.0f * f;
            this.rightFrontLeg.z -= 2.0f * f;
            this.leftHindLeg.xRot = -1.5707964f;
            this.leftHindLeg.y += 3.0f * f;
            this.leftHindLeg.z -= 4.0f * f;
            this.rightHindLeg.xRot = -1.5707964f;
            this.rightHindLeg.y += 3.0f * f;
            this.rightHindLeg.z -= 4.0f * f;
        }
        if (((FelineRenderState)((Object)p_365420_)).lieDownAmount > 0.0f) {
            this.head.zRot = Mth.rotLerp(((FelineRenderState)((Object)p_365420_)).lieDownAmount, this.head.zRot, -1.2707963f);
            this.head.yRot = Mth.rotLerp(((FelineRenderState)((Object)p_365420_)).lieDownAmount, this.head.yRot, 1.2707963f);
            this.leftFrontLeg.xRot = -1.2707963f;
            this.rightFrontLeg.xRot = -0.47079635f;
            this.rightFrontLeg.zRot = -0.2f;
            this.rightFrontLeg.x += f;
            this.leftHindLeg.xRot = -0.4f;
            this.rightHindLeg.xRot = 0.5f;
            this.rightHindLeg.zRot = -0.5f;
            this.rightHindLeg.x += 0.8f * f;
            this.rightHindLeg.y += 2.0f * f;
            this.tail1.xRot = Mth.rotLerp(((FelineRenderState)((Object)p_365420_)).lieDownAmountTail, this.tail1.xRot, 0.8f);
            this.tail2.xRot = Mth.rotLerp(((FelineRenderState)((Object)p_365420_)).lieDownAmountTail, this.tail2.xRot, -0.4f);
        }
        if (((FelineRenderState)((Object)p_365420_)).relaxStateOneAmount > 0.0f) {
            this.head.xRot = Mth.rotLerp(((FelineRenderState)((Object)p_365420_)).relaxStateOneAmount, this.head.xRot, -0.58177644f);
        }
    }
}

