/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperModel
extends EntityModel<CreeperRenderState> {
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private static final int Y_OFFSET = 6;

    public CreeperModel(ModelPart p_170524_) {
        super(p_170524_);
        this.head = p_170524_.getChild("head");
        this.leftHindLeg = p_170524_.getChild("right_hind_leg");
        this.rightHindLeg = p_170524_.getChild("left_hind_leg");
        this.leftFrontLeg = p_170524_.getChild("right_front_leg");
        this.rightFrontLeg = p_170524_.getChild("left_front_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_170526_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170526_), PartPose.offset(0.0f, 6.0f, 0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170526_), PartPose.offset(0.0f, 6.0f, 0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, p_170526_);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset(-2.0f, 18.0f, 4.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset(2.0f, 18.0f, 4.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset(-2.0f, 18.0f, -4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset(2.0f, 18.0f, -4.0f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(CreeperRenderState p_361457_) {
        super.setupAnim(p_361457_);
        this.head.yRot = p_361457_.yRot * ((float)Math.PI / 180);
        this.head.xRot = p_361457_.xRot * ((float)Math.PI / 180);
        float f = p_361457_.walkAnimationSpeed;
        float f1 = p_361457_.walkAnimationPos;
        this.rightHindLeg.xRot = Mth.cos(f1 * 0.6662f) * 1.4f * f;
        this.leftHindLeg.xRot = Mth.cos(f1 * 0.6662f + (float)Math.PI) * 1.4f * f;
        this.rightFrontLeg.xRot = Mth.cos(f1 * 0.6662f + (float)Math.PI) * 1.4f * f;
        this.leftFrontLeg.xRot = Mth.cos(f1 * 0.6662f) * 1.4f * f;
    }
}

