/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.definitions.CamelAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.CamelRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelModel
extends EntityModel<CamelRenderState> {
    private static final float MAX_WALK_ANIMATION_SPEED = 2.0f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 2.5f;
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling(0.45f);
    protected final ModelPart head;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation sitAnimation;
    private final KeyframeAnimation sitPoseAnimation;
    private final KeyframeAnimation standupAnimation;
    private final KeyframeAnimation idleAnimation;
    private final KeyframeAnimation dashAnimation;

    public CamelModel(ModelPart p_251834_) {
        super(p_251834_);
        ModelPart modelpart = p_251834_.getChild("body");
        this.head = modelpart.getChild("head");
        this.walkAnimation = CamelAnimation.CAMEL_WALK.bake(p_251834_);
        this.sitAnimation = CamelAnimation.CAMEL_SIT.bake(p_251834_);
        this.sitPoseAnimation = CamelAnimation.CAMEL_SIT_POSE.bake(p_251834_);
        this.standupAnimation = CamelAnimation.CAMEL_STANDUP.bake(p_251834_);
        this.idleAnimation = CamelAnimation.CAMEL_IDLE.bake(p_251834_);
        this.dashAnimation = CamelAnimation.CAMEL_DASH.bake(p_251834_);
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.create(CamelModel.createBodyMesh(), 128, 128);
    }

    protected static MeshDefinition createBodyMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 25).addBox(-7.5f, -12.0f, -23.5f, 15.0f, 12.0f, 27.0f), PartPose.offset(0.0f, 4.0f, 9.5f));
        partdefinition1.addOrReplaceChild("hump", CubeListBuilder.create().texOffs(74, 0).addBox(-4.5f, -5.0f, -5.5f, 9.0f, 5.0f, 11.0f), PartPose.offset(0.0f, -12.0f, -10.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(122, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 0.0f), PartPose.offset(0.0f, -9.0f, 3.5f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(60, 24).addBox(-3.5f, -7.0f, -15.0f, 7.0f, 8.0f, 19.0f).texOffs(21, 0).addBox(-3.5f, -21.0f, -15.0f, 7.0f, 14.0f, 7.0f).texOffs(50, 0).addBox(-2.5f, -21.0f, -21.0f, 5.0f, 5.0f, 6.0f), PartPose.offset(0.0f, -3.0f, -19.5f));
        partdefinition2.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(45, 0).addBox(-0.5f, 0.5f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offset(2.5f, -21.0f, -9.5f));
        partdefinition2.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(67, 0).addBox(-2.5f, 0.5f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offset(-2.5f, -21.0f, -9.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(58, 16).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(4.9f, 1.0f, 9.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(94, 16).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(-4.9f, 1.0f, 9.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(4.9f, 1.0f, -10.5f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 26).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(-4.9f, 1.0f, -10.5f));
        return meshdefinition;
    }

    @Override
    public void setupAnim(CamelRenderState p_360346_) {
        super.setupAnim(p_360346_);
        this.applyHeadRotation(p_360346_, p_360346_.yRot, p_360346_.xRot);
        this.walkAnimation.applyWalk(p_360346_.walkAnimationPos, p_360346_.walkAnimationSpeed, 2.0f, 2.5f);
        this.sitAnimation.apply(p_360346_.sitAnimationState, p_360346_.ageInTicks);
        this.sitPoseAnimation.apply(p_360346_.sitPoseAnimationState, p_360346_.ageInTicks);
        this.standupAnimation.apply(p_360346_.sitUpAnimationState, p_360346_.ageInTicks);
        this.idleAnimation.apply(p_360346_.idleAnimationState, p_360346_.ageInTicks);
        this.dashAnimation.apply(p_360346_.dashAnimationState, p_360346_.ageInTicks);
    }

    private void applyHeadRotation(CamelRenderState p_362958_, float p_249176_, float p_251814_) {
        p_249176_ = Mth.clamp(p_249176_, -30.0f, 30.0f);
        p_251814_ = Mth.clamp(p_251814_, -25.0f, 45.0f);
        if (p_362958_.jumpCooldown > 0.0f) {
            float f = 45.0f * p_362958_.jumpCooldown / 55.0f;
            p_251814_ = Mth.clamp(p_251814_ + f, -25.0f, 70.0f);
        }
        this.head.yRot = p_249176_ * ((float)Math.PI / 180);
        this.head.xRot = p_251814_ * ((float)Math.PI / 180);
    }
}

