/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record BabyModelTransform(boolean scaleHead, float babyYHeadOffset, float babyZHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset, Set<String> headParts) implements MeshTransformer
{
    public BabyModelTransform(Set<String> p_363672_) {
        this(false, 5.0f, 2.0f, p_363672_);
    }

    public BabyModelTransform(boolean p_363243_, float p_361705_, float p_364325_, Set<String> p_360719_) {
        this(p_363243_, p_361705_, p_364325_, 2.0f, 2.0f, 24.0f, p_360719_);
    }

    @Override
    public MeshDefinition apply(MeshDefinition p_364484_) {
        float f = this.scaleHead ? 1.5f / this.babyHeadScale : 1.0f;
        float f1 = 1.0f / this.babyBodyScale;
        UnaryOperator unaryoperator = p_363725_ -> p_363725_.translated(0.0f, this.babyYHeadOffset, this.babyZHeadOffset).scaled(f);
        UnaryOperator unaryoperator1 = p_362082_ -> p_362082_.translated(0.0f, this.bodyYOffset, 0.0f).scaled(f1);
        MeshDefinition meshdefinition = new MeshDefinition();
        for (Map.Entry<String, PartDefinition> entry : p_364484_.getRoot().getChildren()) {
            String s = entry.getKey();
            PartDefinition partdefinition = entry.getValue();
            meshdefinition.getRoot().addOrReplaceChild(s, partdefinition.transformed(this.headParts.contains(s) ? unaryoperator : unaryoperator1));
        }
        return meshdefinition;
    }
}

