/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.AxolotlRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AxolotlModel
extends EntityModel<AxolotlRenderState> {
    public static final float SWIMMING_LEG_XROT = 1.8849558f;
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling(0.5f);
    private final ModelPart tail;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart topGills;
    private final ModelPart leftGills;
    private final ModelPart rightGills;

    public AxolotlModel(ModelPart p_170370_) {
        super(p_170370_);
        this.body = p_170370_.getChild("body");
        this.head = this.body.getChild("head");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.tail = this.body.getChild("tail");
        this.topGills = this.head.getChild("top_gills");
        this.leftGills = this.head.getChild("left_gills");
        this.rightGills = this.head.getChild("right_gills");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f).texOffs(2, 17).addBox(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f), PartPose.offset(0.0f, 20.0f, 5.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.001f);
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 1).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, cubedeformation), PartPose.offset(0.0f, 0.0f, -9.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(3, 37).addBox(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder2 = CubeListBuilder.create().texOffs(11, 40).addBox(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, cubedeformation);
        partdefinition2.addOrReplaceChild("top_gills", cubelistbuilder, PartPose.offset(0.0f, -3.0f, -1.0f));
        partdefinition2.addOrReplaceChild("left_gills", cubelistbuilder1, PartPose.offset(-4.0f, 0.0f, -1.0f));
        partdefinition2.addOrReplaceChild("right_gills", cubelistbuilder2, PartPose.offset(4.0f, 0.0f, -1.0f));
        CubeListBuilder cubelistbuilder3 = CubeListBuilder.create().texOffs(2, 13).addBox(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder4 = CubeListBuilder.create().texOffs(2, 13).addBox(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, cubedeformation);
        partdefinition1.addOrReplaceChild("right_hind_leg", cubelistbuilder4, PartPose.offset(-3.5f, 1.0f, -1.0f));
        partdefinition1.addOrReplaceChild("left_hind_leg", cubelistbuilder3, PartPose.offset(3.5f, 1.0f, -1.0f));
        partdefinition1.addOrReplaceChild("right_front_leg", cubelistbuilder4, PartPose.offset(-3.5f, 1.0f, -8.0f));
        partdefinition1.addOrReplaceChild("left_front_leg", cubelistbuilder3, PartPose.offset(3.5f, 1.0f, -8.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(2, 19).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f), PartPose.offset(0.0f, 0.0f, 1.0f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    public void setupAnim(AxolotlRenderState p_362259_) {
        super.setupAnim(p_362259_);
        float f = p_362259_.playingDeadFactor;
        float f1 = p_362259_.inWaterFactor;
        float f2 = p_362259_.onGroundFactor;
        float f3 = p_362259_.movingFactor;
        float f4 = 1.0f - f3;
        float f5 = 1.0f - Math.min(f2, f3);
        this.body.yRot += p_362259_.yRot * ((float)Math.PI / 180);
        this.setupSwimmingAnimation(p_362259_.ageInTicks, p_362259_.xRot, Math.min(f3, f1));
        this.setupWaterHoveringAnimation(p_362259_.ageInTicks, Math.min(f4, f1));
        this.setupGroundCrawlingAnimation(p_362259_.ageInTicks, Math.min(f3, f2));
        this.setupLayStillOnGroundAnimation(p_362259_.ageInTicks, Math.min(f4, f2));
        this.setupPlayDeadAnimation(f);
        this.applyMirrorLegRotations(f5);
    }

    private void setupLayStillOnGroundAnimation(float p_170415_, float p_170416_) {
        if (!(p_170416_ <= 1.0E-5f)) {
            float f = p_170415_ * 0.09f;
            float f1 = Mth.sin(f);
            float f2 = Mth.cos(f);
            float f3 = f1 * f1 - 2.0f * f1;
            float f4 = f2 * f2 - 3.0f * f1;
            this.head.xRot += -0.09f * f3 * p_170416_;
            this.head.zRot += -0.2f * p_170416_;
            this.tail.yRot += (-0.1f + 0.1f * f3) * p_170416_;
            float f5 = (0.6f + 0.05f * f4) * p_170416_;
            this.topGills.xRot += f5;
            this.leftGills.yRot -= f5;
            this.rightGills.yRot += f5;
            this.leftHindLeg.xRot += 1.1f * p_170416_;
            this.leftHindLeg.yRot += 1.0f * p_170416_;
            this.leftFrontLeg.xRot += 0.8f * p_170416_;
            this.leftFrontLeg.yRot += 2.3f * p_170416_;
            this.leftFrontLeg.zRot -= 0.5f * p_170416_;
        }
    }

    private void setupGroundCrawlingAnimation(float p_170419_, float p_170420_) {
        if (!(p_170420_ <= 1.0E-5f)) {
            float f = p_170419_ * 0.11f;
            float f1 = Mth.cos(f);
            float f2 = (f1 * f1 - 2.0f * f1) / 5.0f;
            float f3 = 0.7f * f1;
            float f4 = 0.09f * f1 * p_170420_;
            this.head.yRot += f4;
            this.tail.yRot += f4;
            float f5 = (0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.sin(f))) * p_170420_;
            this.topGills.xRot += f5;
            this.leftGills.yRot -= f5;
            this.rightGills.yRot += f5;
            float f6 = 0.9424779f * p_170420_;
            float f7 = 1.0995574f * p_170420_;
            this.leftHindLeg.xRot += f6;
            this.leftHindLeg.yRot += (1.5f - f2) * p_170420_;
            this.leftHindLeg.zRot += -0.1f * p_170420_;
            this.leftFrontLeg.xRot += f7;
            this.leftFrontLeg.yRot += (1.5707964f - f3) * p_170420_;
            this.rightHindLeg.xRot += f6;
            this.rightHindLeg.yRot += (-1.0f - f2) * p_170420_;
            this.rightFrontLeg.xRot += f7;
            this.rightFrontLeg.yRot += (-1.5707964f - f3) * p_170420_;
        }
    }

    private void setupWaterHoveringAnimation(float p_170373_, float p_365132_) {
        if (!(p_365132_ <= 1.0E-5f)) {
            float f = p_170373_ * 0.075f;
            float f1 = Mth.cos(f);
            float f2 = Mth.sin(f) * 0.15f;
            float f3 = (-0.15f + 0.075f * f1) * p_365132_;
            this.body.xRot += f3;
            this.body.y -= f2 * p_365132_;
            this.head.xRot -= f3;
            this.topGills.xRot += 0.2f * f1 * p_365132_;
            float f4 = (-0.3f * f1 - 0.19f) * p_365132_;
            this.leftGills.yRot += f4;
            this.rightGills.yRot -= f4;
            this.leftHindLeg.xRot += (2.3561945f - f1 * 0.11f) * p_365132_;
            this.leftHindLeg.yRot += 0.47123894f * p_365132_;
            this.leftHindLeg.zRot += 1.7278761f * p_365132_;
            this.leftFrontLeg.xRot += (0.7853982f - f1 * 0.2f) * p_365132_;
            this.leftFrontLeg.yRot += 2.042035f * p_365132_;
            this.tail.yRot += 0.5f * f1 * p_365132_;
        }
    }

    private void setupSwimmingAnimation(float p_170423_, float p_170424_, float p_361875_) {
        if (!(p_361875_ <= 1.0E-5f)) {
            float f = p_170423_ * 0.33f;
            float f1 = Mth.sin(f);
            float f2 = Mth.cos(f);
            float f3 = 0.13f * f1;
            this.body.xRot += (p_170424_ * ((float)Math.PI / 180) + f3) * p_361875_;
            this.head.xRot -= f3 * 1.8f * p_361875_;
            this.body.y -= 0.45f * f2 * p_361875_;
            this.topGills.xRot += (-0.5f * f1 - 0.8f) * p_361875_;
            float f4 = (0.3f * f1 + 0.9f) * p_361875_;
            this.leftGills.yRot += f4;
            this.rightGills.yRot -= f4;
            this.tail.yRot += 0.3f * Mth.cos(f * 0.9f) * p_361875_;
            this.leftHindLeg.xRot += 1.8849558f * p_361875_;
            this.leftHindLeg.yRot += -0.4f * f1 * p_361875_;
            this.leftHindLeg.zRot += 1.5707964f * p_361875_;
            this.leftFrontLeg.xRot += 1.8849558f * p_361875_;
            this.leftFrontLeg.yRot += (-0.2f * f2 - 0.1f) * p_361875_;
            this.leftFrontLeg.zRot += 1.5707964f * p_361875_;
        }
    }

    private void setupPlayDeadAnimation(float p_170413_) {
        if (!(p_170413_ <= 1.0E-5f)) {
            this.leftHindLeg.xRot += 1.4137167f * p_170413_;
            this.leftHindLeg.yRot += 1.0995574f * p_170413_;
            this.leftHindLeg.zRot += 0.7853982f * p_170413_;
            this.leftFrontLeg.xRot += 0.7853982f * p_170413_;
            this.leftFrontLeg.yRot += 2.042035f * p_170413_;
            this.body.xRot += -0.15f * p_170413_;
            this.body.zRot += 0.35f * p_170413_;
        }
    }

    private void applyMirrorLegRotations(float p_360669_) {
        if (!(p_360669_ <= 1.0E-5f)) {
            this.rightHindLeg.xRot += this.leftHindLeg.xRot * p_360669_;
            ModelPart modelpart = this.rightHindLeg;
            modelpart.yRot += -this.leftHindLeg.yRot * p_360669_;
            modelpart = this.rightHindLeg;
            modelpart.zRot += -this.leftHindLeg.zRot * p_360669_;
            this.rightFrontLeg.xRot += this.leftFrontLeg.xRot * p_360669_;
            modelpart = this.rightFrontLeg;
            modelpart.yRot += -this.leftFrontLeg.yRot * p_360669_;
            modelpart = this.rightFrontLeg;
            modelpart.zRot += -this.leftFrontLeg.zRot * p_360669_;
        }
    }
}

