/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArrowModel
extends EntityModel<ArrowRenderState> {
    public ArrowModel(ModelPart p_360867_) {
        super(p_360867_, RenderType::entityCutout);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.5f, -2.5f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation(-11.0f, 0.0f, 0.0f, 0.7853982f, 0.0f, 0.0f).withScale(0.8f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -2.0f, 0.0f, 16.0f, 4.0f, 0.0f, CubeDeformation.NONE, 1.0f, 0.8f);
        partdefinition.addOrReplaceChild("cross_1", cubelistbuilder, PartPose.rotation(0.7853982f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("cross_2", cubelistbuilder, PartPose.rotation(2.3561945f, 0.0f, 0.0f));
        return LayerDefinition.create(meshdefinition.transformed(p_360450_ -> p_360450_.scaled(0.9f)), 32, 32);
    }

    @Override
    public void setupAnim(ArrowRenderState p_365522_) {
        super.setupAnim(p_365522_);
        if (p_365522_.shake > 0.0f) {
            float f = -Mth.sin(p_365522_.shake * 3.0f) * p_365522_.shake;
            this.root.zRot += f * ((float)Math.PI / 180);
        }
    }
}

