/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorStandArmorModel
extends HumanoidModel<ArmorStandRenderState> {
    public ArmorStandArmorModel(ModelPart p_170346_) {
        super(p_170346_);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_170348_) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh(p_170348_, 0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170348_), PartPose.offset(0.0f, 1.0f, 0.0f));
        partdefinition1.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170348_.extend(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170348_.extend(-0.1f)), PartPose.offset(-1.9f, 11.0f, 0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170348_.extend(-0.1f)), PartPose.offset(1.9f, 11.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(ArmorStandRenderState p_364632_) {
        super.setupAnim(p_364632_);
        this.head.xRot = (float)Math.PI / 180 * p_364632_.headPose.x();
        this.head.yRot = (float)Math.PI / 180 * p_364632_.headPose.y();
        this.head.zRot = (float)Math.PI / 180 * p_364632_.headPose.z();
        this.body.xRot = (float)Math.PI / 180 * p_364632_.bodyPose.x();
        this.body.yRot = (float)Math.PI / 180 * p_364632_.bodyPose.y();
        this.body.zRot = (float)Math.PI / 180 * p_364632_.bodyPose.z();
        this.leftArm.xRot = (float)Math.PI / 180 * p_364632_.leftArmPose.x();
        this.leftArm.yRot = (float)Math.PI / 180 * p_364632_.leftArmPose.y();
        this.leftArm.zRot = (float)Math.PI / 180 * p_364632_.leftArmPose.z();
        this.rightArm.xRot = (float)Math.PI / 180 * p_364632_.rightArmPose.x();
        this.rightArm.yRot = (float)Math.PI / 180 * p_364632_.rightArmPose.y();
        this.rightArm.zRot = (float)Math.PI / 180 * p_364632_.rightArmPose.z();
        this.leftLeg.xRot = (float)Math.PI / 180 * p_364632_.leftLegPose.x();
        this.leftLeg.yRot = (float)Math.PI / 180 * p_364632_.leftLegPose.y();
        this.leftLeg.zRot = (float)Math.PI / 180 * p_364632_.leftLegPose.z();
        this.rightLeg.xRot = (float)Math.PI / 180 * p_364632_.rightLegPose.x();
        this.rightLeg.yRot = (float)Math.PI / 180 * p_364632_.rightLegPose.y();
        this.rightLeg.zRot = (float)Math.PI / 180 * p_364632_.rightLegPose.z();
    }
}

