/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationUtils {
    public static void animateCrossbowHold(ModelPart p_102098_, ModelPart p_102099_, ModelPart p_102100_, boolean p_102101_) {
        ModelPart modelpart = p_102101_ ? p_102098_ : p_102099_;
        ModelPart modelpart1 = p_102101_ ? p_102099_ : p_102098_;
        modelpart.yRot = (p_102101_ ? -0.3f : 0.3f) + p_102100_.yRot;
        modelpart1.yRot = (p_102101_ ? 0.6f : -0.6f) + p_102100_.yRot;
        modelpart.xRot = -1.5707964f + p_102100_.xRot + 0.1f;
        modelpart1.xRot = -1.5f + p_102100_.xRot;
    }

    public static void animateCrossbowCharge(ModelPart p_102087_, ModelPart p_102088_, float p_364463_, int p_363802_, boolean p_102090_) {
        ModelPart modelpart = p_102090_ ? p_102087_ : p_102088_;
        ModelPart modelpart1 = p_102090_ ? p_102088_ : p_102087_;
        modelpart.yRot = p_102090_ ? -0.8f : 0.8f;
        modelpart1.xRot = modelpart.xRot = -0.97079635f;
        float f = Mth.clamp((float)p_363802_, 0.0f, p_364463_);
        float f1 = f / p_364463_;
        modelpart1.yRot = Mth.lerp(f1, 0.4f, 0.85f) * (float)(p_102090_ ? 1 : -1);
        modelpart1.xRot = Mth.lerp(f1, modelpart1.xRot, -1.5707964f);
    }

    public static void swingWeaponDown(ModelPart p_102092_, ModelPart p_102093_, HumanoidArm p_362928_, float p_102095_, float p_102096_) {
        float f = Mth.sin(p_102095_ * (float)Math.PI);
        float f1 = Mth.sin((1.0f - (1.0f - p_102095_) * (1.0f - p_102095_)) * (float)Math.PI);
        p_102092_.zRot = 0.0f;
        p_102093_.zRot = 0.0f;
        p_102092_.yRot = 0.15707964f;
        p_102093_.yRot = -0.15707964f;
        if (p_362928_ == HumanoidArm.RIGHT) {
            p_102092_.xRot = -1.8849558f + Mth.cos(p_102096_ * 0.09f) * 0.15f;
            p_102093_.xRot = -0.0f + Mth.cos(p_102096_ * 0.19f) * 0.5f;
            p_102092_.xRot += f * 2.2f - f1 * 0.4f;
            p_102093_.xRot += f * 1.2f - f1 * 0.4f;
        } else {
            p_102092_.xRot = -0.0f + Mth.cos(p_102096_ * 0.19f) * 0.5f;
            p_102093_.xRot = -1.8849558f + Mth.cos(p_102096_ * 0.09f) * 0.15f;
            p_102092_.xRot += f * 1.2f - f1 * 0.4f;
            p_102093_.xRot += f * 2.2f - f1 * 0.4f;
        }
        AnimationUtils.bobArms(p_102092_, p_102093_, p_102096_);
    }

    public static void bobModelPart(ModelPart p_170342_, float p_170343_, float p_170344_) {
        p_170342_.zRot += p_170344_ * (Mth.cos(p_170343_ * 0.09f) * 0.05f + 0.05f);
        p_170342_.xRot += p_170344_ * (Mth.sin(p_170343_ * 0.067f) * 0.05f);
    }

    public static void bobArms(ModelPart p_102083_, ModelPart p_102084_, float p_102085_) {
        AnimationUtils.bobModelPart(p_102083_, p_102085_, 1.0f);
        AnimationUtils.bobModelPart(p_102084_, p_102085_, -1.0f);
    }

    public static void animateZombieArms(ModelPart p_102103_, ModelPart p_102104_, boolean p_102105_, float p_102106_, float p_102107_) {
        float f2;
        float f = Mth.sin(p_102106_ * (float)Math.PI);
        float f1 = Mth.sin((1.0f - (1.0f - p_102106_) * (1.0f - p_102106_)) * (float)Math.PI);
        p_102104_.zRot = 0.0f;
        p_102103_.zRot = 0.0f;
        p_102104_.yRot = -(0.1f - f * 0.6f);
        p_102103_.yRot = 0.1f - f * 0.6f;
        p_102104_.xRot = f2 = (float)(-Math.PI) / (p_102105_ ? 1.5f : 2.25f);
        p_102103_.xRot = f2;
        p_102104_.xRot += f * 1.2f - f1 * 0.4f;
        p_102103_.xRot += f * 1.2f - f1 * 0.4f;
        AnimationUtils.bobArms(p_102104_, p_102103_, p_102107_);
    }
}

