/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.AllayRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class AllayModel
extends EntityModel<AllayRenderState>
implements ArmedModel {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;
    private static final float FLYING_ANIMATION_X_ROT = 0.7853982f;
    private static final float MAX_HAND_HOLDING_ITEM_X_ROT_RAD = -1.134464f;
    private static final float MIN_HAND_HOLDING_ITEM_X_ROT_RAD = -1.0471976f;

    public AllayModel(ModelPart p_233312_) {
        super(p_233312_.getChild("root"), RenderType::entityTranslucent);
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.right_arm = this.body.getChild("right_arm");
        this.left_arm = this.body.getChild("left_arm");
        this.right_wing = this.body.getChild("right_wing");
        this.left_wing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset(0.0f, 23.5f, 0.0f));
        partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, -3.99f, 0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset(0.0f, -4.0f, 0.0f));
        partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset(-1.75f, 0.5f, 0.0f));
        partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 6).addBox(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset(1.75f, 0.5f, 0.0f));
        partdefinition2.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(-0.5f, 0.0f, 0.6f));
        partdefinition2.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(0.5f, 0.0f, 0.6f));
        return LayerDefinition.create(meshdefinition, 32, 32);
    }

    @Override
    public void setupAnim(AllayRenderState p_365028_) {
        super.setupAnim(p_365028_);
        float f = p_365028_.walkAnimationSpeed;
        float f1 = p_365028_.walkAnimationPos;
        float f2 = p_365028_.ageInTicks * 20.0f * ((float)Math.PI / 180) + f1;
        float f3 = Mth.cos(f2) * (float)Math.PI * 0.15f + f;
        float f4 = p_365028_.ageInTicks * 9.0f * ((float)Math.PI / 180);
        float f5 = Math.min(f / 0.3f, 1.0f);
        float f6 = 1.0f - f5;
        float f7 = p_365028_.holdingAnimationProgress;
        if (p_365028_.isDancing) {
            float f8 = p_365028_.ageInTicks * 8.0f * ((float)Math.PI / 180) + f;
            float f9 = Mth.cos(f8) * 16.0f * ((float)Math.PI / 180);
            float f10 = p_365028_.spinningProgress;
            float f11 = Mth.cos(f8) * 14.0f * ((float)Math.PI / 180);
            float f12 = Mth.cos(f8) * 30.0f * ((float)Math.PI / 180);
            this.root.yRot = p_365028_.isSpinning ? (float)Math.PI * 4 * f10 : this.root.yRot;
            this.root.zRot = f9 * (1.0f - f10);
            this.head.yRot = f12 * (1.0f - f10);
            this.head.zRot = f11 * (1.0f - f10);
        } else {
            this.head.xRot = p_365028_.xRot * ((float)Math.PI / 180);
            this.head.yRot = p_365028_.yRot * ((float)Math.PI / 180);
        }
        this.right_wing.xRot = 0.43633232f * (1.0f - f5);
        this.right_wing.yRot = -0.7853982f + f3;
        this.left_wing.xRot = 0.43633232f * (1.0f - f5);
        this.left_wing.yRot = 0.7853982f - f3;
        this.body.xRot = f5 * 0.7853982f;
        float f13 = f7 * Mth.lerp(f5, -1.0471976f, -1.134464f);
        this.root.y += (float)Math.cos(f4) * 0.25f * f6;
        this.right_arm.xRot = f13;
        this.left_arm.xRot = f13;
        float f14 = f6 * (1.0f - f7);
        float f15 = 0.43633232f - Mth.cos(f4 + 4.712389f) * (float)Math.PI * 0.075f * f14;
        this.left_arm.zRot = -f15;
        this.right_arm.zRot = f15;
        this.right_arm.yRot = 0.27925268f * f7;
        this.left_arm.yRot = -0.27925268f * f7;
    }

    @Override
    public void translateToHand(HumanoidArm p_233322_, PoseStack p_233323_) {
        float f = 1.0f;
        float f1 = 3.0f;
        this.root.translateAndRotate(p_233323_);
        this.body.translateAndRotate(p_233323_);
        p_233323_.translate(0.0f, 0.0625f, 0.1875f);
        p_233323_.mulPose((Quaternionfc)Axis.XP.rotation(this.right_arm.xRot));
        p_233323_.scale(0.7f, 0.7f, 0.7f);
        p_233323_.translate(0.0625f, 0.0f, 0.0f);
    }
}

