/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractPiglinModel<S extends HumanoidRenderState>
extends HumanoidModel<S> {
    private static final String LEFT_SLEEVE = "left_sleeve";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_PANTS = "left_pants";
    private static final String RIGHT_PANTS = "right_pants";
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    public final ModelPart rightEar;
    public final ModelPart leftEar;

    public AbstractPiglinModel(ModelPart p_362482_) {
        super(p_362482_, RenderType::entityTranslucent);
        this.leftSleeve = this.leftArm.getChild(LEFT_SLEEVE);
        this.rightSleeve = this.rightArm.getChild(RIGHT_SLEEVE);
        this.leftPants = this.leftLeg.getChild(LEFT_PANTS);
        this.rightPants = this.rightLeg.getChild(RIGHT_PANTS);
        this.jacket = this.body.getChild("jacket");
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
    }

    public static MeshDefinition createMesh(CubeDeformation p_363071_) {
        MeshDefinition meshdefinition = PlayerModel.createMesh(p_363071_, false);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_363071_), PartPose.ZERO);
        PartDefinition partdefinition1 = AbstractPiglinModel.addHead(p_363071_, meshdefinition);
        partdefinition1.clearChild("hat");
        return meshdefinition;
    }

    public static PartDefinition addHead(CubeDeformation p_362117_, MeshDefinition p_365125_) {
        PartDefinition partdefinition = p_365125_.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, p_362117_).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, p_362117_).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_362117_).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_362117_), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(51, 6).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_362117_), PartPose.offsetAndRotation(4.5f, -6.0f, 0.0f, 0.0f, 0.0f, -0.5235988f));
        partdefinition1.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(39, 6).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_362117_), PartPose.offsetAndRotation(-4.5f, -6.0f, 0.0f, 0.0f, 0.0f, 0.5235988f));
        return partdefinition1;
    }

    @Override
    public void setupAnim(S p_361522_) {
        super.setupAnim(p_361522_);
        float f = ((HumanoidRenderState)((Object)p_361522_)).walkAnimationPos;
        float f1 = ((HumanoidRenderState)((Object)p_361522_)).walkAnimationSpeed;
        float f2 = 0.5235988f;
        float f3 = ((HumanoidRenderState)((Object)p_361522_)).ageInTicks * 0.1f + f * 0.5f;
        float f4 = 0.08f + f1 * 0.4f;
        this.leftEar.zRot = -0.5235988f - Mth.cos(f3 * 1.2f) * f4;
        this.rightEar.zRot = 0.5235988f + Mth.cos(f3) * f4;
    }

    @Override
    public void setAllVisible(boolean p_360597_) {
        super.setAllVisible(p_360597_);
        this.leftSleeve.visible = p_360597_;
        this.rightSleeve.visible = p_360597_;
        this.leftPants.visible = p_360597_;
        this.rightPants.visible = p_360597_;
        this.jacket.visible = p_360597_;
    }
}

