/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractEquineModel<T extends EquineRenderState>
extends EntityModel<T> {
    private static final float DEG_125 = 2.1816616f;
    private static final float DEG_60 = 1.0471976f;
    private static final float DEG_45 = 0.7853982f;
    private static final float DEG_30 = 0.5235988f;
    private static final float DEG_15 = 0.2617994f;
    protected static final String HEAD_PARTS = "head_parts";
    protected static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f, Set.of("head_parts"));
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;

    public AbstractEquineModel(ModelPart p_362475_) {
        super(p_362475_);
        this.body = p_362475_.getChild("body");
        this.headParts = p_362475_.getChild(HEAD_PARTS);
        this.rightHindLeg = p_362475_.getChild("right_hind_leg");
        this.leftHindLeg = p_362475_.getChild("left_hind_leg");
        this.rightFrontLeg = p_362475_.getChild("right_front_leg");
        this.leftFrontLeg = p_362475_.getChild("left_front_leg");
        this.tail = this.body.getChild("tail");
    }

    public static MeshDefinition createBodyMesh(CubeDeformation p_362889_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.offset(0.0f, 11.0f, 5.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild(HEAD_PARTS, CubeListBuilder.create().texOffs(0, 35).addBox(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.offsetAndRotation(0.0f, 4.0f, -12.0f, 0.5235988f, 0.0f, 0.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, p_362889_), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(56, 36).addBox(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, p_362889_), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, p_362889_), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(4.0f, 14.0f, 7.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(-4.0f, 14.0f, 7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(4.0f, 14.0f, -10.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(-4.0f, 14.0f, -10.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(42, 36).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, p_362889_), PartPose.offsetAndRotation(0.0f, -5.0f, 2.0f, 0.5235988f, 0.0f, 0.0f));
        partdefinition3.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(19, 16).addBox(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        partdefinition3.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(19, 16).addBox(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        return meshdefinition;
    }

    public static MeshDefinition createBabyMesh(CubeDeformation p_361910_) {
        return BABY_TRANSFORMER.apply(AbstractEquineModel.createFullScaleBabyMesh(p_361910_));
    }

    protected static MeshDefinition createFullScaleBabyMesh(CubeDeformation p_360459_) {
        MeshDefinition meshdefinition = AbstractEquineModel.createBodyMesh(p_360459_);
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedeformation = p_360459_.extend(0.0f, 5.5f, 0.0f);
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset(4.0f, 14.0f, 7.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset(-4.0f, 14.0f, 7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset(4.0f, 14.0f, -10.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset(-4.0f, 14.0f, -10.0f));
        return meshdefinition;
    }

    @Override
    public void setupAnim(T p_363341_) {
        super.setupAnim(p_363341_);
        float f = Mth.clamp(((EquineRenderState)((Object)p_363341_)).yRot, -20.0f, 20.0f);
        float f1 = ((EquineRenderState)((Object)p_363341_)).xRot * ((float)Math.PI / 180);
        float f2 = ((EquineRenderState)((Object)p_363341_)).walkAnimationSpeed;
        float f3 = ((EquineRenderState)((Object)p_363341_)).walkAnimationPos;
        if (f2 > 0.2f) {
            f1 += Mth.cos(f3 * 0.8f) * 0.15f * f2;
        }
        float f4 = ((EquineRenderState)((Object)p_363341_)).eatAnimation;
        float f5 = ((EquineRenderState)((Object)p_363341_)).standAnimation;
        float f6 = 1.0f - f5;
        float f7 = ((EquineRenderState)((Object)p_363341_)).feedingAnimation;
        boolean flag = ((EquineRenderState)((Object)p_363341_)).animateTail;
        this.headParts.xRot = 0.5235988f + f1;
        this.headParts.yRot = f * ((float)Math.PI / 180);
        float f8 = ((EquineRenderState)((Object)p_363341_)).isInWater ? 0.2f : 1.0f;
        float f9 = Mth.cos(f8 * f3 * 0.6662f + (float)Math.PI);
        float f10 = f9 * 0.8f * f2;
        float f11 = (1.0f - Math.max(f5, f4)) * (0.5235988f + f1 + f7 * Mth.sin(((EquineRenderState)((Object)p_363341_)).ageInTicks) * 0.05f);
        this.headParts.xRot = f5 * (0.2617994f + f1) + f4 * (2.1816616f + Mth.sin(((EquineRenderState)((Object)p_363341_)).ageInTicks) * 0.05f) + f11;
        this.headParts.yRot = f5 * f * ((float)Math.PI / 180) + (1.0f - Math.max(f5, f4)) * this.headParts.yRot;
        float f12 = ((EquineRenderState)((Object)p_363341_)).ageScale;
        this.headParts.y += Mth.lerp(f4, Mth.lerp(f5, 0.0f, -8.0f * f12), 7.0f * f12);
        this.headParts.z = Mth.lerp(f5, this.headParts.z, -4.0f * f12);
        this.body.xRot = f5 * -0.7853982f + f6 * this.body.xRot;
        float f13 = 0.2617994f * f5;
        float f14 = Mth.cos(((EquineRenderState)((Object)p_363341_)).ageInTicks * 0.6f + (float)Math.PI);
        this.leftFrontLeg.y -= 12.0f * f12 * f5;
        this.leftFrontLeg.z += 4.0f * f12 * f5;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        float f15 = (-1.0471976f + f14) * f5 + f10 * f6;
        float f16 = (-1.0471976f - f14) * f5 - f10 * f6;
        this.leftHindLeg.xRot = f13 - f9 * 0.5f * f2 * f6;
        this.rightHindLeg.xRot = f13 + f9 * 0.5f * f2 * f6;
        this.leftFrontLeg.xRot = f15;
        this.rightFrontLeg.xRot = f16;
        this.tail.xRot = 0.5235988f + f2 * 0.75f;
        this.tail.y += f2 * f12;
        this.tail.z += f2 * 2.0f * f12;
        this.tail.yRot = flag ? Mth.cos(((EquineRenderState)((Object)p_363341_)).ageInTicks * 0.7f) : 0.0f;
    }
}

