/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.BoatRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractBoatModel
extends EntityModel<BoatRenderState> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;

    public AbstractBoatModel(ModelPart p_376707_) {
        super(p_376707_);
        this.leftPaddle = p_376707_.getChild("left_paddle");
        this.rightPaddle = p_376707_.getChild("right_paddle");
    }

    @Override
    public void setupAnim(BoatRenderState p_376907_) {
        super.setupAnim(p_376907_);
        AbstractBoatModel.animatePaddle(p_376907_.rowingTimeLeft, 0, this.leftPaddle);
        AbstractBoatModel.animatePaddle(p_376907_.rowingTimeRight, 1, this.rightPaddle);
    }

    private static void animatePaddle(float p_376567_, int p_376720_, ModelPart p_376932_) {
        p_376932_.xRot = Mth.clampedLerp(-1.0471976f, -0.2617994f, (Mth.sin(-p_376567_) + 1.0f) / 2.0f);
        p_376932_.yRot = Mth.clampedLerp(-0.7853982f, 0.7853982f, (Mth.sin(-p_376567_ + 1.0f) + 1.0f) / 2.0f);
        if (p_376720_ == 1) {
            p_376932_.yRot = (float)Math.PI - p_376932_.yRot;
        }
    }
}

