/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.spectator.categories;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.client.gui.spectator.SpectatorMenuCategory;
import net.minecraft.client.gui.spectator.SpectatorMenuItem;
import net.minecraft.client.gui.spectator.categories.TeleportToPlayerMenuCategory;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TeleportToTeamMenuCategory
implements SpectatorMenuCategory,
SpectatorMenuItem {
    private static final ResourceLocation TELEPORT_TO_TEAM_SPRITE = ResourceLocation.withDefaultNamespace("spectator/teleport_to_team");
    private static final Component TELEPORT_TEXT = Component.translatable("spectatorMenu.team_teleport");
    private static final Component TELEPORT_PROMPT = Component.translatable("spectatorMenu.team_teleport.prompt");
    private final List<SpectatorMenuItem> items;

    public TeleportToTeamMenuCategory() {
        Minecraft minecraft = Minecraft.getInstance();
        this.items = TeleportToTeamMenuCategory.createTeamEntries(minecraft, minecraft.level.getScoreboard());
    }

    private static List<SpectatorMenuItem> createTeamEntries(Minecraft p_260258_, Scoreboard p_259249_) {
        return p_259249_.getPlayerTeams().stream().flatMap(p_260025_ -> TeamSelectionItem.create(p_260258_, p_260025_).stream()).toList();
    }

    @Override
    public List<SpectatorMenuItem> getItems() {
        return this.items;
    }

    @Override
    public Component getPrompt() {
        return TELEPORT_PROMPT;
    }

    @Override
    public void selectItem(SpectatorMenu p_101886_) {
        p_101886_.selectCategory(this);
    }

    @Override
    public Component getName() {
        return TELEPORT_TEXT;
    }

    @Override
    public void renderIcon(GuiGraphics p_282933_, float p_283568_, float p_365205_) {
        p_282933_.blitSprite(RenderPipelines.GUI_TEXTURED, TELEPORT_TO_TEAM_SPRITE, 0, 0, 16, 16, ARGB.colorFromFloat(p_365205_, p_283568_, p_283568_, p_283568_));
    }

    @Override
    public boolean isEnabled() {
        return !this.items.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TeamSelectionItem
    implements SpectatorMenuItem {
        private final PlayerTeam team;
        private final Supplier<PlayerSkin> iconSkin;
        private final List<PlayerInfo> players;

        private TeamSelectionItem(PlayerTeam p_259176_, List<PlayerInfo> p_259231_, Supplier<PlayerSkin> p_294955_) {
            this.team = p_259176_;
            this.players = p_259231_;
            this.iconSkin = p_294955_;
        }

        public static Optional<SpectatorMenuItem> create(Minecraft p_260048_, PlayerTeam p_259058_) {
            ArrayList<PlayerInfo> list = new ArrayList<PlayerInfo>();
            for (String s : p_259058_.getPlayers()) {
                PlayerInfo playerinfo = p_260048_.getConnection().getPlayerInfo(s);
                if (playerinfo == null || playerinfo.getGameMode() == GameType.SPECTATOR) continue;
                list.add(playerinfo);
            }
            if (list.isEmpty()) {
                return Optional.empty();
            }
            GameProfile gameprofile = ((PlayerInfo)list.get(RandomSource.create().nextInt(list.size()))).getProfile();
            Supplier<PlayerSkin> supplier = p_260048_.getSkinManager().lookupInsecure(gameprofile);
            return Optional.of(new TeamSelectionItem(p_259058_, list, supplier));
        }

        @Override
        public void selectItem(SpectatorMenu p_101902_) {
            p_101902_.selectCategory(new TeleportToPlayerMenuCategory(this.players));
        }

        @Override
        public Component getName() {
            return this.team.getDisplayName();
        }

        @Override
        public void renderIcon(GuiGraphics p_283215_, float p_282946_, float p_360612_) {
            Integer integer = this.team.getColor().getColor();
            if (integer != null) {
                float f = (float)(integer >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(integer >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(integer & 0xFF) / 255.0f;
                p_283215_.fill(1, 1, 15, 15, ARGB.colorFromFloat(p_360612_, f * p_282946_, f1 * p_282946_, f2 * p_282946_));
            }
            PlayerFaceRenderer.draw(p_283215_, this.iconSkin.get(), 2, 2, 12, ARGB.colorFromFloat(p_360612_, p_282946_, p_282946_, p_282946_));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

