/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import java.util.List;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RecipeBookTabButton
extends StateSwitchingButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/tab"), ResourceLocation.withDefaultNamespace("recipe_book/tab_selected"));
    private final RecipeBookComponent.TabInfo tabInfo;
    private static final float ANIMATION_TIME = 15.0f;
    private float animationTime;

    public RecipeBookTabButton(RecipeBookComponent.TabInfo p_379856_) {
        super(0, 0, 35, 27, false);
        this.tabInfo = p_379856_;
        this.initTextureValues(SPRITES);
    }

    public void startAnimation(ClientRecipeBook p_361190_, boolean p_362968_) {
        RecipeCollection.CraftableStatus recipecollection$craftablestatus = p_362968_ ? RecipeCollection.CraftableStatus.CRAFTABLE : RecipeCollection.CraftableStatus.ANY;
        for (RecipeCollection recipecollection : p_361190_.getCollection(this.tabInfo.category())) {
            for (RecipeDisplayEntry recipedisplayentry : recipecollection.getSelectedRecipes(recipecollection$craftablestatus)) {
                if (!p_361190_.willHighlight(recipedisplayentry.id())) continue;
                this.animationTime = 15.0f;
                return;
            }
        }
    }

    @Override
    public void renderWidget(GuiGraphics p_283195_, int p_283508_, int p_281788_, float p_283269_) {
        if (this.sprites != null) {
            if (this.animationTime > 0.0f) {
                float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
                p_283195_.pose().pushMatrix();
                p_283195_.pose().translate((float)(this.getX() + 8), (float)(this.getY() + 12));
                p_283195_.pose().scale(1.0f, f);
                p_283195_.pose().translate((float)(-(this.getX() + 8)), (float)(-(this.getY() + 12)));
            }
            ResourceLocation resourcelocation = this.sprites.get(true, this.isStateTriggered);
            int i = this.getX();
            if (this.isStateTriggered) {
                i -= 2;
            }
            p_283195_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, i, this.getY(), this.width, this.height);
            this.renderIcon(p_283195_);
            if (this.animationTime > 0.0f) {
                p_283195_.pose().popMatrix();
                this.animationTime -= p_283269_;
            }
        }
    }

    private void renderIcon(GuiGraphics p_281802_) {
        int i;
        int n = i = this.isStateTriggered ? -2 : 0;
        if (this.tabInfo.secondaryIcon().isPresent()) {
            p_281802_.renderFakeItem(this.tabInfo.primaryIcon(), this.getX() + 3 + i, this.getY() + 5);
            p_281802_.renderFakeItem(this.tabInfo.secondaryIcon().get(), this.getX() + 14 + i, this.getY() + 5);
        } else {
            p_281802_.renderFakeItem(this.tabInfo.primaryIcon(), this.getX() + 9 + i, this.getY() + 5);
        }
    }

    public ExtendedRecipeBookCategory getCategory() {
        return this.tabInfo.category();
    }

    public boolean updateVisibility(ClientRecipeBook p_100450_) {
        List<RecipeCollection> list = p_100450_.getCollection(this.tabInfo.category());
        this.visible = false;
        for (RecipeCollection recipecollection : list) {
            if (!recipecollection.hasAnySelected()) continue;
            this.visible = true;
            break;
        }
        return this.visible;
    }
}

