/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TestBlockEditScreen
extends Screen {
    private static final List<TestBlockMode> MODES = List.of(TestBlockMode.values());
    private static final Component TITLE = Component.translatable(Blocks.TEST_BLOCK.getDescriptionId());
    private static final Component MESSAGE_LABEL = Component.translatable("test_block.message");
    private final BlockPos position;
    private TestBlockMode mode;
    private String message;
    @Nullable
    private EditBox messageEdit;

    public TestBlockEditScreen(TestBlockEntity p_397500_) {
        super(TITLE);
        this.position = p_397500_.getBlockPos();
        this.mode = p_397500_.getMode();
        this.message = p_397500_.getMessage();
    }

    @Override
    public void init() {
        this.messageEdit = new EditBox(this.font, this.width / 2 - 152, 80, 240, 20, Component.translatable("test_block.message"));
        this.messageEdit.setMaxLength(128);
        this.messageEdit.setValue(this.message);
        this.addRenderableWidget(this.messageEdit);
        this.setInitialFocus(this.messageEdit);
        this.updateMode(this.mode);
        this.addRenderableWidget(CycleButton.builder(TestBlockMode::getDisplayName).withValues((Collection<TestBlockMode>)MODES).displayOnlyValue().withInitialValue(this.mode).create(this.width / 2 - 4 - 150, 185, 50, 20, TITLE, (p_397349_, p_397276_) -> this.updateMode((TestBlockMode)p_397276_)));
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_DONE, p_397828_ -> this.onDone()).bounds(this.width / 2 - 4 - 150, 210, 150, 20).build());
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_397482_ -> this.onCancel()).bounds(this.width / 2 + 4, 210, 150, 20).build());
    }

    @Override
    public void render(GuiGraphics p_397107_, int p_397213_, int p_397981_, float p_397804_) {
        super.render(p_397107_, p_397213_, p_397981_, p_397804_);
        p_397107_.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
        if (this.mode != TestBlockMode.START) {
            p_397107_.drawString(this.font, MESSAGE_LABEL, this.width / 2 - 153, 70, -6250336);
        }
        p_397107_.drawString(this.font, this.mode.getDetailedMessage(), this.width / 2 - 153, 174, -6250336);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    private void onDone() {
        this.message = this.messageEdit.getValue();
        this.minecraft.getConnection().send(new ServerboundSetTestBlockPacket(this.position, this.mode, this.message));
        this.onClose();
    }

    @Override
    public void onClose() {
        this.onCancel();
    }

    private void onCancel() {
        this.minecraft.setScreen(null);
    }

    private void updateMode(TestBlockMode p_397565_) {
        this.mode = p_397565_;
        this.messageEdit.visible = p_397565_ != TestBlockMode.START;
    }

    @Override
    public void renderBackground(GuiGraphics p_399499_, int p_399635_, int p_399466_, float p_400178_) {
        this.renderTransparentBackground(p_399499_);
    }
}

