/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.recipebook.FurnaceRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractFurnaceScreen<T extends AbstractFurnaceMenu>
extends AbstractRecipeBookScreen<T> {
    private final ResourceLocation texture;
    private final ResourceLocation litProgressSprite;
    private final ResourceLocation burnProgressSprite;

    public AbstractFurnaceScreen(T p_97825_, Inventory p_97827_, Component p_97828_, Component p_361732_, ResourceLocation p_97829_, ResourceLocation p_296257_, ResourceLocation p_295751_, List<RecipeBookComponent.TabInfo> p_380222_) {
        super(p_97825_, new FurnaceRecipeBookComponent((AbstractFurnaceMenu)p_97825_, p_361732_, p_380222_), p_97827_, p_97828_);
        this.texture = p_97829_;
        this.litProgressSprite = p_296257_;
        this.burnProgressSprite = p_295751_;
    }

    @Override
    public void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width(this.title)) / 2;
    }

    @Override
    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 20, this.height / 2 - 49);
    }

    @Override
    protected void renderBg(GuiGraphics p_282928_, float p_281631_, int p_281252_, int p_281891_) {
        int i = this.leftPos;
        int j = this.topPos;
        p_282928_.blit(RenderPipelines.GUI_TEXTURED, this.texture, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((AbstractFurnaceMenu)this.menu).isLit()) {
            int k = 14;
            int l = Mth.ceil(((AbstractFurnaceMenu)this.menu).getLitProgress() * 13.0f) + 1;
            p_282928_.blitSprite(RenderPipelines.GUI_TEXTURED, this.litProgressSprite, 14, 14, 0, 14 - l, i + 56, j + 36 + 14 - l, 14, l);
        }
        int i1 = 24;
        int j1 = Mth.ceil(((AbstractFurnaceMenu)this.menu).getBurnProgress() * 24.0f);
        p_282928_.blitSprite(RenderPipelines.GUI_TEXTURED, this.burnProgressSprite, 24, 16, 0, 0, i + 79, j + 34, j1, 16);
    }
}

