/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.dialog.body;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.ItemDisplayWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.dialog.DialogScreen;
import net.minecraft.client.gui.screens.dialog.body.DialogBodyHandler;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Style;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.body.ItemBody;
import net.minecraft.server.dialog.body.PlainMessage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogBodyHandlers {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<MapCodec<? extends DialogBody>, DialogBodyHandler<?>> HANDLERS = new HashMap();

    private static <B extends DialogBody> void register(MapCodec<B> p_425949_, DialogBodyHandler<? super B> p_426018_) {
        HANDLERS.put(p_425949_, p_426018_);
    }

    @Nullable
    private static <B extends DialogBody> DialogBodyHandler<B> getHandler(B p_426294_) {
        return HANDLERS.get(p_426294_.mapCodec());
    }

    @Nullable
    public static <B extends DialogBody> LayoutElement createBodyElement(DialogScreen<?> p_428209_, B p_425979_) {
        DialogBodyHandler<B> dialogbodyhandler = DialogBodyHandlers.getHandler(p_425979_);
        if (dialogbodyhandler == null) {
            LOGGER.warn("Unrecognized dialog body {}", p_425979_);
            return null;
        }
        return dialogbodyhandler.createControls(p_428209_, p_425979_);
    }

    public static void bootstrap() {
        DialogBodyHandlers.register(PlainMessage.MAP_CODEC, new PlainMessageHandler());
        DialogBodyHandlers.register(ItemBody.MAP_CODEC, new ItemHandler());
    }

    static void runActionOnParent(DialogScreen<?> p_428343_, @Nullable Style p_428509_) {
        ClickEvent clickevent;
        if (p_428509_ != null && (clickevent = p_428509_.getClickEvent()) != null) {
            p_428343_.runAction(Optional.of(clickevent));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PlainMessageHandler
    implements DialogBodyHandler<PlainMessage> {
        PlainMessageHandler() {
        }

        @Override
        public LayoutElement createControls(DialogScreen<?> p_428310_, PlainMessage p_428489_) {
            return new FocusableTextWidget(p_428489_.width(), p_428489_.contents(), p_428310_.getFont(), false, false, 4).configureStyleHandling(true, p_428435_ -> DialogBodyHandlers.runActionOnParent(p_428310_, p_428435_)).setCentered(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ItemHandler
    implements DialogBodyHandler<ItemBody> {
        ItemHandler() {
        }

        @Override
        public LayoutElement createControls(DialogScreen<?> p_428557_, ItemBody p_426083_) {
            if (p_426083_.description().isPresent()) {
                PlainMessage plainmessage = p_426083_.description().get();
                LinearLayout linearlayout = LinearLayout.horizontal().spacing(2);
                linearlayout.defaultCellSetting().alignVerticallyMiddle();
                ItemDisplayWidget itemdisplaywidget = new ItemDisplayWidget(Minecraft.getInstance(), 0, 0, p_426083_.width(), p_426083_.height(), CommonComponents.EMPTY, p_426083_.item(), p_426083_.showDecorations(), p_426083_.showTooltip());
                linearlayout.addChild(itemdisplaywidget);
                linearlayout.addChild(new FocusableTextWidget(plainmessage.width(), plainmessage.contents(), p_428557_.getFont(), false, false, 4).configureStyleHandling(true, p_428473_ -> DialogBodyHandlers.runActionOnParent(p_428557_, p_428473_)));
                return linearlayout;
            }
            return new ItemDisplayWidget(Minecraft.getInstance(), 0, 0, p_426083_.width(), p_426083_.height(), p_426083_.item().getHoverName(), p_426083_.item(), p_426083_.showDecorations(), p_426083_.showTooltip());
        }
    }
}

