/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.dialog;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.dialog.DialogConnectionAccess;
import net.minecraft.client.gui.screens.dialog.DialogListDialogScreen;
import net.minecraft.client.gui.screens.dialog.DialogScreen;
import net.minecraft.client.gui.screens.dialog.MultiButtonDialogScreen;
import net.minecraft.client.gui.screens.dialog.ServerLinksDialogScreen;
import net.minecraft.client.gui.screens.dialog.SimpleDialogScreen;
import net.minecraft.server.dialog.ConfirmationDialog;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogListDialog;
import net.minecraft.server.dialog.MultiActionDialog;
import net.minecraft.server.dialog.NoticeDialog;
import net.minecraft.server.dialog.ServerLinksDialog;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DialogScreens {
    private static final Map<MapCodec<? extends Dialog>, Factory<?>> FACTORIES = new HashMap();

    private static <T extends Dialog> void register(MapCodec<T> p_425747_, Factory<? super T> p_425724_) {
        FACTORIES.put(p_425747_, p_425724_);
    }

    @Nullable
    public static <T extends Dialog> DialogScreen<T> createFromData(T p_426275_, @Nullable Screen p_425938_, DialogConnectionAccess p_427500_) {
        Factory<?> factory = FACTORIES.get(p_426275_.codec());
        return factory != null ? factory.create(p_425938_, p_426275_, p_427500_) : null;
    }

    public static void bootstrap() {
        DialogScreens.register(ConfirmationDialog.MAP_CODEC, SimpleDialogScreen::new);
        DialogScreens.register(NoticeDialog.MAP_CODEC, SimpleDialogScreen::new);
        DialogScreens.register(DialogListDialog.MAP_CODEC, DialogListDialogScreen::new);
        DialogScreens.register(MultiActionDialog.MAP_CODEC, MultiButtonDialogScreen::new);
        DialogScreens.register(ServerLinksDialog.MAP_CODEC, ServerLinksDialogScreen::new);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface Factory<T extends Dialog> {
        public DialogScreen<T> create(@Nullable Screen var1, T var2, DialogConnectionAccess var3);
    }
}

