/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.dialog;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ScrollableLayout;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.dialog.DialogConnectionAccess;
import net.minecraft.client.gui.screens.dialog.DialogControlSet;
import net.minecraft.client.gui.screens.dialog.WaitingForResponseScreen;
import net.minecraft.client.gui.screens.dialog.body.DialogBodyHandlers;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogAction;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.body.DialogBody;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

@OnlyIn(value=Dist.CLIENT)
public abstract class DialogScreen<T extends Dialog>
extends Screen {
    public static final Component DISCONNECT = Component.translatable("menu.custom_screen_info.disconnect");
    private static final int WARNING_BUTTON_SIZE = 20;
    private static final WidgetSprites WARNING_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("dialog/warning_button"), ResourceLocation.withDefaultNamespace("dialog/warning_button_disabled"), ResourceLocation.withDefaultNamespace("dialog/warning_button_highlighted"));
    private final T dialog;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this);
    @Nullable
    private final Screen previousScreen;
    @Nullable
    private ScrollableLayout bodyScroll;
    private Button warningButton;
    private final DialogConnectionAccess connectionAccess;
    private Supplier<Optional<ClickEvent>> onClose = DialogControlSet.EMPTY_ACTION;

    public DialogScreen(@Nullable Screen p_425924_, T p_426171_, DialogConnectionAccess p_427372_) {
        super(p_426171_.common().title());
        this.dialog = p_426171_;
        this.previousScreen = p_425924_;
        this.connectionAccess = p_427372_;
    }

    @Override
    protected final void init() {
        super.init();
        this.warningButton = this.createWarningButton();
        this.warningButton.setTabOrderGroup(-10);
        DialogControlSet dialogcontrolset = new DialogControlSet(this);
        LinearLayout linearlayout = LinearLayout.vertical().spacing(10);
        linearlayout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addToHeader(this.createTitleWithWarningButton());
        for (DialogBody dialogbody : this.dialog.common().body()) {
            LayoutElement layoutelement = DialogBodyHandlers.createBodyElement(this, dialogbody);
            if (layoutelement == null) continue;
            linearlayout.addChild(layoutelement);
        }
        for (Input input : this.dialog.common().inputs()) {
            dialogcontrolset.addInput(input, linearlayout::addChild);
        }
        this.populateBodyElements(linearlayout, dialogcontrolset, this.dialog, this.connectionAccess);
        this.bodyScroll = new ScrollableLayout(this.minecraft, linearlayout, this.layout.getContentHeight());
        this.layout.addToContents(this.bodyScroll);
        this.updateHeaderAndFooter(this.layout, dialogcontrolset, this.dialog, this.connectionAccess);
        this.onClose = dialogcontrolset.bindAction(this.dialog.onCancel());
        this.layout.visitWidgets(p_425641_ -> {
            if (p_425641_ != this.warningButton) {
                this.addRenderableWidget(p_425641_);
            }
        });
        this.addRenderableWidget(this.warningButton);
        this.repositionElements();
    }

    protected void populateBodyElements(LinearLayout p_425540_, DialogControlSet p_428409_, T p_426230_, DialogConnectionAccess p_427345_) {
    }

    protected void updateHeaderAndFooter(HeaderAndFooterLayout p_425628_, DialogControlSet p_428522_, T p_425752_, DialogConnectionAccess p_427506_) {
    }

    @Override
    protected void repositionElements() {
        this.bodyScroll.setMaxHeight(this.layout.getContentHeight());
        this.layout.arrangeElements();
        this.makeSureWarningButtonIsInBounds();
    }

    protected LayoutElement createTitleWithWarningButton() {
        LinearLayout linearlayout = LinearLayout.horizontal().spacing(10);
        linearlayout.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle();
        linearlayout.addChild(new StringWidget(this.title, this.font));
        linearlayout.addChild(this.warningButton);
        return linearlayout;
    }

    protected void makeSureWarningButtonIsInBounds() {
        int i = this.warningButton.getX();
        int j = this.warningButton.getY();
        if (i < 0 || j < 0 || i > this.width - 20 || j > this.height - 20) {
            this.warningButton.setX(Math.max(0, this.width - 40));
            this.warningButton.setY(Math.min(5, this.height));
        }
    }

    private Button createWarningButton() {
        ImageButton imagebutton = new ImageButton(0, 0, 20, 20, WARNING_BUTTON_SPRITES, p_428749_ -> this.minecraft.setScreen(WarningScreen.create(this.minecraft, this)), Component.translatable("menu.custom_screen_info.button_narration"));
        imagebutton.setTooltip(Tooltip.create(Component.translatable("menu.custom_screen_info.tooltip")));
        return imagebutton;
    }

    @Override
    public boolean isPauseScreen() {
        return this.dialog.common().pause();
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return this.dialog.common().canCloseWithEscape();
    }

    @Override
    public void onClose() {
        this.runAction(this.onClose.get(), DialogAction.CLOSE);
    }

    public void runAction(Optional<ClickEvent> p_428264_) {
        this.runAction(p_428264_, this.dialog.common().afterAction());
    }

    public void runAction(Optional<ClickEvent> p_428216_, DialogAction p_428273_) {
        Screen screen;
        switch (p_428273_) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                Screen screen2 = this;
                break;
            }
            case CLOSE: {
                Screen screen2 = this.previousScreen;
                break;
            }
            case WAIT_FOR_RESPONSE: {
                Screen screen2 = screen = new WaitingForResponseScreen(this.previousScreen);
            }
        }
        if (p_428216_.isPresent()) {
            this.handleDialogClickEvent(p_428216_.get(), screen);
        } else {
            this.minecraft.setScreen(screen);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDialogClickEvent(ClickEvent p_427388_, @Nullable Screen p_428550_) {
        ClickEvent clickEvent = p_427388_;
        Objects.requireNonNull(clickEvent);
        ClickEvent clickEvent2 = clickEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.RunCommand.class, ClickEvent.ShowDialog.class, ClickEvent.Custom.class}, (Object)clickEvent2, n)) {
            case 0: {
                ClickEvent.RunCommand runCommand = (ClickEvent.RunCommand)clickEvent2;
                try {
                    String string;
                    String s = string = runCommand.command();
                    this.connectionAccess.runCommand(Commands.trimOptionalPrefix(s), p_428550_);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                ClickEvent.ShowDialog clickevent$showdialog = (ClickEvent.ShowDialog)clickEvent2;
                this.connectionAccess.openDialog(clickevent$showdialog.dialog(), p_428550_);
                return;
            }
            case 2: {
                ClickEvent.Custom clickevent$custom = (ClickEvent.Custom)clickEvent2;
                this.connectionAccess.sendCustomAction(clickevent$custom.id(), clickevent$custom.payload());
                this.minecraft.setScreen(p_428550_);
                return;
            }
        }
        DialogScreen.defaultHandleClickEvent(p_427388_, this.minecraft, p_428550_);
    }

    @Nullable
    public Screen previousScreen() {
        return this.previousScreen;
    }

    protected static LayoutElement packControlsIntoColumns(List<? extends LayoutElement> p_425683_, int p_425923_) {
        GridLayout gridlayout = new GridLayout();
        gridlayout.defaultCellSetting().alignHorizontallyCenter();
        gridlayout.columnSpacing(2).rowSpacing(2);
        int i = p_425683_.size();
        int j = i / p_425923_;
        int k = j * p_425923_;
        for (int l = 0; l < k; ++l) {
            gridlayout.addChild(p_425683_.get(l), l / p_425923_, l % p_425923_);
        }
        if (i != k) {
            LinearLayout linearlayout = LinearLayout.horizontal().spacing(2);
            linearlayout.defaultCellSetting().alignHorizontallyCenter();
            for (int i1 = k; i1 < i; ++i1) {
                linearlayout.addChild(p_425683_.get(i1));
            }
            gridlayout.addChild(linearlayout, j, 0, 1, p_425923_);
        }
        return gridlayout;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WarningScreen
    extends ConfirmScreen {
        private final MutableObject<Screen> returnScreen;

        public static Screen create(Minecraft p_427253_, Screen p_428764_) {
            return new WarningScreen(p_427253_, (MutableObject<Screen>)new MutableObject((Object)p_428764_));
        }

        private WarningScreen(Minecraft p_427476_, MutableObject<Screen> p_427235_) {
            super(p_428065_ -> {
                if (p_428065_) {
                    PauseScreen.disconnectFromWorld(p_427476_, DISCONNECT);
                } else {
                    p_427476_.setScreen((Screen)p_427235_.getValue());
                }
            }, Component.translatable("menu.custom_screen_info.title"), Component.translatable("menu.custom_screen_info.contents"), CommonComponents.disconnectButtonLabel(p_427476_.isLocalServer()), CommonComponents.GUI_BACK);
            this.returnScreen = p_427235_;
        }

        @Nullable
        public Screen returnScreen() {
            return (Screen)this.returnScreen.getValue();
        }

        public void updateReturnScreen(@Nullable Screen p_428767_) {
            this.returnScreen.setValue((Object)p_428767_);
        }
    }
}

