/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GameModeSwitcherScreen
extends Screen {
    static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace("gamemode_switcher/slot");
    static final ResourceLocation SELECTION_SPRITE = ResourceLocation.withDefaultNamespace("gamemode_switcher/selection");
    private static final ResourceLocation GAMEMODE_SWITCHER_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/gamemode_switcher.png");
    private static final int SPRITE_SHEET_WIDTH = 128;
    private static final int SPRITE_SHEET_HEIGHT = 128;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = GameModeIcon.values().length * 31 - 5;
    private static final Component SELECT_KEY = Component.translatable("debug.gamemodes.select_next", Component.translatable("debug.gamemodes.press_f4").withStyle(ChatFormatting.AQUA));
    private final GameModeIcon previousHovered;
    private GameModeIcon currentlyHovered;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    private final List<GameModeSlot> slots = Lists.newArrayList();

    public GameModeSwitcherScreen() {
        super(GameNarrator.NO_TITLE);
        this.currentlyHovered = this.previousHovered = GameModeIcon.getFromGameType(this.getDefaultSelected());
    }

    private GameType getDefaultSelected() {
        MultiPlayerGameMode multiplayergamemode = Minecraft.getInstance().gameMode;
        GameType gametype = multiplayergamemode.getPreviousPlayerMode();
        if (gametype != null) {
            return gametype;
        }
        return multiplayergamemode.getPlayerMode() == GameType.CREATIVE ? GameType.SURVIVAL : GameType.CREATIVE;
    }

    @Override
    protected void init() {
        super.init();
        this.currentlyHovered = this.previousHovered;
        for (int i = 0; i < GameModeIcon.VALUES.length; ++i) {
            GameModeIcon gamemodeswitcherscreen$gamemodeicon = GameModeIcon.VALUES[i];
            this.slots.add(new GameModeSlot(gamemodeswitcherscreen$gamemodeicon, this.width / 2 - ALL_SLOTS_WIDTH / 2 + i * 31, this.height / 2 - 31));
        }
    }

    @Override
    public void render(GuiGraphics p_281834_, int p_283223_, int p_282178_, float p_281339_) {
        if (!this.checkToClose()) {
            p_281834_.drawCenteredString(this.font, this.currentlyHovered.name, this.width / 2, this.height / 2 - 31 - 20, -1);
            p_281834_.drawCenteredString(this.font, SELECT_KEY, this.width / 2, this.height / 2 + 5, -1);
            if (!this.setFirstMousePos) {
                this.firstMouseX = p_283223_;
                this.firstMouseY = p_282178_;
                this.setFirstMousePos = true;
            }
            boolean flag = this.firstMouseX == p_283223_ && this.firstMouseY == p_282178_;
            for (GameModeSlot gamemodeswitcherscreen$gamemodeslot : this.slots) {
                gamemodeswitcherscreen$gamemodeslot.render(p_281834_, p_283223_, p_282178_, p_281339_);
                gamemodeswitcherscreen$gamemodeslot.setSelected(this.currentlyHovered == gamemodeswitcherscreen$gamemodeslot.icon);
                if (flag || !gamemodeswitcherscreen$gamemodeslot.isHoveredOrFocused()) continue;
                this.currentlyHovered = gamemodeswitcherscreen$gamemodeslot.icon;
            }
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_294233_, int p_295829_, int p_296393_, float p_294567_) {
        int i = this.width / 2 - 62;
        int j = this.height / 2 - 31 - 27;
        p_294233_.blit(RenderPipelines.GUI_TEXTURED, GAMEMODE_SWITCHER_LOCATION, i, j, 0.0f, 0.0f, 125, 75, 128, 128);
    }

    private void switchToHoveredGameMode() {
        GameModeSwitcherScreen.switchToHoveredGameMode(this.minecraft, this.currentlyHovered);
    }

    private static void switchToHoveredGameMode(Minecraft p_281340_, GameModeIcon p_281358_) {
        if (p_281340_.gameMode != null && p_281340_.player != null) {
            GameModeIcon gamemodeswitcherscreen$gamemodeicon = GameModeIcon.getFromGameType(p_281340_.gameMode.getPlayerMode());
            if (p_281340_.player.hasPermissions(2) && p_281358_ != gamemodeswitcherscreen$gamemodeicon) {
                p_281340_.player.connection.send(new ServerboundChangeGameModePacket(p_281358_.mode));
            }
        }
    }

    private boolean checkToClose() {
        if (!InputConstants.isKeyDown(this.minecraft.getWindow().getWindow(), 292)) {
            this.switchToHoveredGameMode();
            this.minecraft.setScreen(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int p_97553_, int p_97554_, int p_97555_) {
        if (p_97553_ == 293) {
            this.setFirstMousePos = false;
            this.currentlyHovered = this.currentlyHovered.getNext();
            return true;
        }
        return super.keyPressed(p_97553_, p_97554_, p_97555_);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum GameModeIcon {
        CREATIVE(Component.translatable("gameMode.creative"), GameType.CREATIVE, new ItemStack(Blocks.GRASS_BLOCK)),
        SURVIVAL(Component.translatable("gameMode.survival"), GameType.SURVIVAL, new ItemStack(Items.IRON_SWORD)),
        ADVENTURE(Component.translatable("gameMode.adventure"), GameType.ADVENTURE, new ItemStack(Items.MAP)),
        SPECTATOR(Component.translatable("gameMode.spectator"), GameType.SPECTATOR, new ItemStack(Items.ENDER_EYE));

        static final GameModeIcon[] VALUES;
        private static final int ICON_AREA = 16;
        private static final int ICON_TOP_LEFT = 5;
        final Component name;
        final GameType mode;
        private final ItemStack renderStack;

        private GameModeIcon(Component p_97594_, GameType p_426165_, ItemStack p_97596_) {
            this.name = p_97594_;
            this.mode = p_426165_;
            this.renderStack = p_97596_;
        }

        void drawIcon(GuiGraphics p_282609_, int p_283301_, int p_281692_) {
            p_282609_.renderItem(this.renderStack, p_283301_, p_281692_);
        }

        GameModeIcon getNext() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SURVIVAL;
                case 1 -> ADVENTURE;
                case 2 -> SPECTATOR;
                case 3 -> CREATIVE;
            };
        }

        static GameModeIcon getFromGameType(GameType p_283307_) {
            return switch (p_283307_) {
                default -> throw new MatchException(null, null);
                case GameType.SPECTATOR -> SPECTATOR;
                case GameType.SURVIVAL -> SURVIVAL;
                case GameType.CREATIVE -> CREATIVE;
                case GameType.ADVENTURE -> ADVENTURE;
            };
        }

        static {
            VALUES = GameModeIcon.values();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GameModeSlot
    extends AbstractWidget {
        final GameModeIcon icon;
        private boolean isSelected;

        public GameModeSlot(GameModeIcon p_97627_, int p_97628_, int p_97629_) {
            super(p_97628_, p_97629_, 26, 26, p_97627_.name);
            this.icon = p_97627_;
        }

        @Override
        public void renderWidget(GuiGraphics p_281380_, int p_283094_, int p_283558_, float p_282631_) {
            this.drawSlot(p_281380_);
            if (this.isSelected) {
                this.drawSelection(p_281380_);
            }
            this.icon.drawIcon(p_281380_, this.getX() + 5, this.getY() + 5);
        }

        @Override
        public void updateWidgetNarration(NarrationElementOutput p_259120_) {
            this.defaultButtonNarrationText(p_259120_);
        }

        @Override
        public boolean isHoveredOrFocused() {
            return super.isHoveredOrFocused() || this.isSelected;
        }

        public void setSelected(boolean p_97644_) {
            this.isSelected = p_97644_;
        }

        private void drawSlot(GuiGraphics p_281786_) {
            p_281786_.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_SPRITE, this.getX(), this.getY(), 26, 26);
        }

        private void drawSelection(GuiGraphics p_281820_) {
            p_281820_.blitSprite(RenderPipelines.GUI_TEXTURED, SELECTION_SPRITE, this.getX(), this.getY(), 26, 26);
        }
    }
}

