/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.advancements;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
enum AdvancementTabType {
    ABOVE(new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_above_left_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_above_middle_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_above_right_selected")), new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_above_left"), ResourceLocation.withDefaultNamespace("advancements/tab_above_middle"), ResourceLocation.withDefaultNamespace("advancements/tab_above_right")), 28, 32, 8),
    BELOW(new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_below_left_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_below_middle_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_below_right_selected")), new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_below_left"), ResourceLocation.withDefaultNamespace("advancements/tab_below_middle"), ResourceLocation.withDefaultNamespace("advancements/tab_below_right")), 28, 32, 8),
    LEFT(new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_left_top_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_left_middle_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_left_bottom_selected")), new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_left_top"), ResourceLocation.withDefaultNamespace("advancements/tab_left_middle"), ResourceLocation.withDefaultNamespace("advancements/tab_left_bottom")), 32, 28, 5),
    RIGHT(new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_right_top_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_right_middle_selected"), ResourceLocation.withDefaultNamespace("advancements/tab_right_bottom_selected")), new Sprites(ResourceLocation.withDefaultNamespace("advancements/tab_right_top"), ResourceLocation.withDefaultNamespace("advancements/tab_right_middle"), ResourceLocation.withDefaultNamespace("advancements/tab_right_bottom")), 32, 28, 5);

    private final Sprites selectedSprites;
    private final Sprites unselectedSprites;
    public static final int MAX_TABS;
    private final int width;
    private final int height;
    private final int max;

    private AdvancementTabType(Sprites p_296402_, Sprites p_295708_, int p_97205_, int p_97206_, int p_97207_) {
        this.selectedSprites = p_296402_;
        this.unselectedSprites = p_295708_;
        this.width = p_97205_;
        this.height = p_97206_;
        this.max = p_97207_;
    }

    public int getMax() {
        return this.max;
    }

    public void draw(GuiGraphics p_283216_, int p_282432_, int p_283617_, boolean p_282320_, int p_281898_) {
        Sprites advancementtabtype$sprites;
        Sprites sprites = advancementtabtype$sprites = p_282320_ ? this.selectedSprites : this.unselectedSprites;
        ResourceLocation resourcelocation = p_281898_ == 0 ? advancementtabtype$sprites.first() : (p_281898_ == this.max - 1 ? advancementtabtype$sprites.last() : advancementtabtype$sprites.middle());
        p_283216_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, p_282432_ + this.getX(p_281898_), p_283617_ + this.getY(p_281898_), this.width, this.height);
    }

    public void drawIcon(GuiGraphics p_281370_, int p_283209_, int p_282807_, int p_282968_, ItemStack p_283383_) {
        int i = p_283209_ + this.getX(p_282968_);
        int j = p_282807_ + this.getY(p_282968_);
        switch (this.ordinal()) {
            case 0: {
                i += 6;
                j += 9;
                break;
            }
            case 1: {
                i += 6;
                j += 6;
                break;
            }
            case 2: {
                i += 10;
                j += 5;
                break;
            }
            case 3: {
                i += 6;
                j += 5;
            }
        }
        p_281370_.renderFakeItem(p_283383_, i, j);
    }

    public int getX(int p_97212_) {
        switch (this.ordinal()) {
            case 0: {
                return (this.width + 4) * p_97212_;
            }
            case 1: {
                return (this.width + 4) * p_97212_;
            }
            case 2: {
                return -this.width + 4;
            }
            case 3: {
                return 248;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public int getY(int p_97233_) {
        switch (this.ordinal()) {
            case 0: {
                return -this.height + 4;
            }
            case 1: {
                return 136;
            }
            case 2: {
                return this.height * p_97233_;
            }
            case 3: {
                return this.height * p_97233_;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public boolean isMouseOver(int p_97214_, int p_97215_, int p_97216_, double p_97217_, double p_97218_) {
        int i = p_97214_ + this.getX(p_97216_);
        int j = p_97215_ + this.getY(p_97216_);
        return p_97217_ > (double)i && p_97217_ < (double)(i + this.width) && p_97218_ > (double)j && p_97218_ < (double)(j + this.height);
    }

    static {
        MAX_TABS = Arrays.stream(AdvancementTabType.values()).mapToInt(AdvancementTabType::getMax).sum();
    }

    @OnlyIn(value=Dist.CLIENT)
    record Sprites(ResourceLocation first, ResourceLocation middle, ResourceLocation last) {
    }
}

