/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReceivingLevelScreen
extends Screen {
    private static final Component DOWNLOADING_TERRAIN_TEXT = Component.translatable("multiplayer.downloadingTerrain");
    private static final long CHUNK_LOADING_START_WAIT_LIMIT_MS = 30000L;
    private final long createdAt;
    private final BooleanSupplier levelReceived;
    private final Reason reason;
    @Nullable
    private TextureAtlasSprite cachedNetherPortalSprite;

    public ReceivingLevelScreen(BooleanSupplier p_304926_, Reason p_341661_) {
        super(GameNarrator.NO_TITLE);
        this.levelReceived = p_304926_;
        this.reason = p_341661_;
        this.createdAt = Util.getMillis();
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected boolean shouldNarrateNavigation() {
        return false;
    }

    @Override
    public void render(GuiGraphics p_281489_, int p_282902_, int p_283018_, float p_281251_) {
        super.render(p_281489_, p_282902_, p_283018_, p_281251_);
        p_281489_.drawCenteredString(this.font, DOWNLOADING_TERRAIN_TEXT, this.width / 2, this.height / 2 - 50, -1);
    }

    @Override
    public void renderBackground(GuiGraphics p_341670_, int p_341687_, int p_341693_, float p_341684_) {
        switch (this.reason.ordinal()) {
            case 0: {
                p_341670_.blitSprite(RenderPipelines.GUI_OPAQUE_TEXTURED_BACKGROUND, this.getNetherPortalSprite(), 0, 0, p_341670_.guiWidth(), p_341670_.guiHeight());
                break;
            }
            case 1: {
                TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                TextureSetup texturesetup = TextureSetup.doubleTexture(texturemanager.getTexture(TheEndPortalRenderer.END_SKY_LOCATION).getTextureView(), texturemanager.getTexture(TheEndPortalRenderer.END_PORTAL_LOCATION).getTextureView());
                p_341670_.fill(RenderPipelines.END_PORTAL, texturesetup, 0, 0, this.width, this.height);
                break;
            }
            case 2: {
                this.renderPanorama(p_341670_, p_341684_);
                this.renderBlurredBackground(p_341670_);
                this.renderMenuBackground(p_341670_);
            }
        }
    }

    private TextureAtlasSprite getNetherPortalSprite() {
        if (this.cachedNetherPortalSprite != null) {
            return this.cachedNetherPortalSprite;
        }
        this.cachedNetherPortalSprite = this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.NETHER_PORTAL.defaultBlockState());
        return this.cachedNetherPortalSprite;
    }

    @Override
    public void tick() {
        if (this.levelReceived.getAsBoolean() || Util.getMillis() > this.createdAt + 30000L) {
            this.onClose();
        }
    }

    @Override
    public void onClose() {
        this.minecraft.getNarrator().saySystemNow(Component.translatable("narrator.ready_to_play"));
        super.onClose();
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Reason {
        NETHER_PORTAL,
        END_PORTAL,
        OTHER;

    }
}

