/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.text2speech.Narrator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommonButtons;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AccessibilityOnboardingScreen
extends Screen {
    private static final Component TITLE = Component.translatable("accessibility.onboarding.screen.title");
    private static final Component ONBOARDING_NARRATOR_MESSAGE = Component.translatable("accessibility.onboarding.screen.narrator");
    private static final int PADDING = 4;
    private static final int TITLE_PADDING = 16;
    private static final float FADE_OUT_TIME = 1000.0f;
    private final LogoRenderer logoRenderer;
    private final Options options;
    private final boolean narratorAvailable;
    private boolean hasNarrated;
    private float timer;
    private final Runnable onClose;
    @Nullable
    private FocusableTextWidget textWidget;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout(this, this.initTitleYPos(), 33);
    private float fadeInStart;
    private boolean fadingIn = true;
    private float fadeOutStart;

    public AccessibilityOnboardingScreen(Options p_265483_, Runnable p_300004_) {
        super(TITLE);
        this.options = p_265483_;
        this.onClose = p_300004_;
        this.logoRenderer = new LogoRenderer(true);
        this.narratorAvailable = Minecraft.getInstance().getNarrator().isActive();
    }

    @Override
    public void init() {
        LinearLayout linearlayout = this.layout.addToContents(LinearLayout.vertical());
        linearlayout.defaultCellSetting().alignHorizontallyCenter().padding(4);
        this.textWidget = linearlayout.addChild(new FocusableTextWidget(this.width, this.title, this.font), p_329717_ -> p_329717_.padding(8));
        AbstractWidget abstractWidget = this.options.narrator().createButton(this.options);
        if (abstractWidget instanceof CycleButton) {
            CycleButton cyclebutton;
            this.narratorButton = cyclebutton = (CycleButton)abstractWidget;
            this.narratorButton.active = this.narratorAvailable;
            linearlayout.addChild(this.narratorButton);
        }
        linearlayout.addChild(CommonButtons.accessibility(150, p_344155_ -> this.closeAndSetScreen(new AccessibilityOptionsScreen(this, this.minecraft.options)), false));
        linearlayout.addChild(CommonButtons.language(150, p_344154_ -> this.closeAndSetScreen(new LanguageSelectScreen((Screen)this, this.minecraft.options, this.minecraft.getLanguageManager())), false));
        this.layout.addToFooter(Button.builder(CommonComponents.GUI_CONTINUE, p_267841_ -> this.onClose()).build());
        this.layout.visitWidgets(this::addRenderableWidget);
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        if (this.textWidget != null) {
            this.textWidget.containWithin(this.width);
        }
        this.layout.arrangeElements();
    }

    @Override
    protected void setInitialFocus() {
        if (this.narratorAvailable && this.narratorButton != null) {
            this.setInitialFocus(this.narratorButton);
        } else {
            super.setInitialFocus();
        }
    }

    private int initTitleYPos() {
        return 90;
    }

    @Override
    public void onClose() {
        this.fadeOutStart = Util.getMillis();
    }

    private void closeAndSetScreen(Screen p_272914_) {
        this.close(false, () -> this.minecraft.setScreen(p_272914_));
    }

    private void close(boolean p_352950_, Runnable p_299978_) {
        if (p_352950_) {
            this.options.onboardingAccessibilityFinished();
        }
        Narrator.getNarrator().clear();
        p_299978_.run();
    }

    @Override
    public void render(GuiGraphics p_282353_, int p_265135_, int p_265032_, float p_265387_) {
        super.render(p_282353_, p_265135_, p_265032_, p_265387_);
        this.handleInitialNarrationDelay();
        if (this.fadeInStart == 0.0f && this.fadingIn) {
            this.fadeInStart = Util.getMillis();
        }
        if (this.fadeInStart > 0.0f) {
            float f = ((float)Util.getMillis() - this.fadeInStart) / 2000.0f;
            float f1 = 1.0f;
            if (f >= 1.0f) {
                this.fadingIn = false;
                this.fadeInStart = 0.0f;
            } else {
                f = Mth.clamp(f, 0.0f, 1.0f);
                f1 = Mth.clampedMap(f, 0.5f, 1.0f, 0.0f, 1.0f);
            }
            this.fadeWidgets(f1);
        }
        if (this.fadeOutStart > 0.0f) {
            float f2 = 1.0f - ((float)Util.getMillis() - this.fadeOutStart) / 1000.0f;
            float f3 = 0.0f;
            if (f2 <= 0.0f) {
                this.fadeOutStart = 0.0f;
                this.close(true, this.onClose);
            } else {
                f2 = Mth.clamp(f2, 0.0f, 1.0f);
                f3 = Mth.clampedMap(f2, 0.5f, 1.0f, 0.0f, 1.0f);
            }
            this.fadeWidgets(f3);
        }
        this.logoRenderer.renderLogo(p_282353_, this.width, 1.0f);
    }

    @Override
    protected void renderPanorama(GuiGraphics p_330740_, float p_331952_) {
        this.minecraft.gameRenderer.getPanorama().render(p_330740_, this.width, this.height, false);
    }

    private void handleInitialNarrationDelay() {
        if (!this.hasNarrated && this.narratorAvailable) {
            if (this.timer < 40.0f) {
                this.timer += 1.0f;
            } else if (this.minecraft.isWindowActive()) {
                Narrator.getNarrator().say(ONBOARDING_NARRATOR_MESSAGE.getString(), true, 1.0f);
                this.hasNarrated = true;
            }
        }
    }
}

