/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render.state;

import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.ScreenArea;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3x2f;

@OnlyIn(value=Dist.CLIENT)
public final class GuiTextRenderState
implements ScreenArea {
    public final Font font;
    public final FormattedCharSequence text;
    public final Matrix3x2f pose;
    public final int x;
    public final int y;
    public final int color;
    public final int backgroundColor;
    public final boolean dropShadow;
    @Nullable
    public final ScreenRectangle scissor;
    @Nullable
    private Font.PreparedText preparedText;
    @Nullable
    private ScreenRectangle bounds;

    public GuiTextRenderState(Font p_426159_, FormattedCharSequence p_425925_, Matrix3x2f p_415973_, int p_416612_, int p_416232_, int p_425576_, int p_426044_, boolean p_426039_, @Nullable ScreenRectangle p_416431_) {
        this.font = p_426159_;
        this.text = p_425925_;
        this.pose = p_415973_;
        this.x = p_416612_;
        this.y = p_416232_;
        this.color = p_425576_;
        this.backgroundColor = p_426044_;
        this.dropShadow = p_426039_;
        this.scissor = p_416431_;
    }

    public Font.PreparedText ensurePrepared() {
        if (this.preparedText == null) {
            this.preparedText = this.font.prepareText(this.text, (float)this.x, (float)this.y, this.color, this.dropShadow, this.backgroundColor);
            ScreenRectangle screenrectangle = this.preparedText.bounds();
            if (screenrectangle != null) {
                screenrectangle = screenrectangle.transformMaxBounds(this.pose);
                this.bounds = this.scissor != null ? this.scissor.intersection(screenrectangle) : screenrectangle;
            }
        }
        return this.preparedText;
    }

    @Override
    @Nullable
    public ScreenRectangle bounds() {
        this.ensurePrepared();
        return this.bounds;
    }
}

