/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.render.state.ScreenArea;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderState {
    private static final int DEBUG_RECTANGLE_COLOR = 0x774444FF;
    private final List<Node> strata = new ArrayList<Node>();
    private int firstStratumAfterBlur = Integer.MAX_VALUE;
    private Node current;
    private final Set<Object> itemModelIdentities = new HashSet<Object>();
    @Nullable
    private ScreenRectangle lastElementBounds;

    public GuiRenderState() {
        this.nextStratum();
    }

    public void nextStratum() {
        this.current = new Node(null);
        this.strata.add(this.current);
    }

    public void blurBeforeThisStratum() {
        if (this.firstStratumAfterBlur != Integer.MAX_VALUE) {
            throw new IllegalStateException("Can only blur once per frame");
        }
        this.firstStratumAfterBlur = this.strata.size() - 1;
    }

    public void up() {
        if (this.current.up == null) {
            this.current.up = new Node(this.current);
        }
        this.current = this.current.up;
    }

    public void down() {
        if (this.current.down == null) {
            this.current.down = new Node(this.current);
        }
        this.current = this.current.down;
    }

    public void submitItem(GuiItemRenderState p_416573_) {
        if (this.findAppropriateNode(p_416573_)) {
            this.itemModelIdentities.add(p_416573_.itemStackRenderState().getModelIdentity());
            this.current.submitItem(p_416573_);
            this.sumbitDebugRectangleIfEnabled(p_416573_.bounds());
        }
    }

    public void submitText(GuiTextRenderState p_416631_) {
        if (this.findAppropriateNode(p_416631_)) {
            this.current.submitText(p_416631_);
            this.sumbitDebugRectangleIfEnabled(p_416631_.bounds());
        }
    }

    public void submitPicturesInPictureState(PictureInPictureRenderState p_416091_) {
        if (this.findAppropriateNode(p_416091_)) {
            this.current.submitPicturesInPictureState(p_416091_);
            this.sumbitDebugRectangleIfEnabled(p_416091_.bounds());
        }
    }

    public void submitGuiElement(GuiElementRenderState p_416144_) {
        if (this.findAppropriateNode(p_416144_)) {
            this.current.submitGuiElement(p_416144_);
            this.sumbitDebugRectangleIfEnabled(p_416144_.bounds());
        }
    }

    private void sumbitDebugRectangleIfEnabled(@Nullable ScreenRectangle p_422532_) {
    }

    private boolean findAppropriateNode(ScreenArea p_422644_) {
        ScreenRectangle screenrectangle = p_422644_.bounds();
        if (screenrectangle == null) {
            return false;
        }
        if (this.lastElementBounds != null && this.lastElementBounds.encompasses(screenrectangle)) {
            this.up();
        } else {
            this.navigateToAboveHighestElementWithIntersectingBounds(screenrectangle);
        }
        this.lastElementBounds = screenrectangle;
        return true;
    }

    private void navigateToAboveHighestElementWithIntersectingBounds(ScreenRectangle p_421652_) {
        Node guirenderstate$node = this.strata.getLast();
        while (guirenderstate$node.up != null) {
            guirenderstate$node = guirenderstate$node.up;
        }
        boolean flag = false;
        while (!flag) {
            boolean bl = flag = this.hasIntersection(p_421652_, guirenderstate$node.elementStates) || this.hasIntersection(p_421652_, guirenderstate$node.itemStates) || this.hasIntersection(p_421652_, guirenderstate$node.textStates) || this.hasIntersection(p_421652_, guirenderstate$node.picturesInPictureStates);
            if (guirenderstate$node.parent == null) break;
            if (flag) continue;
            guirenderstate$node = guirenderstate$node.parent;
        }
        this.current = guirenderstate$node;
        if (flag) {
            this.up();
        }
    }

    private boolean hasIntersection(ScreenRectangle p_422321_, @Nullable List<? extends ScreenArea> p_422715_) {
        if (p_422715_ != null) {
            for (ScreenArea screenArea : p_422715_) {
                ScreenRectangle screenrectangle = screenArea.bounds();
                if (screenrectangle == null || !screenrectangle.intersects(p_422321_)) continue;
                return true;
            }
        }
        return false;
    }

    public void submitBlitToCurrentLayer(BlitRenderState p_427445_) {
        this.current.submitGuiElement(p_427445_);
    }

    public void submitGlyphToCurrentLayer(GuiElementRenderState p_427291_) {
        this.current.submitGlyph(p_427291_);
    }

    public Set<Object> getItemModelIdentities() {
        return this.itemModelIdentities;
    }

    public void forEachElement(LayeredElementConsumer p_418470_, TraverseRange p_419645_) {
        MutableInt mutableint = new MutableInt(0);
        this.traverse((Node p_426878_) -> {
            if (p_426878_.elementStates != null || p_426878_.glyphStates != null) {
                int i = mutableint.incrementAndGet();
                if (p_426878_.elementStates != null) {
                    for (GuiElementRenderState guielementrenderstate : p_426878_.elementStates) {
                        p_418470_.accept(guielementrenderstate, i);
                    }
                }
                if (p_426878_.glyphStates != null) {
                    for (GuiElementRenderState guielementrenderstate1 : p_426878_.glyphStates) {
                        p_418470_.accept(guielementrenderstate1, i);
                    }
                }
            }
        }, p_419645_);
    }

    public void forEachItem(Consumer<GuiItemRenderState> p_418276_) {
        Node guirenderstate$node = this.current;
        this.traverse((Node p_418061_) -> {
            if (p_418061_.itemStates != null) {
                this.current = p_418061_;
                for (GuiItemRenderState guiitemrenderstate : p_418061_.itemStates) {
                    p_418276_.accept(guiitemrenderstate);
                }
            }
        }, TraverseRange.ALL);
        this.current = guirenderstate$node;
    }

    public void forEachText(Consumer<GuiTextRenderState> p_418229_) {
        Node guirenderstate$node = this.current;
        this.traverse((Node p_421279_) -> {
            if (p_421279_.textStates != null) {
                for (GuiTextRenderState guitextrenderstate : p_421279_.textStates) {
                    this.current = p_421279_;
                    p_418229_.accept(guitextrenderstate);
                }
            }
        }, TraverseRange.ALL);
        this.current = guirenderstate$node;
    }

    public void forEachPictureInPicture(Consumer<PictureInPictureRenderState> p_418352_) {
        Node guirenderstate$node = this.current;
        this.traverse((Node p_418372_) -> {
            if (p_418372_.picturesInPictureStates != null) {
                this.current = p_418372_;
                for (PictureInPictureRenderState pictureinpicturerenderstate : p_418372_.picturesInPictureStates) {
                    p_418352_.accept(pictureinpicturerenderstate);
                }
            }
        }, TraverseRange.ALL);
        this.current = guirenderstate$node;
    }

    public void sortElements(Comparator<GuiElementRenderState> p_418003_) {
        this.traverse((Node p_418195_) -> {
            if (p_418195_.elementStates != null) {
                p_418195_.elementStates.sort(p_418003_);
            }
        }, TraverseRange.ALL);
    }

    private void traverse(Consumer<Node> p_418051_, TraverseRange p_419641_) {
        int i = 0;
        int j = this.strata.size();
        if (p_419641_ == TraverseRange.BEFORE_BLUR) {
            j = Math.min(this.firstStratumAfterBlur, this.strata.size());
        } else if (p_419641_ == TraverseRange.AFTER_BLUR) {
            i = this.firstStratumAfterBlur;
        }
        for (int k = i; k < j; ++k) {
            Node guirenderstate$node = this.strata.get(k);
            this.traverse(guirenderstate$node, p_418051_);
        }
    }

    private void traverse(Node p_418468_, Consumer<Node> p_418350_) {
        if (p_418468_.down != null) {
            this.traverse(p_418468_.down, p_418350_);
        }
        p_418350_.accept(p_418468_);
        if (p_418468_.up != null) {
            this.traverse(p_418468_.up, p_418350_);
        }
    }

    public void reset() {
        this.itemModelIdentities.clear();
        this.strata.clear();
        this.firstStratumAfterBlur = Integer.MAX_VALUE;
        this.nextStratum();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Node {
        @Nullable
        public final Node parent;
        @Nullable
        public Node up;
        @Nullable
        public Node down;
        @Nullable
        public List<GuiElementRenderState> elementStates;
        @Nullable
        public List<GuiElementRenderState> glyphStates;
        @Nullable
        public List<GuiItemRenderState> itemStates;
        @Nullable
        public List<GuiTextRenderState> textStates;
        @Nullable
        public List<PictureInPictureRenderState> picturesInPictureStates;

        Node(@Nullable Node p_418301_) {
            this.parent = p_418301_;
        }

        public void submitItem(GuiItemRenderState p_418222_) {
            if (this.itemStates == null) {
                this.itemStates = new ArrayList<GuiItemRenderState>();
            }
            this.itemStates.add(p_418222_);
        }

        public void submitText(GuiTextRenderState p_418089_) {
            if (this.textStates == null) {
                this.textStates = new ArrayList<GuiTextRenderState>();
            }
            this.textStates.add(p_418089_);
        }

        public void submitPicturesInPictureState(PictureInPictureRenderState p_418088_) {
            if (this.picturesInPictureStates == null) {
                this.picturesInPictureStates = new ArrayList<PictureInPictureRenderState>();
            }
            this.picturesInPictureStates.add(p_418088_);
        }

        public void submitGuiElement(GuiElementRenderState p_418022_) {
            if (this.elementStates == null) {
                this.elementStates = new ArrayList<GuiElementRenderState>();
            }
            this.elementStates.add(p_418022_);
        }

        public void submitGlyph(GuiElementRenderState p_427510_) {
            if (this.glyphStates == null) {
                this.glyphStates = new ArrayList<GuiElementRenderState>();
            }
            this.glyphStates.add(p_427510_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface LayeredElementConsumer {
        public void accept(GuiElementRenderState var1, int var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TraverseRange {
        ALL,
        BEFORE_BLUR,
        AFTER_BLUR;

    }
}

