/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.render.pip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.GuiProfilerChartRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ResultField;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiProfilerChartRenderer
extends PictureInPictureRenderer<GuiProfilerChartRenderState> {
    public GuiProfilerChartRenderer(MultiBufferSource.BufferSource p_415764_) {
        super(p_415764_);
    }

    @Override
    public Class<GuiProfilerChartRenderState> getRenderStateClass() {
        return GuiProfilerChartRenderState.class;
    }

    @Override
    protected void renderToTexture(GuiProfilerChartRenderState p_416582_, PoseStack p_415956_) {
        double d0 = 0.0;
        p_415956_.translate(0.0f, -5.0f, 0.0f);
        Matrix4f matrix4f = p_415956_.last().pose();
        for (ResultField resultfield : p_416582_.chartData()) {
            int i = Mth.floor(resultfield.percentage / 4.0) + 1;
            VertexConsumer vertexconsumer = this.bufferSource.getBuffer(RenderType.debugTriangleFan());
            int j = ARGB.opaque(resultfield.getColor());
            int k = ARGB.multiply(j, -8355712);
            vertexconsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(j);
            for (int l = i; l >= 0; --l) {
                float f = (float)((d0 + resultfield.percentage * (double)l / (double)i) * 6.2831854820251465 / 100.0);
                float f1 = Mth.sin(f) * 105.0f;
                float f2 = Mth.cos(f) * 105.0f * 0.5f;
                vertexconsumer.addVertex(matrix4f, f1, f2, 0.0f).setColor(j);
            }
            vertexconsumer = this.bufferSource.getBuffer(RenderType.debugQuads());
            for (int i1 = i; i1 > 0; --i1) {
                float f6 = (float)((d0 + resultfield.percentage * (double)i1 / (double)i) * 6.2831854820251465 / 100.0);
                float f7 = Mth.sin(f6) * 105.0f;
                float f8 = Mth.cos(f6) * 105.0f * 0.5f;
                float f3 = (float)((d0 + resultfield.percentage * (double)(i1 - 1) / (double)i) * 6.2831854820251465 / 100.0);
                float f4 = Mth.sin(f3) * 105.0f;
                float f5 = Mth.cos(f3) * 105.0f * 0.5f;
                if ((f8 + f5) / 2.0f < 0.0f) continue;
                vertexconsumer.addVertex(matrix4f, f7, f8, 0.0f).setColor(k);
                vertexconsumer.addVertex(matrix4f, f7, f8 + 10.0f, 0.0f).setColor(k);
                vertexconsumer.addVertex(matrix4f, f4, f5 + 10.0f, 0.0f).setColor(k);
                vertexconsumer.addVertex(matrix4f, f4, f5, 0.0f).setColor(k);
            }
            d0 += resultfield.percentage;
        }
    }

    @Override
    protected float getTranslateY(int p_416710_, int p_416674_) {
        return (float)p_416710_ / 2.0f;
    }

    @Override
    protected String getTextureLabel() {
        return "profiler chart";
    }
}

