/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.TrueTypeGlyphProvider;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.font.providers.FreeTypeUtil;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FreeType;

@OnlyIn(value=Dist.CLIENT)
public record TrueTypeGlyphProviderDefinition(ResourceLocation location, float size, float oversample, Shift shift, String skip) implements GlyphProviderDefinition
{
    private static final Codec<String> SKIP_LIST_CODEC = Codec.withAlternative((Codec)Codec.STRING, (Codec)Codec.STRING.listOf(), p_286852_ -> String.join((CharSequence)"", p_286852_));
    public static final MapCodec<TrueTypeGlyphProviderDefinition> CODEC = RecordCodecBuilder.mapCodec(p_286284_ -> p_286284_.group((App)ResourceLocation.CODEC.fieldOf("file").forGetter(TrueTypeGlyphProviderDefinition::location), (App)Codec.FLOAT.optionalFieldOf("size", (Object)Float.valueOf(11.0f)).forGetter(TrueTypeGlyphProviderDefinition::size), (App)Codec.FLOAT.optionalFieldOf("oversample", (Object)Float.valueOf(1.0f)).forGetter(TrueTypeGlyphProviderDefinition::oversample), (App)Shift.CODEC.optionalFieldOf("shift", (Object)Shift.NONE).forGetter(TrueTypeGlyphProviderDefinition::shift), (App)SKIP_LIST_CODEC.optionalFieldOf("skip", (Object)"").forGetter(TrueTypeGlyphProviderDefinition::skip)).apply((Applicative)p_286284_, TrueTypeGlyphProviderDefinition::new));

    @Override
    public GlyphProviderType type() {
        return GlyphProviderType.TTF;
    }

    @Override
    public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> unpack() {
        return Either.left(this::load);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlyphProvider load(ResourceManager p_286229_) throws IOException {
        FT_Face ft_face = null;
        ByteBuffer bytebuffer = null;
        try {
            TrueTypeGlyphProvider truetypeglyphprovider;
            try (InputStream inputstream = p_286229_.open(this.location.withPrefix("font/"));){
                bytebuffer = TextureUtil.readResource(inputstream);
                bytebuffer.flip();
                Object object = FreeTypeUtil.LIBRARY_LOCK;
                synchronized (object) {
                    try (MemoryStack memorystack = MemoryStack.stackPush();){
                        PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
                        FreeTypeUtil.assertError(FreeType.FT_New_Memory_Face((long)FreeTypeUtil.getLibrary(), (ByteBuffer)bytebuffer, (long)0L, (PointerBuffer)pointerbuffer), "Initializing font face");
                        ft_face = FT_Face.create((long)pointerbuffer.get());
                    }
                    String s = FreeType.FT_Get_Font_Format((FT_Face)ft_face);
                    if (!"TrueType".equals(s)) {
                        throw new IOException("Font is not in TTF format, was " + s);
                    }
                    FreeTypeUtil.assertError(FreeType.FT_Select_Charmap((FT_Face)ft_face, (int)FreeType.FT_ENCODING_UNICODE), "Find unicode charmap");
                    truetypeglyphprovider = new TrueTypeGlyphProvider(bytebuffer, ft_face, this.size, this.oversample, this.shift.x, this.shift.y, this.skip);
                }
            }
            return truetypeglyphprovider;
        }
        catch (Exception exception) {
            Object object = FreeTypeUtil.LIBRARY_LOCK;
            synchronized (object) {
                if (ft_face != null) {
                    FreeType.FT_Done_Face(ft_face);
                }
            }
            MemoryUtil.memFree((Buffer)bytebuffer);
            throw exception;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Shift(float x, float y) {
        public static final Shift NONE = new Shift(0.0f, 0.0f);
        public static final Codec<Shift> CODEC = Codec.floatRange((float)-512.0f, (float)512.0f).listOf().comapFlatMap(p_337412_ -> Util.fixedSize(p_337412_, 2).map(p_286746_ -> new Shift(((Float)p_286746_.get(0)).floatValue(), ((Float)p_286746_.get(1)).floatValue())), p_286274_ -> List.of(Float.valueOf(p_286274_.x), Float.valueOf(p_286274_.y)));
    }
}

