/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BitmapProvider
implements GlyphProvider {
    static final Logger LOGGER = LogUtils.getLogger();
    private final NativeImage image;
    private final CodepointMap<Glyph> glyphs;

    BitmapProvider(NativeImage p_285380_, CodepointMap<Glyph> p_285445_) {
        this.image = p_285380_;
        this.glyphs = p_285445_;
    }

    @Override
    public void close() {
        this.image.close();
    }

    @Override
    @Nullable
    public GlyphInfo getGlyph(int p_232638_) {
        return this.glyphs.get(p_232638_);
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return IntSets.unmodifiable((IntSet)this.glyphs.keySet());
    }

    @OnlyIn(value=Dist.CLIENT)
    record Glyph(float scale, NativeImage image, int offsetX, int offsetY, int width, int height, int advance, int ascent) implements GlyphInfo
    {
        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public BakedGlyph bake(Function<SheetGlyphInfo, BakedGlyph> p_232640_) {
            return p_232640_.apply(new SheetGlyphInfo(){

                @Override
                public float getOversample() {
                    return 1.0f / scale;
                }

                @Override
                public int getPixelWidth() {
                    return width;
                }

                @Override
                public int getPixelHeight() {
                    return height;
                }

                @Override
                public float getBearingTop() {
                    return ascent;
                }

                @Override
                public void upload(int p_232658_, int p_232659_, GpuTexture p_405770_) {
                    RenderSystem.getDevice().createCommandEncoder().writeToTexture(p_405770_, image, 0, 0, p_232658_, p_232659_, width, height, offsetX, offsetY);
                }

                @Override
                public boolean isColored() {
                    return image.format().components() > 1;
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Definition(ResourceLocation file, int height, int ascent, int[][] codepointGrid) implements GlyphProviderDefinition
    {
        private static final Codec<int[][]> CODEPOINT_GRID_CODEC = Codec.STRING.listOf().xmap(p_286900_ -> {
            int i = p_286900_.size();
            int[][] aint = new int[i][];
            for (int j = 0; j < i; ++j) {
                aint[j] = ((String)p_286900_.get(j)).codePoints().toArray();
            }
            return aint;
        }, p_286828_ -> {
            ArrayList<String> list = new ArrayList<String>(((int[][])p_286828_).length);
            for (int[] aint : p_286828_) {
                list.add(new String(aint, 0, aint.length));
            }
            return list;
        }).validate(Definition::validateDimensions);
        public static final MapCodec<Definition> CODEC = RecordCodecBuilder.mapCodec(p_286905_ -> p_286905_.group((App)ResourceLocation.CODEC.fieldOf("file").forGetter(Definition::file), (App)Codec.INT.optionalFieldOf("height", (Object)8).forGetter(Definition::height), (App)Codec.INT.fieldOf("ascent").forGetter(Definition::ascent), (App)CODEPOINT_GRID_CODEC.fieldOf("chars").forGetter(Definition::codepointGrid)).apply((Applicative)p_286905_, Definition::new)).validate(Definition::validate);

        private static DataResult<int[][]> validateDimensions(int[][] p_286348_) {
            int i = p_286348_.length;
            if (i == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            int[] aint = p_286348_[0];
            int j = aint.length;
            if (j == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            for (int k = 1; k < i; ++k) {
                int[] aint1 = p_286348_[k];
                if (aint1.length == j) continue;
                return DataResult.error(() -> "Lines in codepoint grid have to be the same length (found: " + aint1.length + " codepoints, expected: " + j + "), pad with \\u0000");
            }
            return DataResult.success((Object)p_286348_);
        }

        private static DataResult<Definition> validate(Definition p_286662_) {
            return p_286662_.ascent > p_286662_.height ? DataResult.error(() -> "Ascent " + p_286662_.ascent + " higher than height " + p_286662_.height) : DataResult.success((Object)p_286662_);
        }

        @Override
        public GlyphProviderType type() {
            return GlyphProviderType.BITMAP;
        }

        @Override
        public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> unpack() {
            return Either.left(this::load);
        }

        private GlyphProvider load(ResourceManager p_286694_) throws IOException {
            BitmapProvider bitmapprovider;
            ResourceLocation resourcelocation = this.file.withPrefix("textures/");
            try (InputStream inputstream = p_286694_.open(resourcelocation);){
                NativeImage nativeimage = NativeImage.read(NativeImage.Format.RGBA, inputstream);
                int i = nativeimage.getWidth();
                int j = nativeimage.getHeight();
                int k = i / this.codepointGrid[0].length;
                int l = j / this.codepointGrid.length;
                float f = (float)this.height / (float)l;
                CodepointMap<Glyph> codepointmap = new CodepointMap<Glyph>(Glyph[]::new, x$0 -> new Glyph[x$0][]);
                for (int i1 = 0; i1 < this.codepointGrid.length; ++i1) {
                    int j1 = 0;
                    for (int k1 : this.codepointGrid[i1]) {
                        int i2;
                        Glyph bitmapprovider$glyph;
                        int l1 = j1++;
                        if (k1 == 0 || (bitmapprovider$glyph = codepointmap.put(k1, new Glyph(f, nativeimage, l1 * k, i1 * l, k, l, (int)(0.5 + (double)((float)(i2 = this.getActualGlyphWidth(nativeimage, k, l, l1, i1)) * f)) + 1, this.ascent))) == null) continue;
                        LOGGER.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(k1), (Object)resourcelocation);
                    }
                }
                bitmapprovider = new BitmapProvider(nativeimage, codepointmap);
            }
            return bitmapprovider;
        }

        private int getActualGlyphWidth(NativeImage p_286449_, int p_286656_, int p_286554_, int p_286657_, int p_286307_) {
            int i;
            for (i = p_286656_ - 1; i >= 0; --i) {
                int j = p_286657_ * p_286656_ + i;
                for (int k = 0; k < p_286554_; ++k) {
                    int l = p_286307_ * p_286554_ + k;
                    if (p_286449_.getLuminanceOrAlpha(j, l) == 0) continue;
                    return i + 1;
                }
            }
            return i + 1;
        }
    }
}

