/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public record GlyphRenderTypes(RenderType normal, RenderType seeThrough, RenderType polygonOffset, RenderPipeline guiPipeline, RenderType normalBlur, RenderType seeThroughBlur, RenderType polygonOffsetBlur) {
    @Deprecated
    public GlyphRenderTypes(RenderType normal, RenderType seeThrough, RenderType polygonOffset, RenderPipeline guiPipeline) {
        this(normal, seeThrough, polygonOffset, guiPipeline, normal, seeThrough, polygonOffset);
    }

    public static GlyphRenderTypes createForIntensityTexture(ResourceLocation p_285411_) {
        return new GlyphRenderTypes(RenderType.textIntensity(p_285411_), RenderType.textIntensitySeeThrough(p_285411_), RenderType.textIntensityPolygonOffset(p_285411_), RenderPipelines.TEXT_INTENSITY, NeoForgeRenderTypes.getTextIntensityFiltered((ResourceLocation)p_285411_), NeoForgeRenderTypes.getTextIntensitySeeThroughFiltered((ResourceLocation)p_285411_), NeoForgeRenderTypes.getTextIntensityPolygonOffsetFiltered((ResourceLocation)p_285411_));
    }

    public static GlyphRenderTypes createForColorTexture(ResourceLocation p_285486_) {
        return new GlyphRenderTypes(RenderType.text(p_285486_), RenderType.textSeeThrough(p_285486_), RenderType.textPolygonOffset(p_285486_), RenderPipelines.TEXT, NeoForgeRenderTypes.getTextFiltered((ResourceLocation)p_285486_), NeoForgeRenderTypes.getTextSeeThroughFiltered((ResourceLocation)p_285486_), NeoForgeRenderTypes.getTextPolygonOffsetFiltered((ResourceLocation)p_285486_));
    }

    public RenderType select(Font.DisplayMode p_285259_) {
        return this.select(p_285259_, false);
    }

    public RenderType select(Font.DisplayMode p_285259_, boolean blur) {
        return switch (p_285259_) {
            default -> throw new MatchException(null, null);
            case Font.DisplayMode.NORMAL -> {
                if (blur) {
                    yield this.normalBlur;
                }
                yield this.normal;
            }
            case Font.DisplayMode.SEE_THROUGH -> {
                if (blur) {
                    yield this.seeThroughBlur;
                }
                yield this.seeThrough;
            }
            case Font.DisplayMode.POLYGON_OFFSET -> blur ? this.polygonOffsetBlur : this.polygonOffset;
        };
    }
}

