/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum FontOption implements StringRepresentable
{
    UNIFORM("uniform"),
    JAPANESE_VARIANTS("jp");

    public static final Codec<FontOption> CODEC;
    private final String name;

    private FontOption(String p_326260_) {
        this.name = p_326260_;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(FontOption::values);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Filter {
        private final Map<FontOption, Boolean> values;
        public static final Codec<Filter> CODEC = Codec.unboundedMap(CODEC, (Codec)Codec.BOOL).xmap(Filter::new, p_326230_ -> p_326230_.values);
        public static final Filter ALWAYS_PASS = new Filter(Map.of());

        public Filter(Map<FontOption, Boolean> p_325963_) {
            this.values = p_325963_;
        }

        public boolean apply(Set<FontOption> p_326085_) {
            for (Map.Entry<FontOption, Boolean> entry : this.values.entrySet()) {
                if (p_326085_.contains(entry.getKey()) == entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Filter merge(Filter p_326092_) {
            HashMap<FontOption, Boolean> map = new HashMap<FontOption, Boolean>(p_326092_.values);
            map.putAll(this.values);
            return new Filter(Map.copyOf(map));
        }
    }
}

