/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.AllMissingGlyphProvider;
import net.minecraft.client.gui.font.FontOption;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FontManager
implements PreparableReloadListener,
AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String FONTS_PATH = "fonts.json";
    public static final ResourceLocation MISSING_FONT = ResourceLocation.withDefaultNamespace("missing");
    private static final FileToIdConverter FONT_DEFINITIONS = FileToIdConverter.json("font");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FontSet missingFontSet;
    private final List<GlyphProvider> providersToClose = new ArrayList<GlyphProvider>();
    private final Map<ResourceLocation, FontSet> fontSets = new HashMap<ResourceLocation, FontSet>();
    private final TextureManager textureManager;
    @Nullable
    private volatile FontSet lastFontSetCache;

    public FontManager(TextureManager p_95005_) {
        this.textureManager = p_95005_;
        this.missingFontSet = Util.make(new FontSet(p_95005_, MISSING_FONT), p_325488_ -> p_325488_.reload(List.of(FontManager.createFallbackProvider()), Set.of()));
    }

    private static GlyphProvider.Conditional createFallbackProvider() {
        return new GlyphProvider.Conditional(new AllMissingGlyphProvider(), FontOption.Filter.ALWAYS_PASS);
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_285160_, ResourceManager p_285231_, Executor p_284975_, Executor p_285218_) {
        return ((CompletableFuture)this.prepare(p_285231_, p_284975_).thenCompose(p_285160_::wait)).thenAcceptAsync(p_372503_ -> this.apply((Preparation)p_372503_, Profiler.get()), p_285218_);
    }

    private CompletableFuture<Preparation> prepare(ResourceManager p_285252_, Executor p_284969_) {
        ArrayList<CompletableFuture<UnresolvedBuilderBundle>> list = new ArrayList<CompletableFuture<UnresolvedBuilderBundle>>();
        for (Map.Entry<ResourceLocation, List<Resource>> entry : FONT_DEFINITIONS.listMatchingResourceStacks(p_285252_).entrySet()) {
            ResourceLocation resourcelocation = FONT_DEFINITIONS.fileToId(entry.getKey());
            list.add(CompletableFuture.supplyAsync(() -> {
                List<Pair<BuilderId, GlyphProviderDefinition.Conditional>> list1 = FontManager.loadResourceStack((List)entry.getValue(), resourcelocation);
                UnresolvedBuilderBundle fontmanager$unresolvedbuilderbundle = new UnresolvedBuilderBundle(resourcelocation);
                for (Pair<BuilderId, GlyphProviderDefinition.Conditional> pair : list1) {
                    BuilderId fontmanager$builderid = (BuilderId)pair.getFirst();
                    FontOption.Filter fontoption$filter = ((GlyphProviderDefinition.Conditional)pair.getSecond()).filter();
                    ((GlyphProviderDefinition.Conditional)pair.getSecond()).definition().unpack().ifLeft(p_325476_ -> {
                        CompletableFuture<Optional<GlyphProvider>> completablefuture = this.safeLoad(fontmanager$builderid, (GlyphProviderDefinition.Loader)p_325476_, p_285252_, p_284969_);
                        fontmanager$unresolvedbuilderbundle.add(fontmanager$builderid, fontoption$filter, completablefuture);
                    }).ifRight(p_325470_ -> fontmanager$unresolvedbuilderbundle.add(fontmanager$builderid, fontoption$filter, (GlyphProviderDefinition.Reference)p_325470_));
                }
                return fontmanager$unresolvedbuilderbundle;
            }, p_284969_));
        }
        return Util.sequence(list).thenCompose(p_341556_ -> {
            List list1 = p_341556_.stream().flatMap(UnresolvedBuilderBundle::listBuilders).collect(Util.toMutableList());
            GlyphProvider.Conditional glyphprovider$conditional = FontManager.createFallbackProvider();
            list1.add(CompletableFuture.completedFuture(Optional.of(glyphprovider$conditional.provider())));
            return Util.sequence(list1).thenCompose(p_284618_ -> {
                Map<ResourceLocation, List<GlyphProvider.Conditional>> map = this.resolveProviders((List<UnresolvedBuilderBundle>)p_341556_);
                CompletableFuture[] completablefuture = (CompletableFuture[])map.values().stream().map(p_284585_ -> CompletableFuture.runAsync(() -> this.finalizeProviderLoading((List<GlyphProvider.Conditional>)p_284585_, glyphprovider$conditional), p_284969_)).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(completablefuture).thenApply(p_284595_ -> {
                    List<GlyphProvider> list2 = p_284618_.stream().flatMap(Optional::stream).toList();
                    return new Preparation(map, list2);
                });
            });
        });
    }

    private CompletableFuture<Optional<GlyphProvider>> safeLoad(BuilderId p_285113_, GlyphProviderDefinition.Loader p_286561_, ResourceManager p_285424_, Executor p_285371_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(p_286561_.load(p_285424_));
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load builder {}, rejecting", (Object)p_285113_, (Object)exception);
                return Optional.empty();
            }
        }, p_285371_);
    }

    private Map<ResourceLocation, List<GlyphProvider.Conditional>> resolveProviders(List<UnresolvedBuilderBundle> p_285282_) {
        HashMap<ResourceLocation, List<GlyphProvider.Conditional>> map = new HashMap<ResourceLocation, List<GlyphProvider.Conditional>>();
        DependencySorter<ResourceLocation, UnresolvedBuilderBundle> dependencysorter = new DependencySorter<ResourceLocation, UnresolvedBuilderBundle>();
        p_285282_.forEach(p_284626_ -> dependencysorter.addEntry(p_284626_.fontId, (UnresolvedBuilderBundle)p_284626_));
        dependencysorter.orderByDependencies((p_284620_, p_284621_) -> p_284621_.resolve(map::get).ifPresent(p_284590_ -> map.put((ResourceLocation)p_284620_, (List<GlyphProvider.Conditional>)p_284590_)));
        return map;
    }

    private void finalizeProviderLoading(List<GlyphProvider.Conditional> p_285520_, GlyphProvider.Conditional p_326102_) {
        p_285520_.add(0, p_326102_);
        IntOpenHashSet intset = new IntOpenHashSet();
        for (GlyphProvider.Conditional glyphprovider$conditional : p_285520_) {
            intset.addAll((IntCollection)glyphprovider$conditional.provider().getSupportedGlyphs());
        }
        intset.forEach(p_325466_ -> {
            block1: {
                GlyphProvider.Conditional glyphprovider$conditional1;
                if (p_325466_ == 32) break block1;
                Iterator iterator = Lists.reverse((List)p_285520_).iterator();
                while (iterator.hasNext() && (glyphprovider$conditional1 = (GlyphProvider.Conditional)iterator.next()).provider().getGlyph(p_325466_) == null) {
                }
            }
        });
    }

    private static Set<FontOption> getFontOptions(Options p_326037_) {
        EnumSet<FontOption> set = EnumSet.noneOf(FontOption.class);
        if (p_326037_.forceUnicodeFont().get().booleanValue()) {
            set.add(FontOption.UNIFORM);
        }
        if (p_326037_.japaneseGlyphVariants().get().booleanValue()) {
            set.add(FontOption.JAPANESE_VARIANTS);
        }
        return set;
    }

    private void apply(Preparation p_284939_, ProfilerFiller p_285407_) {
        p_285407_.push("closing");
        this.lastFontSetCache = null;
        this.fontSets.values().forEach(FontSet::close);
        this.fontSets.clear();
        this.providersToClose.forEach(GlyphProvider::close);
        this.providersToClose.clear();
        Set<FontOption> set = FontManager.getFontOptions(Minecraft.getInstance().options);
        p_285407_.popPush("reloading");
        p_284939_.fontSets().forEach((p_325478_, p_325479_) -> {
            FontSet fontset = new FontSet(this.textureManager, (ResourceLocation)p_325478_);
            fontset.reload(Lists.reverse((List)p_325479_), set);
            this.fontSets.put((ResourceLocation)p_325478_, fontset);
        });
        this.providersToClose.addAll(p_284939_.allProviders);
        p_285407_.pop();
        if (!this.fontSets.containsKey(Minecraft.DEFAULT_FONT)) {
            throw new IllegalStateException("Default font failed to load");
        }
    }

    public void updateOptions(Options p_326271_) {
        Set<FontOption> set = FontManager.getFontOptions(p_326271_);
        for (FontSet fontset : this.fontSets.values()) {
            fontset.reload(set);
        }
    }

    private static List<Pair<BuilderId, GlyphProviderDefinition.Conditional>> loadResourceStack(List<Resource> p_284976_, ResourceLocation p_285272_) {
        ArrayList<Pair<BuilderId, GlyphProviderDefinition.Conditional>> list = new ArrayList<Pair<BuilderId, GlyphProviderDefinition.Conditional>>();
        for (Resource resource : p_284976_) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    FontDefinitionFile fontmanager$fontdefinitionfile = (FontDefinitionFile)FontDefinitionFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonParseException::new);
                    List<GlyphProviderDefinition.Conditional> list1 = fontmanager$fontdefinitionfile.providers;
                    for (int i = list1.size() - 1; i >= 0; --i) {
                        BuilderId fontmanager$builderid = new BuilderId(p_285272_, resource.sourcePackId(), i);
                        list.add((Pair<BuilderId, GlyphProviderDefinition.Conditional>)Pair.of((Object)fontmanager$builderid, (Object)list1.get(i)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to load font '{}' in {} in resourcepack: '{}'", new Object[]{p_285272_, FONTS_PATH, resource.sourcePackId(), exception});
            }
        }
        return list;
    }

    public Font createFont() {
        return new Font(this::getFontSetCached, false);
    }

    public Font createFontFilterFishy() {
        return new Font(this::getFontSetCached, true);
    }

    private FontSet getFontSetRaw(ResourceLocation p_325954_) {
        return this.fontSets.getOrDefault(p_325954_, this.missingFontSet);
    }

    private FontSet getFontSetCached(ResourceLocation p_326503_) {
        FontSet fontset1;
        FontSet fontset = this.lastFontSetCache;
        if (fontset != null && p_326503_.equals(fontset.name())) {
            return fontset;
        }
        this.lastFontSetCache = fontset1 = this.getFontSetRaw(p_326503_);
        return fontset1;
    }

    @Override
    public void close() {
        this.fontSets.values().forEach(FontSet::close);
        this.providersToClose.forEach(GlyphProvider::close);
        this.missingFontSet.close();
    }

    @OnlyIn(value=Dist.CLIENT)
    record BuilderId(ResourceLocation fontId, String pack, int index) {
        @Override
        public String toString() {
            return "(" + String.valueOf(this.fontId) + ": builder #" + this.index + " from pack " + this.pack + ")";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Preparation(Map<ResourceLocation, List<GlyphProvider.Conditional>> fontSets, List<GlyphProvider> allProviders) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record FontDefinitionFile(List<GlyphProviderDefinition.Conditional> providers) {
        public static final Codec<FontDefinitionFile> CODEC = RecordCodecBuilder.create(p_325493_ -> p_325493_.group((App)GlyphProviderDefinition.Conditional.CODEC.listOf().fieldOf("providers").forGetter(FontDefinitionFile::providers)).apply((Applicative)p_325493_, FontDefinitionFile::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    record UnresolvedBuilderBundle(ResourceLocation fontId, List<BuilderResult> builders, Set<ResourceLocation> dependencies) implements DependencySorter.Entry<ResourceLocation>
    {
        public UnresolvedBuilderBundle(ResourceLocation p_284984_) {
            this(p_284984_, new ArrayList<BuilderResult>(), new HashSet<ResourceLocation>());
        }

        public void add(BuilderId p_286837_, FontOption.Filter p_326179_, GlyphProviderDefinition.Reference p_286500_) {
            this.builders.add(new BuilderResult(p_286837_, p_326179_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.right((Object)p_286500_.id())));
            this.dependencies.add(p_286500_.id());
        }

        public void add(BuilderId p_284935_, FontOption.Filter p_326423_, CompletableFuture<Optional<GlyphProvider>> p_284966_) {
            this.builders.add(new BuilderResult(p_284935_, p_326423_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.left(p_284966_)));
        }

        private Stream<CompletableFuture<Optional<GlyphProvider>>> listBuilders() {
            return this.builders.stream().flatMap(p_285041_ -> p_285041_.result.left().stream());
        }

        public Optional<List<GlyphProvider.Conditional>> resolve(Function<ResourceLocation, List<GlyphProvider.Conditional>> p_285118_) {
            ArrayList list = new ArrayList();
            for (BuilderResult fontmanager$builderresult : this.builders) {
                Optional<List<GlyphProvider.Conditional>> optional = fontmanager$builderresult.resolve(p_285118_);
                if (!optional.isPresent()) {
                    return Optional.empty();
                }
                list.addAll(optional.get());
            }
            return Optional.of(list);
        }

        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285391_) {
            this.dependencies.forEach(p_285391_);
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285405_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record BuilderResult(BuilderId id, FontOption.Filter filter, Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation> result) {
        public Optional<List<GlyphProvider.Conditional>> resolve(Function<ResourceLocation, List<GlyphProvider.Conditional>> p_284942_) {
            return (Optional)this.result.map(p_325492_ -> ((Optional)p_325492_.join()).map(p_325491_ -> List.of(new GlyphProvider.Conditional((GlyphProvider)p_325491_, this.filter))), p_325490_ -> {
                List list = (List)p_284942_.apply((ResourceLocation)p_325490_);
                if (list == null) {
                    LOGGER.warn("Can't find font {} referenced by builder {}, either because it's missing, failed to load or is part of loading cycle", p_325490_, (Object)this.id);
                    return Optional.empty();
                }
                return Optional.of(list.stream().map(this::mergeFilters).toList());
            });
        }

        private GlyphProvider.Conditional mergeFilters(GlyphProvider.Conditional p_326502_) {
            return new GlyphProvider.Conditional(p_326502_.provider(), this.filter.merge(p_326502_.filter()));
        }
    }
}

