/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.contextualbar;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.WaypointStyle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.waypoints.TrackedWaypoint;
import net.minecraft.world.waypoints.Waypoint;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocatorBarRenderer
implements ContextualBarRenderer {
    private static final ResourceLocation LOCATOR_BAR_BACKGROUND = ResourceLocation.withDefaultNamespace("hud/locator_bar_background");
    private static final ResourceLocation LOCATOR_BAR_ARROW_UP = ResourceLocation.withDefaultNamespace("hud/locator_bar_arrow_up");
    private static final ResourceLocation LOCATOR_BAR_ARROW_DOWN = ResourceLocation.withDefaultNamespace("hud/locator_bar_arrow_down");
    private static final int DOT_SIZE = 9;
    private static final int VISIBLE_DEGREE_RANGE = 60;
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 5;
    private static final int ARROW_LEFT = 1;
    private static final int ARROW_PADDING = 1;
    private final Minecraft minecraft;

    public LocatorBarRenderer(Minecraft p_416558_) {
        this.minecraft = p_416558_;
    }

    @Override
    public void renderBackground(GuiGraphics p_416273_, DeltaTracker p_416318_) {
        p_416273_.blitSprite(RenderPipelines.GUI_TEXTURED, LOCATOR_BAR_BACKGROUND, this.left(this.minecraft.getWindow()), this.top(this.minecraft.getWindow()), 182, 5);
    }

    @Override
    public void render(GuiGraphics p_415579_, DeltaTracker p_416560_) {
        int i = this.top(this.minecraft.getWindow());
        Level level = this.minecraft.cameraEntity.level();
        this.minecraft.player.connection.getWaypointManager().forEachWaypoint(this.minecraft.cameraEntity, p_421276_ -> {
            double d0;
            if (!(p_421276_.id().left().map(p_416129_ -> p_416129_.equals(this.minecraft.cameraEntity.getUUID())).orElse(false).booleanValue() || (d0 = p_421276_.yawAngleToCamera(level, this.minecraft.gameRenderer.getMainCamera())) <= -61.0 || d0 > 60.0)) {
                int j = Mth.ceil((float)(p_415579_.guiWidth() - 9) / 2.0f);
                Waypoint.Icon waypoint$icon = p_421276_.icon();
                WaypointStyle waypointstyle = this.minecraft.getWaypointStyles().get(waypoint$icon.style);
                float f = Mth.sqrt((float)p_421276_.distanceSquared(this.minecraft.cameraEntity));
                ResourceLocation resourcelocation = waypointstyle.sprite(f);
                int k = waypoint$icon.color.orElseGet(() -> (Integer)p_421276_.id().map(p_419413_ -> ARGB.setBrightness(ARGB.color(255, p_419413_.hashCode()), 0.9f), p_419414_ -> ARGB.setBrightness(ARGB.color(255, p_419414_.hashCode()), 0.9f)));
                int l = (int)(d0 * 173.0 / 2.0 / 60.0);
                p_415579_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, j + l, i - 2, 9, 9, k);
                TrackedWaypoint.PitchDirection trackedwaypoint$pitchdirection = p_421276_.pitchDirectionToCamera(level, this.minecraft.gameRenderer);
                if (trackedwaypoint$pitchdirection != TrackedWaypoint.PitchDirection.NONE) {
                    ResourceLocation resourcelocation1;
                    int i1;
                    if (trackedwaypoint$pitchdirection == TrackedWaypoint.PitchDirection.DOWN) {
                        i1 = 6;
                        resourcelocation1 = LOCATOR_BAR_ARROW_DOWN;
                    } else {
                        i1 = -6;
                        resourcelocation1 = LOCATOR_BAR_ARROW_UP;
                    }
                    p_415579_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation1, j + l + 1, i + i1, 7, 5);
                }
            }
        });
    }
}

