/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.tabs;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabNavigationBar
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    private static final int NO_TAB = -1;
    private static final int MAX_WIDTH = 400;
    private static final int HEIGHT = 24;
    private static final int MARGIN = 14;
    private static final Component USAGE_NARRATION = Component.translatable("narration.tab_navigation.usage");
    private final LinearLayout layout = LinearLayout.horizontal();
    private int width;
    private final TabManager tabManager;
    private final ImmutableList<Tab> tabs;
    private final ImmutableList<TabButton> tabButtons;

    TabNavigationBar(int p_275379_, TabManager p_275624_, Iterable<Tab> p_275279_) {
        this.width = p_275379_;
        this.tabManager = p_275624_;
        this.tabs = ImmutableList.copyOf(p_275279_);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tab tab : p_275279_) {
            builder.add((Object)this.layout.addChild(new TabButton(p_275624_, tab, 0, 24)));
        }
        this.tabButtons = builder.build();
    }

    public static Builder builder(TabManager p_268126_, int p_268070_) {
        return new Builder(p_268126_, p_268070_);
    }

    public void setWidth(int p_268094_) {
        this.width = p_268094_;
    }

    @Override
    public boolean isMouseOver(double p_387504_, double p_386568_) {
        return p_387504_ >= (double)this.layout.getX() && p_386568_ >= (double)this.layout.getY() && p_387504_ < (double)(this.layout.getX() + this.layout.getWidth()) && p_386568_ < (double)(this.layout.getY() + this.layout.getHeight());
    }

    @Override
    public void setFocused(boolean p_275488_) {
        super.setFocused(p_275488_);
        if (this.getFocused() != null) {
            this.getFocused().setFocused(p_275488_);
        }
    }

    @Override
    public void setFocused(@Nullable GuiEventListener p_275675_) {
        TabButton tabbutton;
        if (p_275675_ instanceof TabButton && (tabbutton = (TabButton)p_275675_).isActive()) {
            super.setFocused(p_275675_);
            this.tabManager.setCurrentTab(tabbutton.tab(), true);
        }
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent p_275418_) {
        TabButton tabbutton;
        if (!this.isFocused() && (tabbutton = this.currentTabButton()) != null) {
            return ComponentPath.path(this, ComponentPath.leaf(tabbutton));
        }
        return p_275418_ instanceof FocusNavigationEvent.TabNavigation ? null : super.nextFocusPath(p_275418_);
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.tabButtons;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.tabButtons.stream().map(AbstractWidget::narrationPriority).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    @Override
    public void updateNarration(NarrationElementOutput p_275583_) {
        Optional<TabButton> optional = this.tabButtons.stream().filter(AbstractWidget::isHovered).findFirst().or(() -> Optional.ofNullable(this.currentTabButton()));
        optional.ifPresent(p_274663_ -> {
            this.narrateListElementPosition(p_275583_.nest(), (TabButton)p_274663_);
            p_274663_.updateNarration(p_275583_);
        });
        if (this.isFocused()) {
            p_275583_.add(NarratedElementType.USAGE, USAGE_NARRATION);
        }
    }

    protected void narrateListElementPosition(NarrationElementOutput p_275386_, TabButton p_275397_) {
        int i;
        if (this.tabs.size() > 1 && (i = this.tabButtons.indexOf((Object)p_275397_)) != -1) {
            p_275386_.add(NarratedElementType.POSITION, (Component)Component.translatable("narrator.position.tab", i + 1, this.tabs.size()));
        }
    }

    @Override
    public void render(GuiGraphics p_281720_, int p_282085_, int p_281687_, float p_283048_) {
        p_281720_.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, 0, this.layout.getY() + this.layout.getHeight() - 2, 0.0f, 0.0f, ((TabButton)this.tabButtons.get(0)).getX(), 2, 32, 2);
        int i = ((TabButton)this.tabButtons.get(this.tabButtons.size() - 1)).getRight();
        p_281720_.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, i, this.layout.getY() + this.layout.getHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        for (TabButton tabbutton : this.tabButtons) {
            tabbutton.render(p_281720_, p_282085_, p_281687_, p_283048_);
        }
    }

    @Override
    public ScreenRectangle getRectangle() {
        return this.layout.getRectangle();
    }

    public void arrangeElements() {
        int i = Math.min(400, this.width) - 28;
        int j = Mth.roundToward(i / this.tabs.size(), 2);
        for (TabButton tabbutton : this.tabButtons) {
            tabbutton.setWidth(j);
        }
        this.layout.arrangeElements();
        this.layout.setX(Mth.roundToward((this.width - i) / 2, 2));
        this.layout.setY(0);
    }

    public void selectTab(int p_276107_, boolean p_276125_) {
        if (this.isFocused()) {
            this.setFocused((GuiEventListener)this.tabButtons.get(p_276107_));
        } else if (((TabButton)this.tabButtons.get(p_276107_)).isActive()) {
            this.tabManager.setCurrentTab((Tab)this.tabs.get(p_276107_), p_276125_);
        }
    }

    public void setTabActiveState(int p_422540_, boolean p_422357_) {
        if (p_422540_ >= 0 && p_422540_ < this.tabButtons.size()) {
            ((TabButton)this.tabButtons.get((int)p_422540_)).active = p_422357_;
        }
    }

    public void setTabTooltip(int p_422455_, @Nullable Tooltip p_422424_) {
        if (p_422455_ >= 0 && p_422455_ < this.tabButtons.size()) {
            ((TabButton)this.tabButtons.get(p_422455_)).setTooltip(p_422424_);
        }
    }

    public boolean keyPressed(int p_270495_) {
        int i;
        if (Screen.hasControlDown() && (i = this.getNextTabIndex(p_270495_)) != -1) {
            this.selectTab(Mth.clamp(i, 0, this.tabs.size() - 1), true);
            return true;
        }
        return false;
    }

    private int getNextTabIndex(int p_270508_) {
        return this.getNextTabIndex(this.currentTabIndex(), p_270508_);
    }

    private int getNextTabIndex(int p_421792_, int p_422181_) {
        if (p_422181_ >= 49 && p_422181_ <= 57) {
            return p_422181_ - 49;
        }
        if (p_422181_ == 258 && p_421792_ != -1) {
            int i = Screen.hasShiftDown() ? p_421792_ - 1 : p_421792_ + 1;
            int j = Math.floorMod(i, this.tabs.size());
            return ((TabButton)this.tabButtons.get((int)j)).active ? j : this.getNextTabIndex(j, p_422181_);
        }
        return -1;
    }

    private int currentTabIndex() {
        Tab tab = this.tabManager.getCurrentTab();
        int i = this.tabs.indexOf((Object)tab);
        return i != -1 ? i : -1;
    }

    @Nullable
    private TabButton currentTabButton() {
        int i = this.currentTabIndex();
        return i != -1 ? (TabButton)this.tabButtons.get(i) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final int width;
        private final TabManager tabManager;
        private final List<Tab> tabs = new ArrayList<Tab>();

        Builder(TabManager p_268334_, int p_267986_) {
            this.tabManager = p_268334_;
            this.width = p_267986_;
        }

        public Builder addTabs(Tab ... p_268144_) {
            Collections.addAll(this.tabs, p_268144_);
            return this;
        }

        public TabNavigationBar build() {
            return new TabNavigationBar(this.width, this.tabManager, this.tabs);
        }
    }
}

