/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.debugchart;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ResultField;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProfilerPieChart {
    public static final int RADIUS = 105;
    public static final int PIE_CHART_THICKNESS = 10;
    private static final int MARGIN = 5;
    private final Font font;
    @Nullable
    private ProfileResults profilerPieChartResults;
    private String profilerTreePath = "root";
    private int bottomOffset = 0;

    public ProfilerPieChart(Font p_362499_) {
        this.font = p_362499_;
    }

    public void setPieChartResults(@Nullable ProfileResults p_360972_) {
        this.profilerPieChartResults = p_360972_;
    }

    public void setBottomOffset(int p_364092_) {
        this.bottomOffset = p_364092_;
    }

    public void render(GuiGraphics p_363707_) {
        if (this.profilerPieChartResults != null) {
            List<ResultField> list = this.profilerPieChartResults.getTimes(this.profilerTreePath);
            ResultField resultfield = list.removeFirst();
            int i = p_363707_.guiWidth() - 105 - 10;
            int j = i - 105;
            int k = i + 105;
            int l = list.size() * 9;
            int i1 = p_363707_.guiHeight() - this.bottomOffset - 5;
            int j1 = i1 - l;
            int k1 = 62;
            int l1 = j1 - 62 - 5;
            p_363707_.fill(j - 5, l1 - 62 - 5, k + 5, i1 + 5, -1873784752);
            p_363707_.submitProfilerChartRenderState(list, j, l1 - 62 + 10, k, l1 + 62);
            DecimalFormat decimalformat = new DecimalFormat("##0.00");
            decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
            String s = ProfileResults.demanglePath(resultfield.name);
            Object s1 = "";
            if (!"unspecified".equals(s)) {
                s1 = (String)s1 + "[0] ";
            }
            s1 = s.isEmpty() ? (String)s1 + "ROOT " : (String)s1 + s + " ";
            int i2 = -1;
            int j2 = l1 - 62;
            p_363707_.drawString(this.font, (String)s1, j, j2, -1);
            s1 = decimalformat.format(resultfield.globalPercentage) + "%";
            p_363707_.drawString(this.font, (String)s1, k - this.font.width((String)s1), j2, -1);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                ResultField resultfield1 = list.get(k2);
                StringBuilder stringbuilder = new StringBuilder();
                if ("unspecified".equals(resultfield1.name)) {
                    stringbuilder.append("[?] ");
                } else {
                    stringbuilder.append("[").append(k2 + 1).append("] ");
                }
                Object s2 = stringbuilder.append(resultfield1.name).toString();
                int l2 = j1 + k2 * 9;
                p_363707_.drawString(this.font, (String)s2, j, l2, resultfield1.getColor());
                s2 = decimalformat.format(resultfield1.percentage) + "%";
                p_363707_.drawString(this.font, (String)s2, k - 50 - this.font.width((String)s2), l2, resultfield1.getColor());
                s2 = decimalformat.format(resultfield1.globalPercentage) + "%";
                p_363707_.drawString(this.font, (String)s2, k - this.font.width((String)s2), l2, resultfield1.getColor());
            }
        }
    }

    public void profilerPieChartKeyPress(int p_364522_) {
        List<ResultField> list;
        if (this.profilerPieChartResults != null && !(list = this.profilerPieChartResults.getTimes(this.profilerTreePath)).isEmpty()) {
            ResultField resultfield = list.remove(0);
            if (p_364522_ == 0) {
                int i;
                if (!resultfield.name.isEmpty() && (i = this.profilerTreePath.lastIndexOf(30)) >= 0) {
                    this.profilerTreePath = this.profilerTreePath.substring(0, i);
                }
            } else if (--p_364522_ < list.size() && !"unspecified".equals(list.get((int)p_364522_).name)) {
                if (!this.profilerTreePath.isEmpty()) {
                    this.profilerTreePath = this.profilerTreePath + "\u001e";
                }
                this.profilerTreePath = this.profilerTreePath + list.get((int)p_364522_).name;
            }
        }
    }
}

