/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.audio.ListenerTransform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubtitleOverlay
implements SoundEventListener {
    private static final long DISPLAY_TIME = 3000L;
    private final Minecraft minecraft;
    private final List<Subtitle> subtitles = Lists.newArrayList();
    private boolean isListening;
    private final List<Subtitle> audibleSubtitles = new ArrayList<Subtitle>();

    public SubtitleOverlay(Minecraft p_94641_) {
        this.minecraft = p_94641_;
    }

    public void render(GuiGraphics p_282562_) {
        SoundManager soundmanager = this.minecraft.getSoundManager();
        if (!this.isListening && this.minecraft.options.showSubtitles().get().booleanValue()) {
            soundmanager.addListener(this);
            this.isListening = true;
        } else if (this.isListening && !this.minecraft.options.showSubtitles().get().booleanValue()) {
            soundmanager.removeListener(this);
            this.isListening = false;
        }
        if (this.isListening) {
            ListenerTransform listenertransform = soundmanager.getListenerTransform();
            Vec3 vec3 = listenertransform.position();
            Vec3 vec31 = listenertransform.forward();
            Vec3 vec32 = listenertransform.right();
            this.audibleSubtitles.clear();
            for (Subtitle subtitleoverlay$subtitle : this.subtitles) {
                if (!subtitleoverlay$subtitle.isAudibleFrom(vec3)) continue;
                this.audibleSubtitles.add(subtitleoverlay$subtitle);
            }
            if (!this.audibleSubtitles.isEmpty()) {
                int l1 = 0;
                int i2 = 0;
                double d0 = this.minecraft.options.notificationDisplayTime().get();
                Iterator<Subtitle> iterator = this.audibleSubtitles.iterator();
                while (iterator.hasNext()) {
                    Subtitle subtitleoverlay$subtitle1 = iterator.next();
                    subtitleoverlay$subtitle1.purgeOldInstances(3000.0 * d0);
                    if (!subtitleoverlay$subtitle1.isStillActive()) {
                        iterator.remove();
                        continue;
                    }
                    i2 = Math.max(i2, this.minecraft.font.width(subtitleoverlay$subtitle1.getText()));
                }
                i2 += this.minecraft.font.width("<") + this.minecraft.font.width(" ") + this.minecraft.font.width(">") + this.minecraft.font.width(" ");
                if (!this.audibleSubtitles.isEmpty()) {
                    p_282562_.nextStratum();
                }
                for (Subtitle subtitleoverlay$subtitle2 : this.audibleSubtitles) {
                    int i = 255;
                    Component component = subtitleoverlay$subtitle2.getText();
                    SoundPlayedAt subtitleoverlay$soundplayedat = subtitleoverlay$subtitle2.getClosest(vec3);
                    if (subtitleoverlay$soundplayedat == null) continue;
                    Vec3 vec33 = subtitleoverlay$soundplayedat.location.subtract(vec3).normalize();
                    double d1 = vec32.dot(vec33);
                    double d2 = vec31.dot(vec33);
                    boolean flag = d2 > 0.5;
                    int j = i2 / 2;
                    int k = 9;
                    int l = k / 2;
                    float f = 1.0f;
                    int i1 = this.minecraft.font.width(component);
                    int j1 = Mth.floor(Mth.clampedLerp(255.0f, 75.0f, (float)(Util.getMillis() - subtitleoverlay$soundplayedat.time) / (float)(3000.0 * d0)));
                    p_282562_.pose().pushMatrix();
                    p_282562_.pose().translate((float)p_282562_.guiWidth() - (float)j * 1.0f - 2.0f, (float)(p_282562_.guiHeight() - 35) - (float)(l1 * (k + 1)) * 1.0f);
                    p_282562_.pose().scale(1.0f, 1.0f);
                    p_282562_.fill(-j - 1, -l - 1, j + 1, l + 1, this.minecraft.options.getBackgroundColor(0.8f));
                    int k1 = ARGB.color(255, j1, j1, j1);
                    if (!flag) {
                        if (d1 > 0.0) {
                            p_282562_.drawString(this.minecraft.font, ">", j - this.minecraft.font.width(">"), -l, k1);
                        } else if (d1 < 0.0) {
                            p_282562_.drawString(this.minecraft.font, "<", -j, -l, k1);
                        }
                    }
                    p_282562_.drawString(this.minecraft.font, component, -i1 / 2, -l, k1);
                    p_282562_.pose().popMatrix();
                    ++l1;
                }
            }
        }
    }

    @Override
    public void onPlaySound(SoundInstance p_94645_, WeighedSoundEvents p_94646_, float p_314721_) {
        if (p_94646_.getSubtitle() != null) {
            Component component = p_94646_.getSubtitle();
            if (!this.subtitles.isEmpty()) {
                for (Subtitle subtitleoverlay$subtitle : this.subtitles) {
                    if (!subtitleoverlay$subtitle.getText().equals(component)) continue;
                    subtitleoverlay$subtitle.refresh(new Vec3(p_94645_.getX(), p_94645_.getY(), p_94645_.getZ()));
                    return;
                }
            }
            this.subtitles.add(new Subtitle(component, p_314721_, new Vec3(p_94645_.getX(), p_94645_.getY(), p_94645_.getZ())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Subtitle {
        private final Component text;
        private final float range;
        private final List<SoundPlayedAt> playedAt = new ArrayList<SoundPlayedAt>();

        public Subtitle(Component p_169072_, float p_314705_, Vec3 p_169073_) {
            this.text = p_169072_;
            this.range = p_314705_;
            this.playedAt.add(new SoundPlayedAt(p_169073_, Util.getMillis()));
        }

        public Component getText() {
            return this.text;
        }

        @Nullable
        public SoundPlayedAt getClosest(Vec3 p_347452_) {
            if (this.playedAt.isEmpty()) {
                return null;
            }
            return this.playedAt.size() == 1 ? this.playedAt.getFirst() : (SoundPlayedAt)this.playedAt.stream().min(Comparator.comparingDouble(p_347541_ -> p_347541_.location().distanceTo(p_347452_))).orElse(null);
        }

        public void refresh(Vec3 p_94657_) {
            this.playedAt.removeIf(p_347631_ -> p_94657_.equals(p_347631_.location()));
            this.playedAt.add(new SoundPlayedAt(p_94657_, Util.getMillis()));
        }

        public boolean isAudibleFrom(Vec3 p_314706_) {
            if (Float.isInfinite(this.range)) {
                return true;
            }
            if (this.playedAt.isEmpty()) {
                return false;
            }
            SoundPlayedAt subtitleoverlay$soundplayedat = this.getClosest(p_314706_);
            return subtitleoverlay$soundplayedat == null ? false : p_314706_.closerThan(subtitleoverlay$soundplayedat.location, this.range);
        }

        public void purgeOldInstances(double p_347730_) {
            long i = Util.getMillis();
            this.playedAt.removeIf(p_347590_ -> (double)(i - p_347590_.time()) > p_347730_);
        }

        public boolean isStillActive() {
            return !this.playedAt.isEmpty();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record SoundPlayedAt(Vec3 location, long time) {
    }
}

