/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScrollableLayout
implements Layout {
    private static final int SCROLLBAR_SPACING = 4;
    private static final int SCROLLBAR_RESERVE = 10;
    final Layout content;
    private final Container container;
    private int minWidth;
    private int maxHeight;

    public ScrollableLayout(Minecraft p_426169_, Layout p_426152_, int p_425532_) {
        this.content = p_426152_;
        this.container = new Container(p_426169_, 0, p_425532_);
    }

    public void setMinWidth(int p_425663_) {
        this.minWidth = p_425663_;
        this.container.setWidth(Math.max(this.content.getWidth(), p_425663_));
    }

    public void setMaxHeight(int p_425760_) {
        this.maxHeight = p_425760_;
        this.container.setHeight(Math.min(this.content.getHeight(), p_425760_));
        this.container.refreshScrollAmount();
    }

    @Override
    public void arrangeElements() {
        this.content.arrangeElements();
        int i = this.content.getWidth();
        this.container.setWidth(Math.max(i + 20, this.minWidth));
        this.container.setHeight(Math.min(this.content.getHeight(), this.maxHeight));
        this.container.refreshScrollAmount();
    }

    @Override
    public void visitChildren(Consumer<LayoutElement> p_425954_) {
        p_425954_.accept(this.container);
    }

    @Override
    public void setX(int p_425725_) {
        this.container.setX(p_425725_);
    }

    @Override
    public void setY(int p_426034_) {
        this.container.setY(p_426034_);
    }

    @Override
    public int getX() {
        return this.container.getX();
    }

    @Override
    public int getY() {
        return this.container.getY();
    }

    @Override
    public int getWidth() {
        return this.container.getWidth();
    }

    @Override
    public int getHeight() {
        return this.container.getHeight();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Container
    extends AbstractContainerWidget {
        private final Minecraft minecraft;
        private final List<AbstractWidget> children;

        public Container(Minecraft p_426246_, int p_426266_, int p_425661_) {
            super(0, 0, p_426266_, p_425661_, CommonComponents.EMPTY);
            this.children = new ArrayList<AbstractWidget>();
            this.minecraft = p_426246_;
            ScrollableLayout.this.content.visitWidgets(this.children::add);
        }

        @Override
        protected int contentHeight() {
            return ScrollableLayout.this.content.getHeight();
        }

        @Override
        protected double scrollRate() {
            return 10.0;
        }

        @Override
        protected void renderWidget(GuiGraphics p_426247_, int p_426123_, int p_425847_, float p_426024_) {
            p_426247_.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
            for (AbstractWidget abstractwidget : this.children) {
                abstractwidget.render(p_426247_, p_426123_, p_425847_, p_426024_);
            }
            p_426247_.disableScissor();
            this.renderScrollbar(p_426247_);
        }

        @Override
        protected void updateWidgetNarration(NarrationElementOutput p_425517_) {
        }

        @Override
        public ScreenRectangle getBorderForArrowNavigation(ScreenDirection p_425900_) {
            return new ScreenRectangle(this.getX(), this.getY(), this.width, this.contentHeight());
        }

        @Override
        public void setFocused(@Nullable GuiEventListener p_425886_) {
            super.setFocused(p_425886_);
            if (p_425886_ != null && this.minecraft.getLastInputType().isKeyboard()) {
                ScreenRectangle screenrectangle = this.getRectangle();
                ScreenRectangle screenrectangle1 = p_425886_.getRectangle();
                int i = screenrectangle1.top() - screenrectangle.top();
                int j = screenrectangle1.bottom() - screenrectangle.bottom();
                if (i < 0) {
                    this.setScrollAmount(this.scrollAmount() + (double)i - 14.0);
                } else if (j > 0) {
                    this.setScrollAmount(this.scrollAmount() + (double)j + 14.0);
                }
            }
        }

        @Override
        public void setX(int p_425593_) {
            super.setX(p_425593_);
            ScrollableLayout.this.content.setX(p_425593_ + 10);
        }

        @Override
        public void setY(int p_425526_) {
            super.setY(p_425526_);
            ScrollableLayout.this.content.setY(p_425526_ - (int)this.scrollAmount());
        }

        @Override
        public void setScrollAmount(double p_426096_) {
            super.setScrollAmount(p_426096_);
            ScrollableLayout.this.content.setY(this.getRectangle().top() - (int)this.scrollAmount());
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @Override
        public Collection<? extends NarratableEntry> getNarratables() {
            return this.children;
        }
    }
}

