/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PopupScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("popup/background");
    private static final int SPACING = 12;
    private static final int BG_BORDER_WITH_SPACING = 18;
    private static final int BUTTON_SPACING = 6;
    private static final int IMAGE_SIZE_X = 130;
    private static final int IMAGE_SIZE_Y = 64;
    private static final int POPUP_DEFAULT_WIDTH = 250;
    private final Screen backgroundScreen;
    @Nullable
    private final ResourceLocation image;
    private final Component message;
    private final List<ButtonOption> buttons;
    @Nullable
    private final Runnable onClose;
    private final int contentWidth;
    private final LinearLayout layout = LinearLayout.vertical();

    PopupScreen(Screen p_304589_, int p_304486_, @Nullable ResourceLocation p_304853_, Component p_304839_, Component p_304571_, List<ButtonOption> p_304767_, @Nullable Runnable p_304826_) {
        super(p_304839_);
        this.backgroundScreen = p_304589_;
        this.image = p_304853_;
        this.message = p_304571_;
        this.buttons = p_304767_;
        this.onClose = p_304826_;
        this.contentWidth = p_304486_ - 36;
    }

    @Override
    public void added() {
        super.added();
        this.backgroundScreen.clearFocus();
    }

    @Override
    protected void init() {
        this.backgroundScreen.init(this.minecraft, this.width, this.height);
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild(new MultiLineTextWidget(this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(this.contentWidth).setCentered(true));
        if (this.image != null) {
            this.layout.addChild(ImageWidget.texture(130, 64, this.image, 130, 64));
        }
        this.layout.addChild(new MultiLineTextWidget(this.message, this.font).setMaxWidth(this.contentWidth).setCentered(true));
        this.layout.addChild(this.buildButtonRow());
        this.layout.visitWidgets(p_321353_ -> {
            AbstractWidget abstractwidget = this.addRenderableWidget(p_321353_);
        });
        this.repositionElements();
    }

    private LinearLayout buildButtonRow() {
        int i = 6 * (this.buttons.size() - 1);
        int j = Math.min((this.contentWidth - i) / this.buttons.size(), 150);
        LinearLayout linearlayout = LinearLayout.horizontal();
        linearlayout.spacing(6);
        for (ButtonOption popupscreen$buttonoption : this.buttons) {
            linearlayout.addChild(Button.builder(popupscreen$buttonoption.message(), p_304831_ -> popupscreen$buttonoption.action().accept(this)).width(j).build());
        }
        return linearlayout;
    }

    @Override
    protected void repositionElements() {
        this.backgroundScreen.resize(this.minecraft, this.width, this.height);
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle(this.layout, this.getRectangle());
    }

    @Override
    public void renderBackground(GuiGraphics p_304909_, int p_304478_, int p_304974_, float p_304456_) {
        this.backgroundScreen.renderBackground(p_304909_, p_304478_, p_304974_, p_304456_);
        p_304909_.nextStratum();
        this.backgroundScreen.render(p_304909_, -1, -1, p_304456_);
        p_304909_.nextStratum();
        this.renderTransparentBackground(p_304909_);
        p_304909_.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    @Override
    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration(this.title, this.message);
    }

    @Override
    public void onClose() {
        if (this.onClose != null) {
            this.onClose.run();
        }
        this.minecraft.setScreen(this.backgroundScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    record ButtonOption(Component message, Consumer<PopupScreen> action) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Screen backgroundScreen;
        private final Component title;
        private Component message = CommonComponents.EMPTY;
        private int width = 250;
        @Nullable
        private ResourceLocation image;
        private final List<ButtonOption> buttons = new ArrayList<ButtonOption>();
        @Nullable
        private Runnable onClose = null;

        public Builder(Screen p_304648_, Component p_304584_) {
            this.backgroundScreen = p_304648_;
            this.title = p_304584_;
        }

        public Builder setWidth(int p_304576_) {
            this.width = p_304576_;
            return this;
        }

        public Builder setImage(ResourceLocation p_304597_) {
            this.image = p_304597_;
            return this;
        }

        public Builder setMessage(Component p_304550_) {
            this.message = p_304550_;
            return this;
        }

        public Builder addButton(Component p_304733_, Consumer<PopupScreen> p_304537_) {
            this.buttons.add(new ButtonOption(p_304733_, p_304537_));
            return this;
        }

        public Builder onClose(Runnable p_304557_) {
            this.onClose = p_304557_;
            return this;
        }

        public PopupScreen build() {
            if (this.buttons.isEmpty()) {
                throw new IllegalStateException("Popup must have at least one button");
            }
            return new PopupScreen(this.backgroundScreen, this.width, this.image, this.title, this.message, List.copyOf(this.buttons), this.onClose);
        }
    }
}

