/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerSkinWidget
extends AbstractWidget {
    private static final float MODEL_HEIGHT = 2.125f;
    private static final float FIT_SCALE = 0.97f;
    private static final float ROTATION_SENSITIVITY = 2.5f;
    private static final float DEFAULT_ROTATION_X = -5.0f;
    private static final float DEFAULT_ROTATION_Y = 30.0f;
    private static final float ROTATION_X_LIMIT = 50.0f;
    private final PlayerModel wideModel;
    private final PlayerModel slimModel;
    private final Supplier<PlayerSkin> skin;
    private float rotationX = -5.0f;
    private float rotationY = 30.0f;

    public PlayerSkinWidget(int p_300014_, int p_299867_, EntityModelSet p_299948_, Supplier<PlayerSkin> p_299853_) {
        super(0, 0, p_300014_, p_299867_, CommonComponents.EMPTY);
        this.wideModel = new PlayerModel(p_299948_.bakeLayer(ModelLayers.PLAYER), false);
        this.slimModel = new PlayerModel(p_299948_.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.skin = p_299853_;
    }

    @Override
    protected void renderWidget(GuiGraphics p_299897_, int p_299826_, int p_300009_, float p_299921_) {
        float f = 0.97f * (float)this.getHeight() / 2.125f;
        float f1 = -1.0625f;
        PlayerSkin playerskin = this.skin.get();
        PlayerModel playermodel = playerskin.model() == PlayerSkin.Model.SLIM ? this.slimModel : this.wideModel;
        p_299897_.submitSkinRenderState(playermodel, playerskin.texture(), f, this.rotationX, this.rotationY, -1.0625f, this.getX(), this.getY(), this.getRight(), this.getBottom());
    }

    @Override
    protected void onDrag(double p_299829_, double p_299876_, double p_300028_, double p_299872_) {
        this.rotationX = Mth.clamp(this.rotationX - (float)p_299872_ * 2.5f, -50.0f, 50.0f);
        this.rotationY += (float)p_300028_ * 2.5f;
    }

    @Override
    public void playDownSound(SoundManager p_299880_) {
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput p_299955_) {
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent p_299934_) {
        return null;
    }
}

