/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.OptionalInt;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.SingleKeyCache;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MultiLineTextWidget
extends AbstractStringWidget {
    private OptionalInt maxWidth = OptionalInt.empty();
    private OptionalInt maxRows = OptionalInt.empty();
    private final SingleKeyCache<CacheKey, MultiLineLabel> cache = Util.singleKeyCache(p_352660_ -> p_352660_.maxRows.isPresent() ? MultiLineLabel.create(p_270673_, p_352660_.maxWidth, p_352660_.maxRows.getAsInt(), p_352660_.message) : MultiLineLabel.create(p_270673_, p_352660_.message, p_352660_.maxWidth));
    private boolean centered = false;
    private boolean allowHoverComponents = false;
    @Nullable
    private Consumer<Style> componentClickHandler = null;

    public MultiLineTextWidget(Component p_270532_, Font p_270639_) {
        this(0, 0, p_270532_, p_270639_);
    }

    public MultiLineTextWidget(int p_270325_, int p_270355_, Component p_270069_, Font p_270673_) {
        super(p_270325_, p_270355_, 0, 0, p_270069_, p_270673_);
        this.active = false;
    }

    @Override
    public MultiLineTextWidget setColor(int p_270378_) {
        super.setColor(p_270378_);
        return this;
    }

    public MultiLineTextWidget setMaxWidth(int p_270776_) {
        this.maxWidth = OptionalInt.of(p_270776_);
        return this;
    }

    public MultiLineTextWidget setMaxRows(int p_270085_) {
        this.maxRows = OptionalInt.of(p_270085_);
        return this;
    }

    public MultiLineTextWidget setCentered(boolean p_270493_) {
        this.centered = p_270493_;
        return this;
    }

    public MultiLineTextWidget configureStyleHandling(boolean p_428327_, @Nullable Consumer<Style> p_428289_) {
        this.allowHoverComponents = p_428327_;
        this.componentClickHandler = p_428289_;
        return this;
    }

    @Override
    public int getWidth() {
        return this.cache.getValue(this.getFreshCacheKey()).getWidth();
    }

    @Override
    public int getHeight() {
        return this.cache.getValue(this.getFreshCacheKey()).getLineCount() * 9;
    }

    @Override
    public void renderWidget(GuiGraphics p_282535_, int p_261774_, int p_261640_, float p_261514_) {
        MultiLineLabel multilinelabel = this.cache.getValue(this.getFreshCacheKey());
        int i = this.getX();
        int j = this.getY();
        int k = 9;
        int l = this.getColor();
        if (this.centered) {
            multilinelabel.renderCentered(p_282535_, i + this.getWidth() / 2, j, k, l);
        } else {
            multilinelabel.renderLeftAligned(p_282535_, i, j, k, l);
        }
        if (this.allowHoverComponents) {
            Style style = this.getComponentStyleAt(p_261774_, p_261640_);
            if (this.isHovered()) {
                p_282535_.renderComponentHoverEffect(this.getFont(), style, p_261774_, p_261640_);
            }
        }
    }

    @Nullable
    private Style getComponentStyleAt(double p_428536_, double p_428335_) {
        MultiLineLabel multilinelabel = this.cache.getValue(this.getFreshCacheKey());
        int i = this.getX();
        int j = this.getY();
        int k = 9;
        return this.centered ? multilinelabel.getStyleAtCentered(i + this.getWidth() / 2, j, k, p_428536_, p_428335_) : multilinelabel.getStyleAtLeftAligned(i, j, k, p_428536_, p_428335_);
    }

    @Override
    public void onClick(double p_428318_, double p_428462_) {
        Style style;
        if (this.componentClickHandler != null && (style = this.getComponentStyleAt(p_428318_, p_428462_)) != null) {
            this.componentClickHandler.accept(style);
            return;
        }
        super.onClick(p_428318_, p_428462_);
    }

    private CacheKey getFreshCacheKey() {
        return new CacheKey(this.getMessage(), this.maxWidth.orElse(Integer.MAX_VALUE), this.maxRows);
    }

    @OnlyIn(value=Dist.CLIENT)
    record CacheKey(Component message, int maxWidth, OptionalInt maxRows) {
    }
}

