/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ContainerObjectSelectionList<E extends Entry<E>>
extends AbstractSelectionList<E> {
    public ContainerObjectSelectionList(Minecraft p_94010_, int p_94011_, int p_94012_, int p_94013_, int p_94014_) {
        super(p_94010_, p_94011_, p_94012_, p_94013_, p_94014_);
    }

    public ContainerObjectSelectionList(Minecraft p_388407_, int p_387977_, int p_388914_, int p_388893_, int p_387037_, int p_386908_) {
        super(p_388407_, p_387977_, p_388914_, p_388893_, p_387037_, p_386908_);
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent p_265385_) {
        ComponentPath componentpath;
        if (this.getItemCount() == 0) {
            return null;
        }
        if (!(p_265385_ instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.nextFocusPath(p_265385_);
        }
        FocusNavigationEvent.ArrowNavigation focusnavigationevent$arrownavigation = (FocusNavigationEvent.ArrowNavigation)p_265385_;
        Entry e = (Entry)this.getFocused();
        if (focusnavigationevent$arrownavigation.direction().getAxis() == ScreenAxis.HORIZONTAL && e != null) {
            return ComponentPath.path(this, e.nextFocusPath(p_265385_));
        }
        int i = -1;
        ScreenDirection screendirection = focusnavigationevent$arrownavigation.direction();
        if (e != null) {
            i = e.children().indexOf(e.getFocused());
        }
        if (i == -1) {
            switch (screendirection) {
                case LEFT: {
                    i = Integer.MAX_VALUE;
                    screendirection = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    i = 0;
                    screendirection = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        Entry e1 = e;
        do {
            if ((e1 = this.nextEntry(screendirection, p_425132_ -> !p_425132_.children().isEmpty(), e1)) != null) continue;
            return null;
        } while ((componentpath = e1.focusPathAtIndex(focusnavigationevent$arrownavigation, i)) == null);
        return ComponentPath.path(this, componentpath);
    }

    @Override
    public void setFocused(@Nullable GuiEventListener p_265559_) {
        if (this.getFocused() != p_265559_) {
            super.setFocused(p_265559_);
            if (p_265559_ == null) {
                this.setSelected(null);
            }
        }
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : super.narrationPriority();
    }

    @Override
    protected boolean isSelectedItem(int p_94019_) {
        return false;
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_313707_) {
        Entry e = (Entry)this.getHovered();
        if (e != null) {
            e.updateNarration(p_313707_.nest());
            this.narrateListElementPosition(p_313707_, e);
        } else {
            Entry e1 = (Entry)this.getFocused();
            if (e1 != null) {
                e1.updateNarration(p_313707_.nest());
                this.narrateListElementPosition(p_313707_, e1);
            }
        }
        p_313707_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.component_list.usage"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    extends AbstractSelectionList.Entry<E>
    implements ContainerEventHandler {
        @Nullable
        private GuiEventListener focused;
        @Nullable
        private NarratableEntry lastNarratable;
        private boolean dragging;

        @Override
        public boolean isDragging() {
            return this.dragging;
        }

        @Override
        public void setDragging(boolean p_94028_) {
            this.dragging = p_94028_;
        }

        @Override
        public boolean mouseClicked(double p_265453_, double p_265297_, int p_265697_) {
            return ContainerEventHandler.super.mouseClicked(p_265453_, p_265297_, p_265697_);
        }

        @Override
        public void setFocused(@Nullable GuiEventListener p_94024_) {
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (p_94024_ != null) {
                p_94024_.setFocused(true);
            }
            this.focused = p_94024_;
        }

        @Override
        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent p_265435_, int p_265432_) {
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath componentpath = this.children().get(Math.min(p_265432_, this.children().size() - 1)).nextFocusPath(p_265435_);
            return ComponentPath.path(this, componentpath);
        }

        @Override
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent p_265672_) {
            if (p_265672_ instanceof FocusNavigationEvent.ArrowNavigation) {
                int j;
                int i;
                FocusNavigationEvent.ArrowNavigation focusnavigationevent$arrownavigation = (FocusNavigationEvent.ArrowNavigation)p_265672_;
                switch (focusnavigationevent$arrownavigation.direction()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        int n = -1;
                        break;
                    }
                    case RIGHT: {
                        int n = 1;
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        int n = i = 0;
                    }
                }
                if (i == 0) {
                    return null;
                }
                for (int k = j = Mth.clamp(i + this.children().indexOf(this.getFocused()), 0, this.children().size() - 1); k >= 0 && k < this.children().size(); k += i) {
                    GuiEventListener guieventlistener = this.children().get(k);
                    ComponentPath componentpath = guieventlistener.nextFocusPath(p_265672_);
                    if (componentpath == null) continue;
                    return ComponentPath.path(this, componentpath);
                }
            }
            return ContainerEventHandler.super.nextFocusPath(p_265672_);
        }

        public abstract List<? extends NarratableEntry> narratables();

        void updateNarration(NarrationElementOutput p_168855_) {
            List<NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult screen$narratablesearchresult = Screen.findNarratableWidget(list, this.lastNarratable);
            if (screen$narratablesearchresult != null) {
                if (screen$narratablesearchresult.priority.isTerminal()) {
                    this.lastNarratable = screen$narratablesearchresult.entry;
                }
                if (list.size() > 1) {
                    p_168855_.add(NarratedElementType.POSITION, (Component)Component.translatable("narrator.position.object_list", screen$narratablesearchresult.index + 1, list.size()));
                    if (screen$narratablesearchresult.priority == NarratableEntry.NarrationPriority.FOCUSED) {
                        p_168855_.add(NarratedElementType.USAGE, (Component)Component.translatable("narration.component_list.usage"));
                    }
                }
                screen$narratablesearchresult.entry.updateNarration(p_168855_.nest());
            }
        }
    }
}

