/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.ColoredRectangleRenderState;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.render.state.pip.GuiBannerResultRenderState;
import net.minecraft.client.gui.render.state.pip.GuiBookModelRenderState;
import net.minecraft.client.gui.render.state.pip.GuiEntityRenderState;
import net.minecraft.client.gui.render.state.pip.GuiProfilerChartRenderState;
import net.minecraft.client.gui.render.state.pip.GuiSignRenderState;
import net.minecraft.client.gui.render.state.pip.GuiSkinRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.IGuiGraphicsExtension;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Quaternionf;
import org.joml.Vector2ic;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GuiGraphics
implements IGuiGraphicsExtension {
    private static final int EXTRA_SPACE_AFTER_FIRST_TOOLTIP_LINE = 2;
    private final Minecraft minecraft;
    private final Matrix3x2fStack pose;
    private final ScissorStack scissorStack = new ScissorStack();
    private final GuiSpriteManager sprites;
    private final GuiRenderState guiRenderState;
    @Nullable
    private Runnable deferredTooltip;
    private ItemStack tooltipStack = ItemStack.EMPTY;

    private GuiGraphics(Minecraft p_282144_, Matrix3x2fStack p_415937_, GuiRenderState p_415955_) {
        this.minecraft = p_282144_;
        this.pose = p_415937_;
        this.sprites = p_282144_.getGuiSprites();
        this.guiRenderState = p_415955_;
    }

    public GuiGraphics(Minecraft p_283406_, GuiRenderState p_416249_) {
        this(p_283406_, new Matrix3x2fStack(16), p_416249_);
    }

    public int guiWidth() {
        return this.minecraft.getWindow().getGuiScaledWidth();
    }

    public int guiHeight() {
        return this.minecraft.getWindow().getGuiScaledHeight();
    }

    public void nextStratum() {
        this.guiRenderState.nextStratum();
    }

    public void blurBeforeThisStratum() {
        this.guiRenderState.blurBeforeThisStratum();
    }

    public Matrix3x2fStack pose() {
        return this.pose;
    }

    public void hLine(int p_283318_, int p_281662_, int p_281346_, int p_281672_) {
        if (p_281662_ < p_283318_) {
            int i = p_283318_;
            p_283318_ = p_281662_;
            p_281662_ = i;
        }
        this.fill(p_283318_, p_281346_, p_281662_ + 1, p_281346_ + 1, p_281672_);
    }

    public void vLine(int p_282951_, int p_281591_, int p_281568_, int p_282718_) {
        if (p_281568_ < p_281591_) {
            int i = p_281591_;
            p_281591_ = p_281568_;
            p_281568_ = i;
        }
        this.fill(p_282951_, p_281591_ + 1, p_282951_ + 1, p_281568_, p_282718_);
    }

    public void enableScissor(int p_281479_, int p_282788_, int p_282924_, int p_282826_) {
        ScreenRectangle screenrectangle = new ScreenRectangle(p_281479_, p_282788_, p_282924_ - p_281479_, p_282826_ - p_282788_).transformAxisAligned((Matrix3x2f)this.pose);
        this.scissorStack.push(screenrectangle);
    }

    public void disableScissor() {
        this.scissorStack.pop();
    }

    public boolean containsPointInScissor(int p_332689_, int p_332771_) {
        return this.scissorStack.containsPoint(p_332689_, p_332771_);
    }

    public void fill(int p_282988_, int p_282861_, int p_281278_, int p_281710_, int p_281470_) {
        this.fill(RenderPipelines.GUI, p_282988_, p_282861_, p_281278_, p_281710_, p_281470_);
    }

    public void fill(RenderPipeline p_416410_, int p_281437_, int p_283660_, int p_282606_, int p_283413_, int p_283428_) {
        if (p_281437_ < p_282606_) {
            int i = p_281437_;
            p_281437_ = p_282606_;
            p_282606_ = i;
        }
        if (p_283660_ < p_283413_) {
            int j = p_283660_;
            p_283660_ = p_283413_;
            p_283413_ = j;
        }
        this.submitColoredRectangle(p_416410_, TextureSetup.noTexture(), p_281437_, p_283660_, p_282606_, p_283413_, p_283428_, null);
    }

    public void fillGradient(int p_283290_, int p_283278_, int p_282670_, int p_281698_, int p_283374_, int p_283076_) {
        this.submitColoredRectangle(RenderPipelines.GUI, TextureSetup.noTexture(), p_283290_, p_283278_, p_282670_, p_281698_, p_283374_, p_283076_);
    }

    public void fill(RenderPipeline p_416027_, TextureSetup p_415746_, int p_286234_, int p_286444_, int p_286244_, int p_286411_) {
        this.submitColoredRectangle(p_416027_, p_415746_, p_286234_, p_286444_, p_286244_, p_286411_, -1, null);
    }

    private void submitColoredRectangle(RenderPipeline p_416727_, TextureSetup p_416131_, int p_415712_, int p_416427_, int p_416376_, int p_415748_, int p_415666_, @Nullable Integer p_415938_) {
        this.guiRenderState.submitGuiElement(new ColoredRectangleRenderState(p_416727_, p_416131_, new Matrix3x2f((Matrix3x2fc)this.pose), p_415712_, p_416427_, p_416376_, p_415748_, p_415666_, p_415938_ != null ? p_415938_ : p_415666_, this.scissorStack.peek()));
    }

    public void textHighlight(int p_428831_, int p_428851_, int p_428846_, int p_428835_) {
        this.fill(RenderPipelines.GUI_INVERT, p_428831_, p_428851_, p_428846_, p_428835_, -1);
        this.fill(RenderPipelines.GUI_TEXT_HIGHLIGHT, p_428831_, p_428851_, p_428846_, p_428835_, -16776961);
    }

    public void drawCenteredString(Font p_282122_, String p_282898_, int p_281490_, int p_282853_, int p_281258_) {
        this.drawString(p_282122_, p_282898_, p_281490_ - p_282122_.width(p_282898_) / 2, p_282853_, p_281258_);
    }

    public void drawCenteredString(Font p_282901_, Component p_282456_, int p_283083_, int p_282276_, int p_281457_) {
        FormattedCharSequence formattedcharsequence = p_282456_.getVisualOrderText();
        this.drawString(p_282901_, formattedcharsequence, p_283083_ - p_282901_.width(formattedcharsequence) / 2, p_282276_, p_281457_);
    }

    public void drawCenteredString(Font p_282592_, FormattedCharSequence p_281854_, int p_281573_, int p_283511_, int p_282577_) {
        this.drawString(p_282592_, p_281854_, p_281573_ - p_282592_.width(p_281854_) / 2, p_283511_, p_282577_);
    }

    public void drawString(Font p_282003_, @Nullable String p_281403_, int p_282714_, int p_282041_, int p_281908_) {
        this.drawString(p_282003_, p_281403_, p_282714_, p_282041_, p_281908_, true);
    }

    public void drawString(Font p_283019_, @Nullable String p_415853_, int p_283379_, int p_283346_, int p_282119_, boolean p_416601_) {
        if (p_415853_ != null) {
            this.drawString(p_283019_, Language.getInstance().getVisualOrder(FormattedText.of(p_415853_)), p_283379_, p_283346_, p_282119_, p_416601_);
        }
    }

    public void drawString(Font p_281653_, FormattedCharSequence p_416271_, int p_283102_, int p_282347_, int p_281429_) {
        this.drawString(p_281653_, p_416271_, p_283102_, p_282347_, p_281429_, true);
    }

    public void drawString(Font p_283343_, FormattedCharSequence p_416388_, int p_283569_, int p_283418_, int p_281560_, boolean p_282130_) {
        if (ARGB.alpha(p_281560_) != 0) {
            this.guiRenderState.submitText(new GuiTextRenderState(p_283343_, p_416388_, new Matrix3x2f((Matrix3x2fc)this.pose), p_283569_, p_283418_, p_281560_, 0, p_282130_, this.scissorStack.peek()));
        }
    }

    public void drawString(Font p_281547_, Component p_282131_, int p_282857_, int p_281250_, int p_282195_) {
        this.drawString(p_281547_, p_282131_, p_282857_, p_281250_, p_282195_, true);
    }

    public void drawString(Font p_282636_, Component p_416319_, int p_281586_, int p_282816_, int p_281743_, boolean p_282394_) {
        this.drawString(p_282636_, p_416319_.getVisualOrderText(), p_281586_, p_282816_, p_281743_, p_282394_);
    }

    public void drawWordWrap(Font p_281494_, FormattedText p_283463_, int p_282183_, int p_283250_, int p_282564_, int p_282629_) {
        this.drawWordWrap(p_281494_, p_283463_, p_282183_, p_283250_, p_282564_, p_282629_, true);
    }

    public void drawWordWrap(Font p_382905_, FormattedText p_382794_, int p_383047_, int p_382923_, int p_382857_, int p_382915_, boolean p_383224_) {
        for (FormattedCharSequence formattedcharsequence : p_382905_.split(p_382794_, p_382857_)) {
            this.drawString(p_382905_, formattedcharsequence, p_383047_, p_382923_, p_382915_, p_383224_);
            p_382923_ += 9;
        }
    }

    public void drawStringWithBackdrop(Font p_348650_, Component p_348614_, int p_348465_, int p_348495_, int p_348581_, int p_348666_) {
        int i = this.minecraft.options.getBackgroundColor(0.0f);
        if (i != 0) {
            int j = 2;
            this.fill(p_348465_ - 2, p_348495_ - 2, p_348465_ + p_348581_ + 2, p_348495_ + 9 + 2, ARGB.multiply(i, p_348666_));
        }
        this.drawString(p_348650_, p_348614_, p_348465_, p_348495_, p_348666_, true);
    }

    public void renderOutline(int p_281496_, int p_282076_, int p_281334_, int p_283576_, int p_283618_) {
        this.fill(p_281496_, p_282076_, p_281496_ + p_281334_, p_282076_ + 1, p_283618_);
        this.fill(p_281496_, p_282076_ + p_283576_ - 1, p_281496_ + p_281334_, p_282076_ + p_283576_, p_283618_);
        this.fill(p_281496_, p_282076_ + 1, p_281496_ + 1, p_282076_ + p_283576_ - 1, p_283618_);
        this.fill(p_281496_ + p_281334_ - 1, p_282076_ + 1, p_281496_ + p_281334_, p_282076_ + p_283576_ - 1, p_283618_);
    }

    public void blitSprite(RenderPipeline p_415703_, ResourceLocation p_294915_, int p_295058_, int p_294415_, int p_294535_, int p_295510_) {
        this.blitSprite(p_415703_, p_294915_, p_295058_, p_294415_, p_294535_, p_295510_, -1);
    }

    public void blitSprite(RenderPipeline p_421916_, ResourceLocation p_422348_, int p_422055_, int p_421599_, int p_422343_, int p_422460_, float p_422508_) {
        this.blitSprite(p_421916_, p_422348_, p_422055_, p_421599_, p_422343_, p_422460_, ARGB.color(p_422508_, -1));
    }

    public void blitSprite(RenderPipeline p_415593_, ResourceLocation p_365379_, int p_294695_, int p_296458_, int p_294279_, int p_295235_, int p_295034_) {
        TextureAtlasSprite textureatlassprite = this.sprites.getSprite(p_365379_);
        GuiSpriteScaling guispritescaling = this.sprites.getSpriteScaling(textureatlassprite);
        if (guispritescaling instanceof GuiSpriteScaling.Stretch) {
            this.blitSprite(p_415593_, textureatlassprite, p_294695_, p_296458_, p_294279_, p_295235_, p_295034_);
        } else if (guispritescaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile guispritescaling$tile = (GuiSpriteScaling.Tile)guispritescaling;
            this.blitTiledSprite(p_415593_, textureatlassprite, p_294695_, p_296458_, p_294279_, p_295235_, 0, 0, guispritescaling$tile.width(), guispritescaling$tile.height(), guispritescaling$tile.width(), guispritescaling$tile.height(), p_295034_);
        } else if (guispritescaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice guispritescaling$nineslice = (GuiSpriteScaling.NineSlice)guispritescaling;
            this.blitNineSlicedSprite(p_415593_, textureatlassprite, guispritescaling$nineslice, p_294695_, p_296458_, p_294279_, p_295235_, p_295034_);
        }
    }

    public void blitSprite(RenderPipeline p_416634_, ResourceLocation p_416011_, int p_294223_, int p_296245_, int p_296255_, int p_295669_, int p_415652_, int p_415759_, int p_416657_, int p_416244_) {
        this.blitSprite(p_416634_, p_416011_, p_294223_, p_296245_, p_296255_, p_295669_, p_415652_, p_415759_, p_416657_, p_416244_, -1);
    }

    public void blitSprite(RenderPipeline p_416106_, ResourceLocation p_294549_, int p_294560_, int p_295075_, int p_294098_, int p_295872_, int p_294414_, int p_362199_, int p_363608_, int p_365523_, int p_416361_) {
        TextureAtlasSprite textureatlassprite = this.sprites.getSprite(p_294549_);
        GuiSpriteScaling guispritescaling = this.sprites.getSpriteScaling(textureatlassprite);
        if (guispritescaling instanceof GuiSpriteScaling.Stretch) {
            this.blitSprite(p_416106_, textureatlassprite, p_294560_, p_295075_, p_294098_, p_295872_, p_294414_, p_362199_, p_363608_, p_365523_, p_416361_);
        } else {
            this.enableScissor(p_294414_, p_362199_, p_294414_ + p_363608_, p_362199_ + p_365523_);
            this.blitSprite(p_416106_, p_294549_, p_294414_ - p_294098_, p_362199_ - p_295872_, p_294560_, p_295075_, p_416361_);
            this.disableScissor();
        }
    }

    public void blitSprite(RenderPipeline p_416325_, TextureAtlasSprite p_416471_, int p_416622_, int p_416202_, int p_416408_, int p_416282_) {
        this.blitSprite(p_416325_, p_416471_, p_416622_, p_416202_, p_416408_, p_416282_, -1);
    }

    public void blitSprite(RenderPipeline p_416121_, TextureAtlasSprite p_364680_, int p_295194_, int p_295164_, int p_294823_, int p_295650_, int p_295401_) {
        if (p_294823_ != 0 && p_295650_ != 0) {
            this.innerBlit(p_416121_, p_364680_.atlasLocation(), p_295194_, p_295194_ + p_294823_, p_295164_, p_295164_ + p_295650_, p_364680_.getU0(), p_364680_.getU1(), p_364680_.getV0(), p_364680_.getV1(), p_295401_);
        }
    }

    private void blitSprite(RenderPipeline p_416146_, TextureAtlasSprite p_295122_, int p_295850_, int p_296348_, int p_295804_, int p_296465_, int p_295717_, int p_360779_, int p_363595_, int p_364585_, int p_361093_) {
        if (p_363595_ != 0 && p_364585_ != 0) {
            this.innerBlit(p_416146_, p_295122_.atlasLocation(), p_295717_, p_295717_ + p_363595_, p_360779_, p_360779_ + p_364585_, p_295122_.getU((float)p_295804_ / (float)p_295850_), p_295122_.getU((float)(p_295804_ + p_363595_) / (float)p_295850_), p_295122_.getV((float)p_296465_ / (float)p_296348_), p_295122_.getV((float)(p_296465_ + p_364585_) / (float)p_296348_), p_361093_);
        }
    }

    private void blitNineSlicedSprite(RenderPipeline p_415939_, TextureAtlasSprite p_294394_, GuiSpriteScaling.NineSlice p_295735_, int p_294769_, int p_294546_, int p_294421_, int p_295807_, int p_295009_) {
        GuiSpriteScaling.NineSlice.Border guispritescaling$nineslice$border = p_295735_.border();
        int i = Math.min(guispritescaling$nineslice$border.left(), p_294421_ / 2);
        int j = Math.min(guispritescaling$nineslice$border.right(), p_294421_ / 2);
        int k = Math.min(guispritescaling$nineslice$border.top(), p_295807_ / 2);
        int l = Math.min(guispritescaling$nineslice$border.bottom(), p_295807_ / 2);
        if (p_294421_ == p_295735_.width() && p_295807_ == p_295735_.height()) {
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, 0, p_294769_, p_294546_, p_294421_, p_295807_, p_295009_);
        } else if (p_295807_ == p_295735_.height()) {
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, 0, p_294769_, p_294546_, i, p_295807_, p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_ + i, p_294546_, p_294421_ - j - i, p_295807_, i, 0, p_295735_.width() - j - i, p_295735_.height(), p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), p_295735_.width() - j, 0, p_294769_ + p_294421_ - j, p_294546_, j, p_295807_, p_295009_);
        } else if (p_294421_ == p_295735_.width()) {
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, 0, p_294769_, p_294546_, p_294421_, k, p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_, p_294546_ + k, p_294421_, p_295807_ - l - k, 0, k, p_295735_.width(), p_295735_.height() - l - k, p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, p_295735_.height() - l, p_294769_, p_294546_ + p_295807_ - l, p_294421_, l, p_295009_);
        } else {
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, 0, p_294769_, p_294546_, i, k, p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_ + i, p_294546_, p_294421_ - j - i, k, i, 0, p_295735_.width() - j - i, k, p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), p_295735_.width() - j, 0, p_294769_ + p_294421_ - j, p_294546_, j, k, p_295009_);
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), 0, p_295735_.height() - l, p_294769_, p_294546_ + p_295807_ - l, i, l, p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_ + i, p_294546_ + p_295807_ - l, p_294421_ - j - i, l, i, p_295735_.height() - l, p_295735_.width() - j - i, l, p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitSprite(p_415939_, p_294394_, p_295735_.width(), p_295735_.height(), p_295735_.width() - j, p_295735_.height() - l, p_294769_ + p_294421_ - j, p_294546_ + p_295807_ - l, j, l, p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_, p_294546_ + k, i, p_295807_ - l - k, 0, k, i, p_295735_.height() - l - k, p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_ + i, p_294546_ + k, p_294421_ - j - i, p_295807_ - l - k, i, k, p_295735_.width() - j - i, p_295735_.height() - l - k, p_295735_.width(), p_295735_.height(), p_295009_);
            this.blitNineSliceInnerSegment(p_415939_, p_295735_, p_294394_, p_294769_ + p_294421_ - j, p_294546_ + k, j, p_295807_ - l - k, p_295735_.width() - j, k, j, p_295735_.height() - l - k, p_295735_.width(), p_295735_.height(), p_295009_);
        }
    }

    private void blitNineSliceInnerSegment(RenderPipeline p_415702_, GuiSpriteScaling.NineSlice p_371657_, TextureAtlasSprite p_371812_, int p_371894_, int p_371565_, int p_371606_, int p_371781_, int p_371379_, int p_371448_, int p_371442_, int p_371801_, int p_371588_, int p_371206_, int p_371311_) {
        if (p_371606_ > 0 && p_371781_ > 0) {
            if (p_371657_.stretchInner()) {
                this.innerBlit(p_415702_, p_371812_.atlasLocation(), p_371894_, p_371894_ + p_371606_, p_371565_, p_371565_ + p_371781_, p_371812_.getU((float)p_371379_ / (float)p_371588_), p_371812_.getU((float)(p_371379_ + p_371442_) / (float)p_371588_), p_371812_.getV((float)p_371448_ / (float)p_371206_), p_371812_.getV((float)(p_371448_ + p_371801_) / (float)p_371206_), p_371311_);
            } else {
                this.blitTiledSprite(p_415702_, p_371812_, p_371894_, p_371565_, p_371606_, p_371781_, p_371379_, p_371448_, p_371442_, p_371801_, p_371588_, p_371206_, p_371311_);
            }
        }
    }

    private void blitTiledSprite(RenderPipeline p_415914_, TextureAtlasSprite p_294349_, int p_295093_, int p_296434_, int p_295268_, int p_295203_, int p_296398_, int p_295542_, int p_296165_, int p_296256_, int p_294814_, int p_296352_, int p_296203_) {
        if (p_295268_ > 0 && p_295203_ > 0) {
            if (p_296165_ > 0 && p_296256_ > 0) {
                for (int i = 0; i < p_295268_; i += p_296165_) {
                    int j = Math.min(p_296165_, p_295268_ - i);
                    for (int k = 0; k < p_295203_; k += p_296256_) {
                        int l = Math.min(p_296256_, p_295203_ - k);
                        this.blitSprite(p_415914_, p_294349_, p_294814_, p_296352_, p_296398_, p_295542_, p_295093_ + i, p_296434_ + k, j, l, p_296203_);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + p_296165_ + "x" + p_296256_);
            }
        }
    }

    public void blit(RenderPipeline p_416258_, ResourceLocation p_283573_, int p_283574_, int p_283670_, float p_283029_, float p_283061_, int p_283545_, int p_282845_, int p_282558_, int p_282832_, int p_416564_) {
        this.blit(p_416258_, p_283573_, p_283574_, p_283670_, p_283029_, p_283061_, p_283545_, p_282845_, p_283545_, p_282845_, p_282558_, p_282832_, p_416564_);
    }

    public void blit(RenderPipeline p_416366_, ResourceLocation p_282639_, int p_282732_, int p_283541_, float p_282660_, float p_281522_, int p_281760_, int p_283298_, int p_283429_, int p_282193_) {
        this.blit(p_416366_, p_282639_, p_282732_, p_283541_, p_282660_, p_281522_, p_281760_, p_283298_, p_281760_, p_283298_, p_283429_, p_282193_);
    }

    public void blit(RenderPipeline p_416301_, ResourceLocation p_416627_, int p_416262_, int p_416224_, float p_415758_, float p_415576_, int p_416133_, int p_416212_, int p_416081_, int p_416306_, int p_416728_, int p_416477_) {
        this.blit(p_416301_, p_416627_, p_416262_, p_416224_, p_415758_, p_415576_, p_416133_, p_416212_, p_416081_, p_416306_, p_416728_, p_416477_, -1);
    }

    public void blit(RenderPipeline p_416403_, ResourceLocation p_363701_, int p_282225_, int p_281487_, float p_363958_, float p_363869_, int p_281985_, int p_281329_, int p_283035_, int p_363829_, int p_365041_, int p_361356_, int p_363808_) {
        this.innerBlit(p_416403_, p_363701_, p_282225_, p_282225_ + p_281985_, p_281487_, p_281487_ + p_281329_, (p_363958_ + 0.0f) / (float)p_365041_, (p_363958_ + (float)p_283035_) / (float)p_365041_, (p_363869_ + 0.0f) / (float)p_361356_, (p_363869_ + (float)p_363829_) / (float)p_361356_, p_363808_);
    }

    public void blit(ResourceLocation p_282034_, int p_283671_, int p_282377_, int p_282058_, int p_281939_, float p_282285_, float p_283199_, float p_415667_, float p_416411_) {
        this.innerBlit(RenderPipelines.GUI_TEXTURED, p_282034_, p_283671_, p_282058_, p_282377_, p_281939_, p_282285_, p_283199_, p_415667_, p_416411_, -1);
    }

    private void innerBlit(RenderPipeline p_415722_, ResourceLocation p_283254_, int p_283092_, int p_281930_, int p_282113_, int p_281388_, float p_281327_, float p_281676_, float p_283166_, float p_282630_, int p_283583_) {
        GpuTextureView gputextureview = this.minecraft.getTextureManager().getTexture(p_283254_).getTextureView();
        this.submitBlit(p_415722_, gputextureview, p_283092_, p_282113_, p_281930_, p_281388_, p_281327_, p_281676_, p_283166_, p_282630_, p_283583_);
    }

    private void submitBlit(RenderPipeline p_416205_, GpuTextureView p_423465_, int p_415899_, int p_415585_, int p_416253_, int p_416402_, float p_415781_, float p_415619_, float p_416198_, float p_415668_, int p_415686_) {
        this.guiRenderState.submitGuiElement(new BlitRenderState(p_416205_, TextureSetup.singleTexture(p_423465_), new Matrix3x2f((Matrix3x2fc)this.pose), p_415899_, p_415585_, p_416253_, p_416402_, p_415781_, p_415619_, p_416198_, p_415668_, p_415686_, this.scissorStack.peek()));
    }

    public void renderItem(ItemStack p_281978_, int p_282647_, int p_281944_) {
        this.renderItem(this.minecraft.player, this.minecraft.level, p_281978_, p_282647_, p_281944_, 0);
    }

    public void renderItem(ItemStack p_282262_, int p_283221_, int p_283496_, int p_283435_) {
        this.renderItem(this.minecraft.player, this.minecraft.level, p_282262_, p_283221_, p_283496_, p_283435_);
    }

    public void renderFakeItem(ItemStack p_281946_, int p_283299_, int p_283674_) {
        this.renderFakeItem(p_281946_, p_283299_, p_283674_, 0);
    }

    public void renderFakeItem(ItemStack p_312904_, int p_312257_, int p_312674_, int p_312138_) {
        this.renderItem(null, this.minecraft.level, p_312904_, p_312257_, p_312674_, p_312138_);
    }

    public void renderItem(LivingEntity p_282154_, ItemStack p_282777_, int p_282110_, int p_281371_, int p_283572_) {
        this.renderItem(p_282154_, p_282154_.level(), p_282777_, p_282110_, p_281371_, p_283572_);
    }

    private void renderItem(@Nullable LivingEntity p_283524_, @Nullable Level p_282461_, ItemStack p_283653_, int p_283141_, int p_282560_, int p_282425_) {
        if (!p_283653_.isEmpty()) {
            TrackingItemStackRenderState trackingitemstackrenderstate = new TrackingItemStackRenderState();
            this.minecraft.getItemModelResolver().updateForTopItem(trackingitemstackrenderstate, p_283653_, ItemDisplayContext.GUI, p_282461_, p_283524_, p_282425_);
            try {
                this.guiRenderState.submitItem(new GuiItemRenderState(p_283653_.getItem().getName().toString(), new Matrix3x2f((Matrix3x2fc)this.pose), trackingitemstackrenderstate, p_283141_, p_282560_, this.scissorStack.peek()));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(p_283653_.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(p_283653_.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(p_283653_.hasFoil()));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void renderItemDecorations(Font p_281721_, ItemStack p_281514_, int p_282056_, int p_282683_) {
        this.renderItemDecorations(p_281721_, p_281514_, p_282056_, p_282683_, null);
    }

    public void renderItemDecorations(Font p_282005_, ItemStack p_283349_, int p_282641_, int p_282146_, @Nullable String p_282803_) {
        if (!p_283349_.isEmpty()) {
            this.pose.pushMatrix();
            this.renderItemBar(p_283349_, p_282641_, p_282146_);
            this.renderItemCooldown(p_283349_, p_282641_, p_282146_);
            this.renderItemCount(p_282005_, p_283349_, p_282641_, p_282146_, p_282803_);
            this.pose.popMatrix();
            ItemDecoratorHandler.of((ItemStack)p_283349_).render(this, p_282005_, p_283349_, p_282641_, p_282146_);
        }
    }

    public void setTooltipForNextFrame(Component p_419574_, int p_419861_, int p_419548_) {
        this.setTooltipForNextFrame(List.of(p_419574_.getVisualOrderText()), p_419861_, p_419548_);
    }

    public void setTooltipForNextFrame(List<FormattedCharSequence> p_419480_, int p_419761_, int p_420077_) {
        this.setTooltipForNextFrame(this.minecraft.font, p_419480_, DefaultTooltipPositioner.INSTANCE, p_419761_, p_420077_, false);
    }

    public void setTooltipForNextFrame(Font p_419878_, ItemStack p_419655_, int p_419935_, int p_419559_) {
        this.tooltipStack = p_419655_;
        this.setTooltipForNextFrame(p_419878_, Screen.getTooltipFromItem(this.minecraft, p_419655_), p_419655_.getTooltipImage(), p_419935_, p_419559_, p_419655_.get(DataComponents.TOOLTIP_STYLE));
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void setTooltipForNextFrame(Font font, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, ItemStack stack, int mouseX, int mouseY) {
        this.setTooltipForNextFrame(font, textComponents, tooltipComponent, stack, mouseX, mouseY, null);
    }

    public void setTooltipForNextFrame(Font font, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, ItemStack stack, int mouseX, int mouseY, @Nullable ResourceLocation backgroundTexture) {
        this.tooltipStack = stack;
        this.setTooltipForNextFrame(font, textComponents, tooltipComponent, mouseX, mouseY, backgroundTexture);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void setTooltipForNextFrame(Font p_419603_, List<Component> p_419948_, Optional<TooltipComponent> p_419787_, int p_419566_, int p_420005_) {
        this.setTooltipForNextFrame(p_419603_, p_419948_, p_419787_, p_419566_, p_420005_, null);
    }

    public void setTooltipForNextFrame(Font p_420034_, List<Component> p_419494_, Optional<TooltipComponent> p_419637_, int p_419571_, int p_419535_, @Nullable ResourceLocation p_419579_) {
        List list = ClientHooks.gatherTooltipComponents((ItemStack)this.tooltipStack, p_419494_, p_419637_, (int)p_419571_, (int)this.guiWidth(), (int)this.guiHeight(), (Font)p_420034_);
        this.setTooltipForNextFrameInternal(p_420034_, list, p_419571_, p_419535_, DefaultTooltipPositioner.INSTANCE, p_419579_, false);
    }

    public void setTooltipForNextFrame(Font p_420070_, Component p_419840_, int p_419594_, int p_419902_) {
        this.setTooltipForNextFrame(p_420070_, p_419840_, p_419594_, p_419902_, null);
    }

    public void setTooltipForNextFrame(Font p_420056_, Component p_419744_, int p_420073_, int p_419473_, @Nullable ResourceLocation p_419848_) {
        this.setTooltipForNextFrame(p_420056_, List.of(p_419744_.getVisualOrderText()), p_420073_, p_419473_, p_419848_);
    }

    public void setComponentTooltipForNextFrame(Font p_419927_, List<Component> p_419807_, int p_419887_, int p_420035_) {
        this.setComponentTooltipForNextFrame(p_419927_, p_419807_, p_419887_, p_420035_, (ResourceLocation)null);
    }

    public void setComponentTooltipForNextFrame(Font p_419540_, List<Component> p_419714_, int p_419554_, int p_419672_, @Nullable ResourceLocation p_419660_) {
        List components = ClientHooks.gatherTooltipComponents((ItemStack)this.tooltipStack, p_419714_, (int)p_419554_, (int)this.guiWidth(), (int)this.guiHeight(), (Font)p_419540_);
        this.setTooltipForNextFrameInternal(p_419540_, components, p_419554_, p_419672_, DefaultTooltipPositioner.INSTANCE, p_419660_, false);
    }

    public void setComponentTooltipForNextFrame(Font font, List<? extends FormattedText> tooltips, int mouseX, int mouseY, ItemStack stack) {
        this.setComponentTooltipForNextFrame(font, tooltips, mouseX, mouseY, stack, null);
    }

    public void setComponentTooltipForNextFrame(Font font, List<? extends FormattedText> tooltips, int mouseX, int mouseY, ItemStack stack, @Nullable ResourceLocation backgroundTexture) {
        this.tooltipStack = stack;
        List components = ClientHooks.gatherTooltipComponents((ItemStack)stack, tooltips, (int)mouseX, (int)this.guiWidth(), (int)this.guiHeight(), (Font)font);
        this.setTooltipForNextFrameInternal(font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, backgroundTexture, false);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void setComponentTooltipFromElementsForNextFrame(Font font, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int mouseY, ItemStack stack) {
        this.setComponentTooltipFromElementsForNextFrame(font, elements, mouseX, mouseY, stack, null);
    }

    public void setComponentTooltipFromElementsForNextFrame(Font font, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int mouseY, ItemStack stack, @Nullable ResourceLocation backgroundTexture) {
        this.tooltipStack = stack;
        List components = ClientHooks.gatherTooltipComponentsFromElements((ItemStack)stack, elements, (int)mouseX, (int)this.guiWidth(), (int)this.guiHeight(), (Font)font);
        this.setTooltipForNextFrameInternal(font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, backgroundTexture, false);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void setTooltipForNextFrame(Font p_419718_, List<? extends FormattedCharSequence> p_419502_, int p_419583_, int p_419996_) {
        this.setTooltipForNextFrame(p_419718_, p_419502_, p_419583_, p_419996_, null);
    }

    public void setTooltipForNextFrame(Font p_419582_, List<? extends FormattedCharSequence> p_419728_, int p_419586_, int p_420052_, @Nullable ResourceLocation p_419654_) {
        this.setTooltipForNextFrameInternal(p_419582_, p_419728_.stream().map(ClientTooltipComponent::create).collect(Collectors.toList()), p_419586_, p_420052_, DefaultTooltipPositioner.INSTANCE, p_419654_, false);
    }

    public void setTooltipForNextFrame(Font p_419832_, List<FormattedCharSequence> p_419662_, ClientTooltipPositioner p_419693_, int p_420011_, int p_420014_, boolean p_419517_) {
        this.setTooltipForNextFrameInternal(p_419832_, p_419662_.stream().map(ClientTooltipComponent::create).collect(Collectors.toList()), p_420011_, p_420014_, p_419693_, null, p_419517_);
    }

    private void setTooltipForNextFrameInternal(Font p_419941_, List<ClientTooltipComponent> p_419687_, int p_419453_, int p_419611_, ClientTooltipPositioner p_419886_, @Nullable ResourceLocation p_419692_, boolean p_419788_) {
        if (!p_419687_.isEmpty() && (this.deferredTooltip == null || p_419788_)) {
            ItemStack capturedTooltipStack = this.tooltipStack;
            this.deferredTooltip = () -> this.renderTooltip(p_419941_, p_419687_, p_419453_, p_419611_, p_419886_, p_419692_, capturedTooltipStack);
        }
    }

    public void renderTooltip(Font p_371715_, List<ClientTooltipComponent> p_371741_, int p_371500_, int p_371755_, ClientTooltipPositioner p_419610_, @Nullable ResourceLocation p_371766_) {
        this.renderTooltip(p_371715_, p_371741_, p_371500_, p_371755_, p_419610_, p_371766_, ItemStack.EMPTY);
    }

    public void renderTooltip(Font p_371715_, List<ClientTooltipComponent> p_371741_, int p_371500_, int p_371755_, ClientTooltipPositioner p_419610_, @Nullable ResourceLocation p_371766_, ItemStack tooltipStack) {
        RenderTooltipEvent.Pre preEvent = ClientHooks.onRenderTooltipPre((ItemStack)tooltipStack, (GuiGraphics)this, (int)p_371500_, (int)p_371755_, (int)this.guiWidth(), (int)this.guiHeight(), p_371741_, (Font)p_371715_, (ClientTooltipPositioner)p_419610_);
        if (preEvent.isCanceled()) {
            return;
        }
        p_371715_ = preEvent.getFont();
        p_371500_ = preEvent.getX();
        p_371755_ = preEvent.getY();
        int i = 0;
        int j = p_371741_.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clienttooltipcomponent : p_371741_) {
            int k = clienttooltipcomponent.getWidth(p_371715_);
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.getHeight(p_371715_);
        }
        int l1 = i;
        int i2 = j;
        Vector2ic vector2ic = p_419610_.positionTooltip(this.guiWidth(), this.guiHeight(), p_371500_, p_371755_, i, j);
        int l = vector2ic.x();
        int i1 = vector2ic.y();
        this.pose.pushMatrix();
        RenderTooltipEvent.Texture textureEvent = ClientHooks.onRenderTooltipTexture((ItemStack)this.tooltipStack, (GuiGraphics)this, (int)l, (int)i1, (Font)preEvent.getFont(), p_371741_, (ResourceLocation)p_371766_);
        TooltipRenderUtil.renderTooltipBackground(this, l, i1, i, j, textureEvent.getTexture());
        int j1 = i1;
        for (int k1 = 0; k1 < p_371741_.size(); ++k1) {
            ClientTooltipComponent clienttooltipcomponent1 = p_371741_.get(k1);
            clienttooltipcomponent1.renderText(this, p_371715_, l, j1);
            j1 += clienttooltipcomponent1.getHeight(p_371715_) + (k1 == 0 ? 2 : 0);
        }
        j1 = i1;
        for (int j2 = 0; j2 < p_371741_.size(); ++j2) {
            ClientTooltipComponent clienttooltipcomponent2 = p_371741_.get(j2);
            clienttooltipcomponent2.renderImage(p_371715_, l, j1, l1, i2, this);
            j1 += clienttooltipcomponent2.getHeight(p_371715_) + (j2 == 0 ? 2 : 0);
        }
        this.pose.popMatrix();
    }

    public void renderDeferredTooltip() {
        if (this.deferredTooltip != null) {
            this.nextStratum();
            this.deferredTooltip.run();
            this.deferredTooltip = null;
        }
    }

    private void renderItemBar(ItemStack p_380278_, int p_379972_, int p_379916_) {
        if (p_380278_.isBarVisible()) {
            int i = p_379972_ + 2;
            int j = p_379916_ + 13;
            this.fill(RenderPipelines.GUI, i, j, i + 13, j + 2, -16777216);
            this.fill(RenderPipelines.GUI, i, j, i + p_380278_.getBarWidth(), j + 1, ARGB.opaque(p_380278_.getBarColor()));
        }
    }

    private void renderItemCount(Font p_380115_, ItemStack p_379291_, int p_379544_, int p_380291_, @Nullable String p_380189_) {
        if (p_379291_.getCount() != 1 || p_380189_ != null) {
            String s = p_380189_ == null ? String.valueOf(p_379291_.getCount()) : p_380189_;
            this.drawString(p_380115_, s, p_379544_ + 19 - 2 - p_380115_.width(s), p_380291_ + 6 + 3, -1, true);
        }
    }

    private void renderItemCooldown(ItemStack p_380199_, int p_380397_, int p_379741_) {
        float f;
        LocalPlayer localplayer = this.minecraft.player;
        float f2 = f = localplayer == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(p_380199_, this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true));
        if (f > 0.0f) {
            int i = p_379741_ + Mth.floor(16.0f * (1.0f - f));
            int j = i + Mth.ceil(16.0f * f);
            this.fill(RenderPipelines.GUI, p_380397_, i, p_380397_ + 16, j, Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderComponentHoverEffect(Font p_282584_, @Nullable Style p_282156_, int p_283623_, int p_282114_) {
        if (p_282156_ == null) return;
        if (p_282156_.getHoverEvent() == null) return;
        HoverEvent hoverEvent = p_282156_.getHoverEvent();
        Objects.requireNonNull(hoverEvent);
        HoverEvent hoverEvent2 = hoverEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HoverEvent.ShowItem.class, HoverEvent.ShowEntity.class, HoverEvent.ShowText.class}, (Object)hoverEvent2, n)) {
            case 0: {
                HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)hoverEvent2;
                try {
                    ItemStack itemStack;
                    ItemStack itemstack = itemStack = showItem.item();
                    this.setTooltipForNextFrame(p_282584_, itemstack, p_283623_, p_282114_);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent2;
                {
                    HoverEvent.EntityTooltipInfo entityTooltipInfo;
                    HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo1;
                    HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = hoverevent$entitytooltipinfo1 = (entityTooltipInfo = showEntity.entity());
                    if (!this.minecraft.options.advancedItemTooltips) return;
                    this.setComponentTooltipForNextFrame(p_282584_, hoverevent$entitytooltipinfo.getTooltipLines(), p_283623_, p_282114_);
                    return;
                }
            }
            case 2: {
                HoverEvent.ShowText showText = (HoverEvent.ShowText)hoverEvent2;
                {
                    Component component;
                    Component component2 = component = showText.value();
                    this.setTooltipForNextFrame(p_282584_, p_282584_.split(component2, Math.max(this.guiWidth() / 2, 200)), p_283623_, p_282114_);
                    return;
                }
            }
        }
    }

    public void submitMapRenderState(MapRenderState p_415810_) {
        Minecraft minecraft = Minecraft.getInstance();
        TextureManager texturemanager = minecraft.getTextureManager();
        GpuTextureView gputextureview = texturemanager.getTexture(p_415810_.texture).getTextureView();
        this.submitBlit(RenderPipelines.GUI_TEXTURED, gputextureview, 0, 0, 128, 128, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        for (MapRenderState.MapDecorationRenderState maprenderstate$mapdecorationrenderstate : p_415810_.decorations) {
            if (!maprenderstate$mapdecorationrenderstate.renderOnFrame) continue;
            this.pose.pushMatrix();
            this.pose.translate((float)maprenderstate$mapdecorationrenderstate.x / 2.0f + 64.0f, (float)maprenderstate$mapdecorationrenderstate.y / 2.0f + 64.0f);
            this.pose.rotate((float)Math.PI / 180 * (float)maprenderstate$mapdecorationrenderstate.rot * 360.0f / 16.0f);
            this.pose.scale(4.0f, 4.0f);
            this.pose.translate(-0.125f, 0.125f);
            TextureAtlasSprite textureatlassprite = maprenderstate$mapdecorationrenderstate.atlasSprite;
            if (textureatlassprite != null) {
                GpuTextureView gputextureview1 = texturemanager.getTexture(textureatlassprite.atlasLocation()).getTextureView();
                this.submitBlit(RenderPipelines.GUI_TEXTURED, gputextureview1, -1, -1, 1, 1, textureatlassprite.getU0(), textureatlassprite.getU1(), textureatlassprite.getV1(), textureatlassprite.getV0(), -1);
            }
            this.pose.popMatrix();
            if (maprenderstate$mapdecorationrenderstate.name == null) continue;
            Font font = minecraft.font;
            float f = font.width(maprenderstate$mapdecorationrenderstate.name);
            float f1 = Mth.clamp(25.0f / f, 0.0f, 0.6666667f);
            this.pose.pushMatrix();
            this.pose.translate((float)maprenderstate$mapdecorationrenderstate.x / 2.0f + 64.0f - f * f1 / 2.0f, (float)maprenderstate$mapdecorationrenderstate.y / 2.0f + 64.0f + 4.0f);
            this.pose.scale(f1, f1);
            this.guiRenderState.submitText(new GuiTextRenderState(font, maprenderstate$mapdecorationrenderstate.name.getVisualOrderText(), new Matrix3x2f((Matrix3x2fc)this.pose), 0, 0, -1, Integer.MIN_VALUE, false, this.scissorStack.peek()));
            this.pose.popMatrix();
        }
    }

    public void submitEntityRenderState(EntityRenderState p_415907_, float p_415695_, Vector3f p_415772_, Quaternionf p_416089_, @Nullable Quaternionf p_416355_, int p_416675_, int p_416412_, int p_415766_, int p_416432_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiEntityRenderState(p_415907_, p_415772_, p_416089_, p_416355_, p_416675_, p_416412_, p_415766_, p_416432_, p_415695_, this.scissorStack.peek()));
    }

    public void submitSkinRenderState(PlayerModel p_416647_, ResourceLocation p_416075_, float p_416346_, float p_416524_, float p_416465_, float p_416434_, int p_416207_, int p_415726_, int p_415642_, int p_416359_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiSkinRenderState(p_416647_, p_416075_, p_416524_, p_416465_, p_416434_, p_416207_, p_415726_, p_415642_, p_416359_, p_416346_, this.scissorStack.peek()));
    }

    public void submitBookModelRenderState(BookModel p_415829_, ResourceLocation p_415660_, float p_416200_, float p_415771_, float p_416342_, int p_416018_, int p_416230_, int p_416557_, int p_416220_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiBookModelRenderState(p_415829_, p_415660_, p_415771_, p_416342_, p_416018_, p_416230_, p_416557_, p_416220_, p_416200_, this.scissorStack.peek()));
    }

    public void submitBannerPatternRenderState(ModelPart p_416516_, DyeColor p_415755_, BannerPatternLayers p_415569_, int p_415681_, int p_416288_, int p_416302_, int p_415867_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiBannerResultRenderState(p_416516_, p_415755_, p_415569_, p_415681_, p_416288_, p_416302_, p_415867_, this.scissorStack.peek()));
    }

    public void submitSignRenderState(Model p_415997_, float p_416226_, WoodType p_416002_, int p_415719_, int p_416488_, int p_416444_, int p_416195_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiSignRenderState(p_415997_, p_416002_, p_415719_, p_416488_, p_416444_, p_416195_, p_416226_, this.scissorStack.peek()));
    }

    public void submitProfilerChartRenderState(List<ResultField> p_415873_, int p_415651_, int p_416392_, int p_415782_, int p_416254_) {
        this.guiRenderState.submitPicturesInPictureState(new GuiProfilerChartRenderState(p_415873_, p_415651_, p_416392_, p_415782_, p_416254_, this.scissorStack.peek()));
    }

    public void submitGuiElementRenderState(GuiElementRenderState renderState) {
        this.guiRenderState.submitGuiElement(renderState);
    }

    public void submitPictureInPictureRenderState(PictureInPictureRenderState renderState) {
        this.guiRenderState.submitPicturesInPictureState(renderState);
    }

    @Nullable
    public ScreenRectangle peekScissorStack() {
        return this.scissorStack.peek();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ScissorStack {
        private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

        ScissorStack() {
        }

        public ScreenRectangle push(ScreenRectangle p_281812_) {
            ScreenRectangle screenrectangle = this.stack.peekLast();
            if (screenrectangle != null) {
                ScreenRectangle screenrectangle1 = Objects.requireNonNullElse(p_281812_.intersection(screenrectangle), ScreenRectangle.empty());
                this.stack.addLast(screenrectangle1);
                return screenrectangle1;
            }
            this.stack.addLast(p_281812_);
            return p_281812_;
        }

        @Nullable
        public ScreenRectangle pop() {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Scissor stack underflow");
            }
            this.stack.removeLast();
            return this.stack.peekLast();
        }

        @Nullable
        public ScreenRectangle peek() {
            return this.stack.peekLast();
        }

        public boolean containsPoint(int p_332682_, int p_332655_) {
            return this.stack.isEmpty() ? true : this.stack.peek().containsPoint(p_332682_, p_332655_);
        }
    }
}

