/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringDecomposer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.IFontExtension;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class Font
implements IFontExtension {
    private static final float EFFECT_DEPTH = 0.01f;
    private static final float OVER_EFFECT_DEPTH = 0.01f;
    private static final float UNDER_EFFECT_DEPTH = -0.01f;
    public static final float SHADOW_DEPTH = 0.03f;
    public static final int NO_SHADOW = 0;
    public final int lineHeight = 9;
    public final RandomSource random = RandomSource.create();
    private final Function<ResourceLocation, FontSet> fonts;
    final boolean filterFishyGlyphs;
    private final StringSplitter splitter;
    public boolean enableTextTextureLinearFiltering = false;

    public Font(Function<ResourceLocation, FontSet> p_243253_, boolean p_243245_) {
        this.fonts = p_243253_;
        this.filterFishyGlyphs = p_243245_;
        this.splitter = new StringSplitter((p_92722_, p_92723_) -> this.getFontSet(p_92723_.getFont()).getGlyphInfo(p_92722_, this.filterFishyGlyphs).getAdvance(p_92723_.isBold()));
    }

    FontSet getFontSet(ResourceLocation p_92864_) {
        return this.fonts.apply(p_92864_);
    }

    public String bidirectionalShaping(String p_92802_) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(p_92802_), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicshapingexception) {
            return p_92802_;
        }
    }

    public void drawInBatch(String p_416062_, float p_273006_, float p_273254_, int p_273375_, boolean p_273674_, Matrix4f p_273525_, MultiBufferSource p_272624_, DisplayMode p_273418_, int p_273330_, int p_272981_) {
        PreparedText font$preparedtext = this.prepareText(p_416062_, p_273006_, p_273254_, p_273375_, p_273674_, p_273330_);
        font$preparedtext.visit(GlyphVisitor.forMultiBufferSource(p_272624_, p_273525_, p_273418_, p_272981_));
    }

    public void drawInBatch(Component p_273032_, float p_273249_, float p_273594_, int p_273714_, boolean p_273050_, Matrix4f p_272974_, MultiBufferSource p_273695_, DisplayMode p_272782_, int p_272603_, int p_273632_) {
        PreparedText font$preparedtext = this.prepareText(p_273032_.getVisualOrderText(), p_273249_, p_273594_, p_273714_, p_273050_, p_272603_);
        font$preparedtext.visit(GlyphVisitor.forMultiBufferSource(p_273695_, p_272974_, p_272782_, p_273632_));
    }

    public void drawInBatch(FormattedCharSequence p_416545_, float p_272811_, float p_272610_, int p_273422_, boolean p_273016_, Matrix4f p_273443_, MultiBufferSource p_273387_, DisplayMode p_273551_, int p_272706_, int p_273114_) {
        PreparedText font$preparedtext = this.prepareText(p_416545_, p_272811_, p_272610_, p_273422_, p_273016_, p_272706_);
        font$preparedtext.visit(GlyphVisitor.forMultiBufferSource(p_273387_, p_273443_, p_273551_, p_273114_));
    }

    public void drawInBatch8xOutline(FormattedCharSequence p_168646_, float p_168647_, float p_168648_, int p_168649_, int p_168650_, Matrix4f p_254170_, MultiBufferSource p_168652_, int p_168653_) {
        PreparedTextBuilder font$preparedtextbuilder = new PreparedTextBuilder(0.0f, 0.0f, p_168650_, false);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                float[] afloat = new float[]{p_168647_};
                int k = i;
                int l = j;
                p_168646_.accept((p_168661_, p_168662_, p_168663_) -> {
                    boolean flag = p_168662_.isBold();
                    FontSet fontset = this.getFontSet(p_168662_.getFont());
                    GlyphInfo glyphinfo = fontset.getGlyphInfo(p_168663_, this.filterFishyGlyphs);
                    font$preparedtextbuilder.x = afloat[0] + (float)k * glyphinfo.getShadowOffset();
                    font$preparedtextbuilder.y = p_168648_ + (float)l * glyphinfo.getShadowOffset();
                    afloat[0] = afloat[0] + glyphinfo.getAdvance(flag);
                    return font$preparedtextbuilder.accept(p_168661_, p_168662_.withColor(p_168650_), p_168663_);
                });
            }
        }
        GlyphVisitor font$glyphvisitor = GlyphVisitor.forMultiBufferSource(p_168652_, p_254170_, DisplayMode.NORMAL, p_168653_);
        for (BakedGlyph.GlyphInstance bakedglyph$glyphinstance : font$preparedtextbuilder.glyphs) {
            font$glyphvisitor.acceptGlyph(bakedglyph$glyphinstance);
        }
        PreparedTextBuilder font$preparedtextbuilder1 = new PreparedTextBuilder(p_168647_, p_168648_, p_168649_, false);
        p_168646_.accept(font$preparedtextbuilder1);
        font$preparedtextbuilder1.visit(GlyphVisitor.forMultiBufferSource(p_168652_, p_254170_, DisplayMode.POLYGON_OFFSET, p_168653_));
    }

    public PreparedText prepareText(String p_425644_, float p_425748_, float p_425936_, int p_425702_, boolean p_426031_, int p_425535_) {
        if (this.isBidirectional()) {
            p_425644_ = this.bidirectionalShaping(p_425644_);
        }
        PreparedTextBuilder font$preparedtextbuilder = new PreparedTextBuilder(p_425748_, p_425936_, p_425702_, p_425535_, p_426031_);
        StringDecomposer.iterateFormatted(p_425644_, Style.EMPTY, (FormattedCharSink)font$preparedtextbuilder);
        return font$preparedtextbuilder;
    }

    public PreparedText prepareText(FormattedCharSequence p_426161_, float p_425846_, float p_425990_, int p_425723_, boolean p_425650_, int p_425946_) {
        PreparedTextBuilder font$preparedtextbuilder = new PreparedTextBuilder(p_425846_, p_425990_, p_425723_, p_425946_, p_425650_);
        p_426161_.accept(font$preparedtextbuilder);
        return font$preparedtextbuilder;
    }

    public int width(String p_92896_) {
        return Mth.ceil(this.splitter.stringWidth(p_92896_));
    }

    public int width(FormattedText p_92853_) {
        return Mth.ceil(this.splitter.stringWidth(p_92853_));
    }

    public int width(FormattedCharSequence p_92725_) {
        return Mth.ceil(this.splitter.stringWidth(p_92725_));
    }

    public String plainSubstrByWidth(String p_92838_, int p_92839_, boolean p_92840_) {
        return p_92840_ ? this.splitter.plainTailByWidth(p_92838_, p_92839_, Style.EMPTY) : this.splitter.plainHeadByWidth(p_92838_, p_92839_, Style.EMPTY);
    }

    public String plainSubstrByWidth(String p_92835_, int p_92836_) {
        return this.splitter.plainHeadByWidth(p_92835_, p_92836_, Style.EMPTY);
    }

    public FormattedText substrByWidth(FormattedText p_92855_, int p_92856_) {
        return this.splitter.headByWidth(p_92855_, p_92856_, Style.EMPTY);
    }

    public int wordWrapHeight(String p_92921_, int p_92922_) {
        return 9 * this.splitter.splitLines(p_92921_, p_92922_, Style.EMPTY).size();
    }

    public int wordWrapHeight(FormattedText p_239134_, int p_239135_) {
        return 9 * this.splitter.splitLines(p_239134_, p_239135_, Style.EMPTY).size();
    }

    public List<FormattedCharSequence> split(FormattedText p_92924_, int p_92925_) {
        return Language.getInstance().getVisualOrder(this.splitter.splitLines(p_92924_, p_92925_, Style.EMPTY));
    }

    public List<FormattedText> splitIgnoringLanguage(FormattedText p_428422_, int p_428207_) {
        return this.splitter.splitLines(p_428422_, p_428207_, Style.EMPTY);
    }

    public boolean isBidirectional() {
        return Language.getInstance().isDefaultRightToLeft();
    }

    public StringSplitter getSplitter() {
        return this.splitter;
    }

    public Font self() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface PreparedText {
        public void visit(GlyphVisitor var1);

        @Nullable
        public ScreenRectangle bounds();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface GlyphVisitor {
        public static GlyphVisitor forMultiBufferSource(final MultiBufferSource p_426098_, final Matrix4f p_425574_, final DisplayMode p_425933_, final int p_426219_) {
            return new GlyphVisitor(){

                @Override
                public void acceptGlyph(BakedGlyph.GlyphInstance p_425885_) {
                    BakedGlyph bakedglyph = p_425885_.glyph();
                    VertexConsumer vertexconsumer = p_426098_.getBuffer(bakedglyph.renderType(p_425933_));
                    bakedglyph.renderChar(p_425885_, p_425574_, vertexconsumer, p_426219_, false);
                }

                @Override
                public void acceptEffect(BakedGlyph p_425860_, BakedGlyph.Effect p_425865_) {
                    VertexConsumer vertexconsumer = p_426098_.getBuffer(p_425860_.renderType(p_425933_));
                    p_425860_.renderEffect(p_425865_, p_425574_, vertexconsumer, p_426219_, false);
                }
            };
        }

        public void acceptGlyph(BakedGlyph.GlyphInstance var1);

        public void acceptEffect(BakedGlyph var1, BakedGlyph.Effect var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum DisplayMode {
        NORMAL,
        SEE_THROUGH,
        POLYGON_OFFSET;

    }

    @OnlyIn(value=Dist.CLIENT)
    class PreparedTextBuilder
    implements FormattedCharSink,
    PreparedText {
        private final boolean drawShadow;
        private final int color;
        private final int backgroundColor;
        float x;
        float y;
        private float left = Float.MAX_VALUE;
        private float top = Float.MAX_VALUE;
        private float right = -3.4028235E38f;
        private float bottom = -3.4028235E38f;
        private float backgroundLeft = Float.MAX_VALUE;
        private float backgroundTop = Float.MAX_VALUE;
        private float backgroundRight = -3.4028235E38f;
        private float backgroundBottom = -3.4028235E38f;
        final List<BakedGlyph.GlyphInstance> glyphs = new ArrayList<BakedGlyph.GlyphInstance>();
        @Nullable
        private List<BakedGlyph.Effect> effects;

        public PreparedTextBuilder(float p_426009_, float p_426190_, int p_425840_, boolean p_425870_) {
            this(p_426009_, p_426190_, p_425840_, 0, p_425870_);
        }

        public PreparedTextBuilder(float p_426112_, float p_425714_, int p_425822_, int p_425735_, boolean p_425883_) {
            this.x = p_426112_;
            this.y = p_425714_;
            this.drawShadow = p_425883_;
            this.color = p_425822_;
            this.backgroundColor = p_425735_;
            this.markBackground(p_426112_, p_425714_, 0.0f);
        }

        private void markSize(float p_426144_, float p_425569_, float p_425910_, float p_425784_) {
            this.left = Math.min(this.left, p_426144_);
            this.top = Math.min(this.top, p_425569_);
            this.right = Math.max(this.right, p_425910_);
            this.bottom = Math.max(this.bottom, p_425784_);
        }

        private void markBackground(float p_425950_, float p_425897_, float p_425529_) {
            if (ARGB.alpha(this.backgroundColor) != 0) {
                this.backgroundLeft = Math.min(this.backgroundLeft, p_425950_ - 1.0f);
                this.backgroundTop = Math.min(this.backgroundTop, p_425897_ - 1.0f);
                this.backgroundRight = Math.max(this.backgroundRight, p_425950_ + p_425529_);
                this.backgroundBottom = Math.max(this.backgroundBottom, p_425897_ + 9.0f);
                this.markSize(this.backgroundLeft, this.backgroundTop, this.backgroundRight, this.backgroundBottom);
            }
        }

        private void addGlyph(BakedGlyph.GlyphInstance p_425798_) {
            this.glyphs.add(p_425798_);
            this.markSize(p_425798_.left(), p_425798_.top(), p_425798_.right(), p_425798_.bottom());
        }

        private void addEffect(BakedGlyph.Effect p_425881_) {
            if (this.effects == null) {
                this.effects = new ArrayList<BakedGlyph.Effect>();
            }
            this.effects.add(p_425881_);
            this.markSize(p_425881_.left(), p_425881_.top(), p_425881_.right(), p_425881_.bottom());
        }

        @Override
        public boolean accept(int p_425893_, Style p_426323_, int p_426324_) {
            FontSet fontset = Font.this.getFontSet(p_426323_.getFont());
            GlyphInfo glyphinfo = fontset.getGlyphInfo(p_426324_, Font.this.filterFishyGlyphs);
            BakedGlyph bakedglyph = p_426323_.isObfuscated() && p_426324_ != 32 ? fontset.getRandomGlyph(glyphinfo) : fontset.getGlyph(p_426324_);
            boolean flag = p_426323_.isBold();
            TextColor textcolor = p_426323_.getColor();
            int i = this.getTextColor(textcolor);
            int j = this.getShadowColor(p_426323_, i);
            float f = glyphinfo.getAdvance(flag);
            float f1 = p_425893_ == 0 ? this.x - 1.0f : this.x;
            float f2 = glyphinfo.getShadowOffset();
            if (!(bakedglyph instanceof EmptyGlyph)) {
                float f3 = flag ? glyphinfo.getBoldOffset() : 0.0f;
                this.addGlyph(new BakedGlyph.GlyphInstance(this.x, this.y, i, j, bakedglyph, p_426323_, f3, f2));
            }
            this.markBackground(this.x, this.y, f);
            if (p_426323_.isStrikethrough()) {
                this.addEffect(new BakedGlyph.Effect(f1, this.y + 4.5f - 1.0f, this.x + f, this.y + 4.5f, 0.01f, i, j, f2));
            }
            if (p_426323_.isUnderlined()) {
                this.addEffect(new BakedGlyph.Effect(f1, this.y + 9.0f - 1.0f, this.x + f, this.y + 9.0f, 0.01f, i, j, f2));
            }
            this.x += f;
            return true;
        }

        @Override
        public void visit(GlyphVisitor p_425967_) {
            BakedGlyph bakedglyph = null;
            if (ARGB.alpha(this.backgroundColor) != 0) {
                BakedGlyph.Effect bakedglyph$effect = new BakedGlyph.Effect(this.backgroundLeft, this.backgroundTop, this.backgroundRight, this.backgroundBottom, -0.01f, this.backgroundColor);
                bakedglyph = Font.this.getFontSet(Style.DEFAULT_FONT).whiteGlyph();
                p_425967_.acceptEffect(bakedglyph, bakedglyph$effect);
            }
            for (BakedGlyph.GlyphInstance bakedglyph$glyphinstance : this.glyphs) {
                p_425967_.acceptGlyph(bakedglyph$glyphinstance);
            }
            if (this.effects != null) {
                if (bakedglyph == null) {
                    bakedglyph = Font.this.getFontSet(Style.DEFAULT_FONT).whiteGlyph();
                }
                for (BakedGlyph.Effect bakedglyph$effect1 : this.effects) {
                    p_425967_.acceptEffect(bakedglyph, bakedglyph$effect1);
                }
            }
        }

        private int getTextColor(@Nullable TextColor p_425665_) {
            if (p_425665_ != null) {
                int i = ARGB.alpha(this.color);
                int j = p_425665_.getValue();
                return ARGB.color(i, j);
            }
            return this.color;
        }

        private int getShadowColor(Style p_425833_, int p_425604_) {
            Integer integer = p_425833_.getShadowColor();
            if (integer != null) {
                float f = ARGB.alphaFloat(p_425604_);
                float f1 = ARGB.alphaFloat(integer);
                return f != 1.0f ? ARGB.color(ARGB.as8BitChannel(f * f1), (int)integer) : integer;
            }
            return this.drawShadow ? ARGB.scaleRGB(p_425604_, 0.25f) : 0;
        }

        @Override
        @Nullable
        public ScreenRectangle bounds() {
            if (!(this.left >= this.right) && !(this.top >= this.bottom)) {
                int i = Mth.floor(this.left);
                int j = Mth.floor(this.top);
                int k = Mth.ceil(this.right);
                int l = Mth.ceil(this.bottom);
                return new ScreenRectangle(i, j, k - i, l - j);
            }
            return null;
        }
    }
}

