/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data.models;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.WaypointStyle;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.waypoints.WaypointStyleAsset;
import net.minecraft.world.waypoints.WaypointStyleAssets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaypointStyleProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public WaypointStyleProvider(PackOutput p_419947_) {
        this.pathProvider = p_419947_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "waypoint_style");
    }

    private static void bootstrap(BiConsumer<ResourceKey<WaypointStyleAsset>, WaypointStyle> p_419528_) {
        p_419528_.accept(WaypointStyleAssets.DEFAULT, new WaypointStyle(128, 332, List.of(ResourceLocation.withDefaultNamespace("default_0"), ResourceLocation.withDefaultNamespace("default_1"), ResourceLocation.withDefaultNamespace("default_2"), ResourceLocation.withDefaultNamespace("default_3"))));
        p_419528_.accept(WaypointStyleAssets.BOWTIE, new WaypointStyle(64, 332, List.of(ResourceLocation.withDefaultNamespace("bowtie"), ResourceLocation.withDefaultNamespace("default_0"), ResourceLocation.withDefaultNamespace("default_1"), ResourceLocation.withDefaultNamespace("default_2"), ResourceLocation.withDefaultNamespace("default_3"))));
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_419570_) {
        HashMap map = new HashMap();
        WaypointStyleProvider.bootstrap((p_419715_, p_419684_) -> {
            if (map.putIfAbsent(p_419715_, p_419684_) != null) {
                throw new IllegalStateException("Tried to register waypoint style twice for id: " + String.valueOf(p_419715_));
            }
        });
        return DataProvider.saveAll(p_419570_, WaypointStyle.CODEC, this.pathProvider::json, map);
    }

    @Override
    public String getName() {
        return "Waypoint Style Definitions";
    }
}

