/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class KeyframeAnimation {
    private final AnimationDefinition definition;
    private final List<Entry> entries;
    private final Vector3f scratchVector = new Vector3f();

    private KeyframeAnimation(AnimationDefinition p_427337_, List<Entry> p_427495_) {
        this.definition = p_427337_;
        this.entries = p_427495_;
    }

    static KeyframeAnimation bake(ModelPart p_427435_, AnimationDefinition p_427268_) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        Function<String, ModelPart> function = p_427435_.createPartLookup();
        for (Map.Entry<String, List<AnimationChannel>> entry : p_427268_.boneAnimations().entrySet()) {
            String s = entry.getKey();
            List<AnimationChannel> list1 = entry.getValue();
            ModelPart modelpart = function.apply(s);
            if (modelpart == null) {
                throw new IllegalArgumentException("Cannot animate " + s + ", which does not exist in model");
            }
            for (AnimationChannel animationchannel : list1) {
                list.add(new Entry(modelpart, animationchannel.target(), animationchannel.keyframes()));
            }
        }
        return new KeyframeAnimation(p_427268_, List.copyOf(list));
    }

    public void applyStatic() {
        this.apply(0L, 1.0f);
    }

    public void applyWalk(float p_427283_, float p_427496_, float p_427289_, float p_427296_) {
        long i = (long)(p_427283_ * 50.0f * p_427289_);
        float f = Math.min(p_427496_ * p_427296_, 1.0f);
        this.apply(i, f);
    }

    public void apply(AnimationState p_427382_, float p_427471_) {
        this.apply(p_427382_, p_427471_, 1.0f);
    }

    public void apply(AnimationState p_427490_, float p_427480_, float p_427356_) {
        p_427490_.ifStarted(p_427385_ -> this.apply((long)((float)p_427385_.getTimeInMillis(p_427480_) * p_427356_), 1.0f));
    }

    public void apply(long p_427232_, float p_427346_) {
        float f = this.getElapsedSeconds(p_427232_);
        for (Entry keyframeanimation$entry : this.entries) {
            keyframeanimation$entry.apply(f, p_427346_, this.scratchVector);
        }
    }

    private float getElapsedSeconds(long p_427362_) {
        float f = (float)p_427362_ / 1000.0f;
        return this.definition.looping() ? f % this.definition.lengthInSeconds() : f;
    }

    @OnlyIn(value=Dist.CLIENT)
    record Entry(ModelPart part, AnimationChannel.Target target, Keyframe[] keyframes) {
        public void apply(float p_427355_, float p_427277_, Vector3f p_427458_) {
            int i = Math.max(0, Mth.binarySearch(0, this.keyframes.length, p_427328_ -> p_427355_ <= this.keyframes[p_427328_].timestamp()) - 1);
            int j = Math.min(this.keyframes.length - 1, i + 1);
            Keyframe keyframe = this.keyframes[i];
            Keyframe keyframe1 = this.keyframes[j];
            float f = p_427355_ - keyframe.timestamp();
            float f1 = j != i ? Mth.clamp(f / (keyframe1.timestamp() - keyframe.timestamp()), 0.0f, 1.0f) : 0.0f;
            keyframe1.interpolation().apply(p_427458_, f1, this.keyframes, i, j, p_427277_);
            this.target.apply(this.part, p_427458_);
        }
    }
}

