/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileActionType;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.ClientShutdownWatchdog;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.FramerateLimitTracker;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.systems.TimerQuery;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.runtime.SwitchBootstraps;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.Optionull;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.ClientBootstrap;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.CommandHistory;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Options;
import net.minecraft.client.PeriodicNotificationManager;
import net.minecraft.client.ResourceLoadStateTracker;
import net.minecraft.client.Screenshot;
import net.minecraft.client.User;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.debugchart.ProfilerPieChart;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.providers.FreeTypeUtil;
import net.minecraft.client.gui.screens.AccessibilityOnboardingScreen;
import net.minecraft.client.gui.screens.BanNoticeScreens;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.OutOfMemoryScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.profiling.ClientMetricsSamplersProvider;
import net.minecraft.client.quickplay.QuickPlay;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.DryFoliageColorReloadListener;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.client.resources.MapTextureManager;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.WaypointStyleManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.KeybindResolver;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.Dialogs;
import net.minecraft.server.level.progress.ProcessorChunkProgressListener;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DialogTags;
import net.minecraft.util.CommonLinks;
import net.minecraft.util.FileZipper;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.ModCheck;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.ClientLifecycleHooks;
import net.neoforged.neoforge.client.DimensionTransitionScreenManager;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.IMinecraftExtension;
import net.neoforged.neoforge.client.loading.ClientModLoader;
import net.neoforged.neoforge.client.model.UnbakedModelParser;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Minecraft
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler,
IMinecraftExtension {
    static Minecraft instance;
    private static final Logger LOGGER;
    public static final boolean ON_OSX;
    private static final int MAX_TICKS_PER_UPDATE = 10;
    public static final ResourceLocation DEFAULT_FONT;
    public static final ResourceLocation UNIFORM_FONT;
    public static final ResourceLocation ALT_FONT;
    private static final ResourceLocation REGIONAL_COMPLIANCIES;
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INITIAL_TASK;
    private static final Component SOCIAL_INTERACTIONS_NOT_AVAILABLE;
    private static final Component SAVING_LEVEL;
    public static final String UPDATE_DRIVERS_ADVICE = "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
    private final long canary = Double.doubleToLongBits(Math.PI);
    private final Path resourcePackDirectory;
    private final CompletableFuture<ProfileResult> profileFuture;
    private final TextureManager textureManager;
    private final ShaderManager shaderManager;
    private final DataFixer fixerUpper;
    private final VirtualScreen virtualScreen;
    private final Window window;
    private final DeltaTracker.Timer deltaTracker = new DeltaTracker.Timer(20.0f, 0L, this::getTickTargetMillis);
    private final RenderBuffers renderBuffers;
    public final LevelRenderer levelRenderer;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemModelResolver itemModelResolver;
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    public final ParticleEngine particleEngine;
    private final User user;
    public final Font font;
    public final Font fontFilterFishy;
    public final GameRenderer gameRenderer;
    public final DebugRenderer debugRenderer;
    private final AtomicReference<StoringChunkProgressListener> progressListener = new AtomicReference();
    public final Gui gui;
    public final Options options;
    private final HotbarManager hotbarManager;
    public final MouseHandler mouseHandler;
    public final KeyboardHandler keyboardHandler;
    private InputType lastInputType = InputType.NONE;
    public final File gameDirectory;
    private final String launchedVersion;
    private final String versionType;
    private final Proxy proxy;
    private final LevelStorageSource levelSource;
    private final boolean demo;
    private final boolean allowsMultiplayer;
    private final boolean allowsChat;
    private final ReloadableResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;
    private final DownloadedPackSource downloadedPackSource;
    private final PackRepository resourcePackRepository;
    private final LanguageManager languageManager;
    private final BlockColors blockColors;
    private final RenderTarget mainRenderTarget;
    @Nullable
    private final TracyFrameCapture tracyFrameCapture;
    private final SoundManager soundManager;
    private final MusicManager musicManager;
    private final FontManager fontManager;
    private final SplashManager splashManager;
    private final GpuWarnlistManager gpuWarnlistManager;
    private final PeriodicNotificationManager regionalCompliancies = new PeriodicNotificationManager(REGIONAL_COMPLIANCIES, (Object2BooleanFunction<String>)((Object2BooleanFunction)Minecraft::countryEqualsISO3));
    private final YggdrasilAuthenticationService authenticationService;
    private final MinecraftSessionService minecraftSessionService;
    private final UserApiService userApiService;
    private final CompletableFuture<UserApiService.UserProperties> userPropertiesFuture;
    private final SkinManager skinManager;
    private final ModelManager modelManager;
    private final BlockRenderDispatcher blockRenderer;
    private final PaintingTextureManager paintingTextures;
    private final MapTextureManager mapTextureManager;
    private final MapDecorationTextureManager mapDecorationTextures;
    private final GuiSpriteManager guiSprites;
    private final WaypointStyleManager waypointStyles;
    private final ToastManager toastManager;
    private final Tutorial tutorial;
    private final PlayerSocialManager playerSocialManager;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final ClientTelemetryManager telemetryManager;
    private final ProfileKeyPairManager profileKeyPairManager;
    private final RealmsDataFetcher realmsDataFetcher;
    private final QuickPlayLog quickPlayLog;
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Nullable
    public ClientLevel level;
    @Nullable
    public LocalPlayer player;
    @Nullable
    private IntegratedServer singleplayerServer;
    @Nullable
    private Connection pendingConnection;
    private boolean isLocalServer;
    @Nullable
    public Entity cameraEntity;
    @Nullable
    public Entity crosshairPickEntity;
    @Nullable
    public HitResult hitResult;
    private int rightClickDelay;
    protected int missTime;
    private volatile boolean pause;
    private long lastNanoTime = Util.getNanos();
    private long lastTime;
    private int frames;
    public boolean noRender;
    @Nullable
    public Screen screen;
    @Nullable
    private Overlay overlay;
    private boolean clientLevelTeardownInProgress;
    Thread gameThread;
    private volatile boolean running;
    @Nullable
    private Supplier<CrashReport> delayedCrash;
    private static int fps;
    public String fpsString = "";
    private long frameTimeNs;
    private final FramerateLimitTracker framerateLimitTracker;
    public boolean wireframe;
    public boolean sectionPath;
    public boolean sectionVisibility;
    public boolean smartCull = true;
    private boolean windowActive;
    private final Queue<Runnable> progressTasks = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> pendingReload;
    @Nullable
    private TutorialToast socialInteractionsToast;
    private int fpsPieRenderTicks;
    private final ContinuousProfiler fpsPieProfiler;
    private MetricsRecorder metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    private final ResourceLoadStateTracker reloadStateTracker = new ResourceLoadStateTracker();
    private long savedCpuDuration;
    private double gpuUtilization;
    @Nullable
    private TimerQuery.FrameProfile currentFrameProfile;
    private final GameNarrator narrator;
    private final ChatListener chatListener;
    private ReportingContext reportingContext;
    private final CommandHistory commandHistory;
    private final DirectoryValidator directoryValidator;
    private boolean gameLoadFinished;
    private final long clientStartTimeMs;
    private long clientTickCount;

    public Minecraft(final GameConfig p_91084_) {
        super("Client");
        instance = this;
        this.clientStartTimeMs = System.currentTimeMillis();
        this.gameDirectory = p_91084_.location.gameDirectory;
        File file1 = p_91084_.location.assetDirectory;
        this.resourcePackDirectory = p_91084_.location.resourcePackDirectory.toPath();
        this.launchedVersion = p_91084_.game.launchVersion;
        this.versionType = p_91084_.game.versionType;
        Path path = this.gameDirectory.toPath();
        this.directoryValidator = LevelStorageSource.parseValidator(path.resolve("allowed_symlinks.txt"));
        ClientPackSource clientpacksource = new ClientPackSource(p_91084_.location.getExternalAssetSource(), this.directoryValidator);
        this.downloadedPackSource = new DownloadedPackSource(this, path.resolve("downloads"), p_91084_.user);
        FolderRepositorySource repositorysource = new FolderRepositorySource(this.resourcePackDirectory, PackType.CLIENT_RESOURCES, PackSource.DEFAULT, this.directoryValidator);
        this.resourcePackRepository = new PackRepository(clientpacksource, this.downloadedPackSource.createRepositorySource(), repositorysource);
        this.vanillaPackResources = clientpacksource.getVanillaPack();
        this.proxy = p_91084_.user.proxy;
        this.authenticationService = new YggdrasilAuthenticationService(this.proxy);
        this.minecraftSessionService = this.authenticationService.createMinecraftSessionService();
        this.user = p_91084_.user.user;
        this.profileFuture = CompletableFuture.supplyAsync(() -> this.minecraftSessionService.fetchProfile(this.user.getProfileId(), true), Util.nonCriticalIoPool());
        this.userApiService = this.createUserApiService(this.authenticationService, p_91084_);
        this.userPropertiesFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.userApiService.fetchProperties();
            }
            catch (AuthenticationException authenticationexception) {
                LOGGER.error("Failed to fetch user properties", (Throwable)authenticationexception);
                return UserApiService.OFFLINE_PROPERTIES;
            }
        }, Util.nonCriticalIoPool());
        LOGGER.info("Setting user: {}", (Object)this.user.getName());
        this.demo = p_91084_.game.demo;
        this.allowsMultiplayer = !p_91084_.game.disableMultiplayer;
        this.allowsChat = !p_91084_.game.disableChat;
        this.singleplayerServer = null;
        KeybindResolver.setKeyResolver(KeyMapping::createNameSupplier);
        this.fixerUpper = DataFixers.getDataFixer();
        this.gameThread = Thread.currentThread();
        this.options = new Options(this, this.gameDirectory);
        this.toastManager = new ToastManager(this, this.options);
        boolean flag = this.options.startedCleanly;
        this.options.startedCleanly = false;
        this.options.save();
        this.running = true;
        this.tutorial = new Tutorial(this, this.options);
        this.hotbarManager = new HotbarManager(path, this.fixerUpper);
        LOGGER.info("Backend library: {}", (Object)RenderSystem.getBackendDescription());
        DisplayData displaydata = p_91084_.display;
        if (this.options.overrideHeight > 0 && this.options.overrideWidth > 0) {
            displaydata = p_91084_.display.withSize(this.options.overrideWidth, this.options.overrideHeight);
        }
        if (!flag) {
            displaydata = displaydata.withFullscreen(false);
            this.options.fullscreenVideoModeString = null;
            LOGGER.warn("Detected unexpected shutdown during last game startup: resetting fullscreen mode");
        }
        Util.timeSource = RenderSystem.initBackendSystem();
        this.virtualScreen = new VirtualScreen(this);
        this.window = this.virtualScreen.newWindow(displaydata, this.options.fullscreenVideoModeString, this.createTitle());
        this.setWindowActive(true);
        this.window.setWindowCloseCallback(new Runnable(){
            private boolean threadStarted;

            @Override
            public void run() {
                if (!this.threadStarted) {
                    this.threadStarted = true;
                    ClientShutdownWatchdog.startShutdownWatchdog(p_91084_.location.gameDirectory, Minecraft.this.gameThread.threadId());
                }
            }
        });
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_PRE_WINDOW_MS);
        try {
            this.window.setIcon(this.vanillaPackResources, SharedConstants.getCurrentVersion().stable() ? IconSet.RELEASE : IconSet.SNAPSHOT);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't set icon", (Throwable)ioexception);
        }
        this.mouseHandler = new MouseHandler(this);
        this.keyboardHandler = new KeyboardHandler(this);
        boolean enableGlDebug = FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.DEBUG_OPENGL);
        RenderSystem.initRenderer(this.window.getWindow(), this.options.glDebugVerbosity, enableGlDebug, (p_408948_, p_408949_) -> this.getShaderManager().getShader((ResourceLocation)p_408948_, (ShaderType)((Object)p_408949_)), p_91084_.game.renderDebugLabels || enableGlDebug);
        LOGGER.info("Using optional rendering extensions: {}", (Object)String.join((CharSequence)", ", RenderSystem.getDevice().getEnabledExtensions()));
        this.mainRenderTarget = ClientHooks.instantiateMainTarget((int)this.window.getWidth(), (int)this.window.getHeight());
        this.resourceManager = new ReloadableResourceManager(PackType.CLIENT_RESOURCES);
        ClientModLoader.finish((PackRepository)this.resourcePackRepository, (ReloadableResourceManager)this.resourceManager);
        ClientBootstrap.bootstrap();
        this.resourcePackRepository.reload();
        this.options.loadSelectedResourcePacks(this.resourcePackRepository);
        this.languageManager = new LanguageManager(this.options.languageCode, p_344151_ -> {
            if (this.player != null) {
                this.player.connection.updateSearchTrees();
            }
        });
        this.resourceManager.registerReloadListener(this.languageManager);
        this.textureManager = new TextureManager(this.resourceManager);
        this.resourceManager.registerReloadListener(this.textureManager);
        this.shaderManager = new ShaderManager(this.textureManager, this::triggerResourcePackRecovery);
        this.resourceManager.registerReloadListener(this.shaderManager);
        this.skinManager = new SkinManager(file1.toPath().resolve("skins"), this.minecraftSessionService, this);
        this.levelSource = new LevelStorageSource(path.resolve("saves"), path.resolve("backups"), this.directoryValidator, this.fixerUpper);
        this.commandHistory = new CommandHistory(path);
        this.musicManager = new MusicManager(this);
        this.soundManager = new SoundManager(this.options, this.musicManager);
        this.resourceManager.registerReloadListener(this.soundManager);
        this.splashManager = new SplashManager(this.user);
        this.resourceManager.registerReloadListener(this.splashManager);
        this.fontManager = new FontManager(this.textureManager);
        this.font = this.fontManager.createFont();
        this.fontFilterFishy = this.fontManager.createFontFilterFishy();
        this.resourceManager.registerReloadListener(this.fontManager);
        this.updateFontOptions();
        this.resourceManager.registerReloadListener(new GrassColorReloadListener());
        this.resourceManager.registerReloadListener(new FoliageColorReloadListener());
        this.resourceManager.registerReloadListener(new DryFoliageColorReloadListener());
        this.window.setErrorSection("Startup");
        RenderSystem.setupDefaultState();
        this.window.setErrorSection("Post startup");
        this.blockColors = BlockColors.createDefault();
        UnbakedModelParser.init();
        this.modelManager = new ModelManager(this.textureManager, this.blockColors, this.options.mipmapLevels().get());
        this.resourceManager.registerReloadListener(this.modelManager);
        EquipmentAssetManager equipmentassetmanager = new EquipmentAssetManager();
        this.resourceManager.registerReloadListener(equipmentassetmanager);
        this.itemModelResolver = new ItemModelResolver(this.modelManager);
        this.itemRenderer = new ItemRenderer(this.itemModelResolver);
        this.mapTextureManager = new MapTextureManager(this.textureManager);
        this.mapDecorationTextures = new MapDecorationTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.mapDecorationTextures);
        this.mapRenderer = new MapRenderer(this.mapDecorationTextures, this.mapTextureManager);
        try {
            int i = Runtime.getRuntime().availableProcessors();
            Tesselator.init();
            this.renderBuffers = new RenderBuffers(i);
        }
        catch (OutOfMemoryError outofmemoryerror) {
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)("Oh no! The game was unable to allocate memory off-heap while trying to start. You may try to free some memory by closing other applications on your computer, check that your system meets the minimum requirements, and try again. If the problem persists, please visit: " + String.valueOf(CommonLinks.GENERAL_HELP)), (CharSequence)"ok", (CharSequence)"error", (boolean)true);
            throw new SilentInitException("Unable to allocate render buffers", outofmemoryerror);
        }
        this.playerSocialManager = new PlayerSocialManager(this, this.userApiService);
        this.blockRenderer = new BlockRenderDispatcher(this.modelManager.getBlockModelShaper(), this.modelManager.specialBlockModelRenderer(), this.blockColors);
        this.resourceManager.registerReloadListener(this.blockRenderer);
        this.entityRenderDispatcher = new EntityRenderDispatcher(this, this.textureManager, this.itemModelResolver, this.itemRenderer, this.mapRenderer, this.blockRenderer, this.font, this.options, this.modelManager.entityModels(), equipmentassetmanager);
        this.resourceManager.registerReloadListener(this.entityRenderDispatcher);
        this.blockEntityRenderDispatcher = new BlockEntityRenderDispatcher(this.font, this.modelManager.entityModels(), this.blockRenderer, this.itemModelResolver, this.itemRenderer, this.entityRenderDispatcher);
        this.resourceManager.registerReloadListener(this.blockEntityRenderDispatcher);
        this.particleEngine = new ParticleEngine(this.level, this.textureManager);
        ClientHooks.onRegisterParticleProviders((ParticleEngine)this.particleEngine);
        this.resourceManager.registerReloadListener(this.particleEngine);
        this.paintingTextures = new PaintingTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.paintingTextures);
        this.guiSprites = new GuiSpriteManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.guiSprites);
        this.waypointStyles = new WaypointStyleManager();
        this.resourceManager.registerReloadListener(this.waypointStyles);
        this.gameRenderer = new GameRenderer(this, this.entityRenderDispatcher.getItemInHandRenderer(), this.renderBuffers);
        this.levelRenderer = new LevelRenderer(this, this.entityRenderDispatcher, this.blockEntityRenderDispatcher, this.renderBuffers);
        this.resourceManager.registerReloadListener(this.levelRenderer);
        this.resourceManager.registerReloadListener(this.levelRenderer.getCloudRenderer());
        this.gpuWarnlistManager = new GpuWarnlistManager();
        this.resourceManager.registerReloadListener(this.gpuWarnlistManager);
        this.resourceManager.registerReloadListener(this.regionalCompliancies);
        this.mouseHandler.setup(this.window.getWindow());
        this.keyboardHandler.setup(this.window.getWindow());
        this.gui = new Gui(this);
        this.debugRenderer = new DebugRenderer(this);
        RealmsClient realmsclient = RealmsClient.getOrCreate(this);
        this.realmsDataFetcher = new RealmsDataFetcher(realmsclient);
        RenderSystem.setErrorCallback(this::onFullscreenError);
        if (this.mainRenderTarget.width != this.window.getWidth() || this.mainRenderTarget.height != this.window.getHeight()) {
            StringBuilder stringbuilder = new StringBuilder("Recovering from unsupported resolution (" + this.window.getWidth() + "x" + this.window.getHeight() + ").\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).");
            try {
                GpuDevice gpudevice = RenderSystem.getDevice();
                List<String> list = gpudevice.getLastDebugMessages();
                if (!list.isEmpty()) {
                    stringbuilder.append("\n\nReported GL debug messages:\n").append(String.join((CharSequence)"\n", list));
                }
            }
            catch (Throwable gpudevice) {
                // empty catch block
            }
            this.window.setWindowed(this.mainRenderTarget.width, this.mainRenderTarget.height);
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)stringbuilder.toString(), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        } else if (this.options.fullscreen().get().booleanValue() && !this.window.isFullscreen()) {
            if (flag) {
                this.window.toggleFullScreen();
                this.options.fullscreen().set(this.window.isFullscreen());
            } else {
                this.options.fullscreen().set(false);
            }
        }
        ClientHooks.initClientHooks((Minecraft)this, (ReloadableResourceManager)this.resourceManager);
        this.window.updateVsync(this.options.enableVsync().get());
        this.window.updateRawMouseInput(this.options.rawMouseInput().get());
        this.window.setDefaultErrorCallback();
        this.resizeDisplay();
        this.gameRenderer.preloadUiShader(this.vanillaPackResources.asProvider());
        this.telemetryManager = new ClientTelemetryManager(this, this.userApiService, this.user);
        this.profileKeyPairManager = ProfileKeyPairManager.create(this.userApiService, this.user, path);
        this.narrator = new GameNarrator(this);
        this.narrator.checkStatus(this.options.narrator().get() != NarratorStatus.OFF);
        this.chatListener = new ChatListener(this);
        this.chatListener.setMessageDelay(this.options.chatDelay().get());
        this.reportingContext = ReportingContext.create(ReportEnvironment.local(), this.userApiService);
        TitleScreen.registerTextures(this.textureManager);
        LoadingOverlay.registerTextures(this.textureManager);
        this.gameRenderer.getPanorama().registerTextures(this.textureManager);
        this.setScreen(new GenericMessageScreen(Component.translatable("gui.loadingMinecraft")));
        List<PackResources> list1 = this.resourcePackRepository.openAllSelected();
        this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.INITIAL, list1);
        ReloadInstance reloadinstance = this.resourceManager.createReload(Util.backgroundExecutor().forName("resourceLoad"), this, RESOURCE_RELOAD_INITIAL_TASK, list1);
        GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_LOADING_OVERLAY_MS);
        GameLoadCookie minecraft$gameloadcookie = new GameLoadCookie(realmsclient, p_91084_.quickPlay);
        this.setOverlay(ClientHooks.createLoadingOverlay((Minecraft)this, (ReloadInstance)reloadinstance, p_299779_ -> Util.ifElse(p_299779_, p_299772_ -> this.rollbackResourcePacks((Throwable)p_299772_, minecraft$gameloadcookie), () -> {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                // empty if block
            }
            this.reloadStateTracker.finishReload();
            this.onResourceLoadFinished(minecraft$gameloadcookie);
        }), (boolean)false));
        this.quickPlayLog = QuickPlayLog.of(p_91084_.quickPlay.logPath());
        this.framerateLimitTracker = new FramerateLimitTracker(this.options, this);
        this.fpsPieProfiler = new ContinuousProfiler(Util.timeSource, () -> this.fpsPieRenderTicks, this.framerateLimitTracker::isHeavilyThrottled);
        this.tracyFrameCapture = TracyClient.isAvailable() && p_91084_.game.captureTracyImages ? new TracyFrameCapture() : null;
    }

    private void onResourceLoadFinished(@Nullable GameLoadCookie p_299896_) {
        ClientHooks.fireResourceLoadFinishedEvent((!this.gameLoadFinished ? 1 : 0) != 0);
        if (!this.gameLoadFinished) {
            this.gameLoadFinished = true;
            this.onGameLoadFinished(p_299896_);
        }
    }

    private void onGameLoadFinished(@Nullable GameLoadCookie p_299836_) {
        Runnable runnable = this.buildInitialScreens(p_299836_);
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_LOADING_OVERLAY_MS);
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_TOTAL_TIME_MS);
        GameLoadTimesEvent.INSTANCE.send(this.telemetryManager.getOutsideSessionSender());
        runnable.run();
        this.options.startedCleanly = true;
        this.options.save();
    }

    public boolean isGameLoadFinished() {
        return this.gameLoadFinished;
    }

    private Runnable buildInitialScreens(@Nullable GameLoadCookie p_299894_) {
        ArrayList<Function<Runnable, Screen>> list = new ArrayList<Function<Runnable, Screen>>();
        boolean flag = this.addInitialScreens(list);
        Runnable runnable = () -> {
            if (p_299894_ != null && p_299894_.quickPlayData.isEnabled()) {
                QuickPlay.connect(this, p_299894_.quickPlayData.variant(), p_299894_.realmsClient());
            } else {
                this.setScreen(new TitleScreen(true, new LogoRenderer(flag)));
            }
        };
        for (Function function : Lists.reverse(list)) {
            Screen screen = (Screen)function.apply(runnable);
            runnable = () -> this.setScreen(screen);
        }
        runnable = ClientModLoader.completeModLoading((Runnable)runnable);
        return runnable;
    }

    private boolean addInitialScreens(List<Function<Runnable, Screen>> p_300000_) {
        ProfileResult profileresult;
        BanDetails bandetails;
        boolean flag = false;
        if (this.options.onboardAccessibility) {
            p_300000_.add(p_299781_ -> new AccessibilityOnboardingScreen(this.options, (Runnable)p_299781_));
            flag = true;
        }
        if ((bandetails = this.multiplayerBan()) != null) {
            p_300000_.add(p_299775_ -> BanNoticeScreens.create(p_351634_ -> {
                if (p_351634_) {
                    Util.getPlatform().openUri(CommonLinks.SUSPENSION_HELP);
                }
                p_299775_.run();
            }, bandetails));
        }
        if ((profileresult = this.profileFuture.join()) != null) {
            GameProfile gameprofile = profileresult.profile();
            Set set = profileresult.actions();
            if (set.contains(ProfileActionType.FORCED_NAME_CHANGE)) {
                p_300000_.add(p_299783_ -> BanNoticeScreens.createNameBan(gameprofile.getName(), p_299783_));
            }
            if (set.contains(ProfileActionType.USING_BANNED_SKIN)) {
                p_300000_.add(BanNoticeScreens::createSkinBan);
            }
        }
        return flag;
    }

    private static boolean countryEqualsISO3(Object p_210783_) {
        try {
            return Locale.getDefault().getISO3Country().equals(p_210783_);
        }
        catch (MissingResourceException missingresourceexception) {
            return false;
        }
    }

    public void updateTitle() {
        this.window.setTitle(this.createTitle());
    }

    private String createTitle() {
        StringBuilder stringbuilder = new StringBuilder("Minecraft");
        if (Minecraft.checkModStatus().shouldReportAsModified()) {
            stringbuilder.append(' ').append("NeoForge").append('*');
        }
        stringbuilder.append(" ");
        stringbuilder.append(SharedConstants.getCurrentVersion().name());
        ClientPacketListener clientpacketlistener = this.getConnection();
        if (clientpacketlistener != null && clientpacketlistener.getConnection().isConnected()) {
            stringbuilder.append(" - ");
            ServerData serverdata = this.getCurrentServer();
            if (this.singleplayerServer != null && !this.singleplayerServer.isPublished()) {
                stringbuilder.append(I18n.get("title.singleplayer", new Object[0]));
            } else if (serverdata != null && serverdata.isRealm()) {
                stringbuilder.append(I18n.get("title.multiplayer.realms", new Object[0]));
            } else if (!(this.singleplayerServer != null || serverdata != null && serverdata.isLan())) {
                stringbuilder.append(I18n.get("title.multiplayer.other", new Object[0]));
            } else {
                stringbuilder.append(I18n.get("title.multiplayer.lan", new Object[0]));
            }
        }
        return stringbuilder.toString();
    }

    private UserApiService createUserApiService(YggdrasilAuthenticationService p_193586_, GameConfig p_193587_) {
        return p_193587_.user.user.getType() != User.Type.MSA ? UserApiService.OFFLINE : p_193586_.createUserApiService(p_193587_.user.user.getAccessToken());
    }

    public static ModCheck checkModStatus() {
        return ModCheck.identify("vanilla", ClientBrandRetriever::getClientModName, "Client", Minecraft.class);
    }

    private void rollbackResourcePacks(Throwable p_91240_, @Nullable GameLoadCookie p_299846_) {
        if (this.resourcePackRepository.getSelectedPacks().stream().anyMatch(e -> !e.isRequired())) {
            this.clearResourcePacksOnError(p_91240_, null, p_299846_);
        } else {
            Util.throwAsRuntime(p_91240_);
        }
    }

    public void clearResourcePacksOnError(Throwable p_91242_, @Nullable Component p_91243_, @Nullable GameLoadCookie p_299892_) {
        LOGGER.info("Caught error loading resourcepacks, removing all selected resourcepacks", p_91242_);
        this.reloadStateTracker.startRecovery(p_91242_);
        this.downloadedPackSource.onRecovery();
        this.resourcePackRepository.setSelected(Collections.emptyList());
        this.options.resourcePacks.clear();
        this.options.incompatibleResourcePacks.clear();
        this.options.save();
        this.reloadResourcePacks(true, p_299892_).thenRunAsync(() -> this.addResourcePackLoadFailToast(p_91243_), this);
    }

    private void abortResourcePackRecovery() {
        this.setOverlay(null);
        if (this.level != null) {
            this.level.disconnect(ClientLevel.DEFAULT_QUIT_MESSAGE);
            this.disconnectWithProgressScreen();
        }
        this.setScreen(new TitleScreen());
        this.addResourcePackLoadFailToast(null);
    }

    private void addResourcePackLoadFailToast(@Nullable Component p_273566_) {
        ToastManager toastmanager = this.getToastManager();
        SystemToast.addOrUpdate(toastmanager, SystemToast.SystemToastId.PACK_LOAD_FAILURE, Component.translatable("resourcePack.load_fail"), p_273566_);
    }

    public void triggerResourcePackRecovery(Exception p_368605_) {
        if (!this.resourcePackRepository.isAbleToClearAnyPack()) {
            if (this.resourcePackRepository.getSelectedIds().size() <= 1) {
                LOGGER.error(LogUtils.FATAL_MARKER, p_368605_.getMessage(), (Throwable)p_368605_);
                this.emergencySaveAndCrash(new CrashReport(p_368605_.getMessage(), p_368605_));
            } else {
                this.schedule(this::abortResourcePackRecovery);
            }
        } else {
            this.clearResourcePacksOnError(p_368605_, Component.translatable("resourcePack.runtime_failure"), null);
        }
    }

    public void run() {
        this.gameThread = Thread.currentThread();
        if (Runtime.getRuntime().availableProcessors() > 4) {
            this.gameThread.setPriority(10);
        }
        DiscontinuousFrame discontinuousframe = TracyClient.createDiscontinuousFrame((String)"Client Tick");
        try {
            ClientLifecycleHooks.handleClientStarted((Minecraft)this);
            boolean flag = false;
            while (this.running) {
                this.handleDelayedCrash();
                try {
                    SingleTickProfiler singletickprofiler = SingleTickProfiler.createTickProfiler("Renderer");
                    boolean flag1 = this.getDebugOverlay().showProfilerChart();
                    try (Profiler.Scope profiler$scope = Profiler.use(this.constructProfiler(flag1, singletickprofiler));){
                        this.metricsRecorder.startTick();
                        discontinuousframe.start();
                        this.runTick(!flag);
                        discontinuousframe.end();
                        this.metricsRecorder.endTick();
                    }
                    this.finishProfilers(flag1, singletickprofiler);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    if (flag) {
                        throw outofmemoryerror;
                    }
                    this.emergencySave();
                    this.setScreen(new OutOfMemoryScreen());
                    System.gc();
                    LOGGER.error(LogUtils.FATAL_MARKER, "Out of memory", (Throwable)outofmemoryerror);
                    flag = true;
                }
            }
        }
        catch (ReportedException reportedexception) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Reported exception thrown!", (Throwable)reportedexception);
            this.emergencySaveAndCrash(reportedexception.getReport());
        }
        catch (Throwable throwable1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Unreported exception thrown!", throwable1);
            this.emergencySaveAndCrash(new CrashReport("Unexpected error", throwable1));
        }
    }

    void updateFontOptions() {
        this.fontManager.updateOptions(this.options);
    }

    private void onFullscreenError(int p_91114_, long p_91115_) {
        this.options.enableVsync().set(false);
        this.options.save();
    }

    public RenderTarget getMainRenderTarget() {
        return this.mainRenderTarget;
    }

    public String getLaunchedVersion() {
        return this.launchedVersion;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public void delayCrash(CrashReport p_231413_) {
        this.delayedCrash = () -> this.fillReport(p_231413_);
    }

    public void delayCrashRaw(CrashReport p_231440_) {
        this.delayedCrash = () -> p_231440_;
    }

    private void handleDelayedCrash() {
        if (this.delayedCrash != null) {
            Minecraft.crash(this, this.gameDirectory, this.delayedCrash.get());
        }
    }

    public void emergencySaveAndCrash(CrashReport p_307515_) {
        MemoryReserve.release();
        CrashReport crashreport = this.fillReport(p_307515_);
        this.emergencySave();
        Minecraft.crash(this, this.gameDirectory, crashreport);
    }

    public static int saveReport(File p_365472_, CrashReport p_362904_) {
        Path path = p_365472_.toPath().resolve("crash-reports");
        Path path1 = path.resolve("crash-" + Util.getFilenameFormattedDateTime() + "-client.txt");
        Bootstrap.realStdoutPrintln(p_362904_.getFriendlyReport(ReportType.CRASH));
        if (p_362904_.getSaveFile() != null) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + String.valueOf(p_362904_.getSaveFile().toAbsolutePath()));
            return -1;
        }
        if (p_362904_.saveToFile(path1, ReportType.CRASH)) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + String.valueOf(path1.toAbsolutePath()));
            return -1;
        }
        Bootstrap.realStdoutPrintln("#@?@# Game crashed! Crash report could not be saved. #@?@#");
        return -2;
    }

    public static void crash(@Nullable Minecraft p_307414_, File p_307228_, CrashReport p_91333_) {
        int i = Minecraft.saveReport(p_307228_, p_91333_);
        if (p_307414_ != null) {
            p_307414_.soundManager.emergencyShutdown();
        }
        ServerLifecycleHooks.handleExit((int)i);
    }

    public boolean isEnforceUnicode() {
        return this.options.forceUnicodeFont().get();
    }

    public CompletableFuture<Void> reloadResourcePacks() {
        return this.reloadResourcePacks(false, null);
    }

    private CompletableFuture<Void> reloadResourcePacks(boolean p_168020_, @Nullable GameLoadCookie p_299856_) {
        if (this.pendingReload != null) {
            return this.pendingReload;
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        if (!p_168020_ && this.overlay instanceof LoadingOverlay) {
            this.pendingReload = completablefuture;
            return completablefuture;
        }
        this.resourcePackRepository.reload();
        List<PackResources> list = this.resourcePackRepository.openAllSelected();
        if (!p_168020_) {
            this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.MANUAL, list);
        }
        this.setOverlay(new LoadingOverlay(this, this.resourceManager.createReload(Util.backgroundExecutor().forName("resourceLoad"), this, RESOURCE_RELOAD_INITIAL_TASK, list), p_299767_ -> Util.ifElse(p_299767_, p_314392_ -> {
            if (p_168020_) {
                this.downloadedPackSource.onRecoveryFailure();
                this.abortResourcePackRecovery();
            } else {
                this.rollbackResourcePacks((Throwable)p_314392_, p_299856_);
            }
        }, () -> {
            this.levelRenderer.allChanged();
            this.reloadStateTracker.finishReload();
            this.downloadedPackSource.onReloadSuccess();
            completablefuture.complete(null);
            this.onResourceLoadFinished(p_299856_);
        }), !p_168020_));
        return completablefuture;
    }

    private void selfTest() {
        boolean flag = false;
        BlockModelShaper blockmodelshaper = this.getBlockRenderer().getBlockModelShaper();
        BlockStateModel blockstatemodel = blockmodelshaper.getModelManager().getMissingBlockStateModel();
        for (Block block : BuiltInRegistries.BLOCK) {
            for (BlockState blockstate : block.getStateDefinition().getPossibleStates()) {
                BlockStateModel blockstatemodel1;
                if (blockstate.getRenderShape() != RenderShape.MODEL || (blockstatemodel1 = blockmodelshaper.getBlockModel(blockstate)) != blockstatemodel) continue;
                LOGGER.debug("Missing model for: {}", (Object)blockstate);
                flag = true;
            }
        }
        TextureAtlasSprite textureatlassprite1 = blockstatemodel.particleIcon();
        for (Block block1 : BuiltInRegistries.BLOCK) {
            for (BlockState blockstate1 : block1.getStateDefinition().getPossibleStates()) {
                TextureAtlasSprite textureatlassprite = blockmodelshaper.getParticleIcon(blockstate1);
                if (blockstate1.isAir() || textureatlassprite != textureatlassprite1) continue;
                LOGGER.debug("Missing particle icon for: {}", (Object)blockstate1);
            }
        }
        BuiltInRegistries.ITEM.listElements().forEach(p_370276_ -> {
            Item item = (Item)p_370276_.value();
            String s = item.getDescriptionId();
            String s1 = Component.translatable(s).getString();
            if (s1.toLowerCase(Locale.ROOT).equals(item.getDescriptionId())) {
                LOGGER.debug("Missing translation for: {} {} {}", new Object[]{p_370276_.key().location(), s, item});
            }
        });
        flag |= MenuScreens.selfTest();
        if (flag |= EntityRenderers.validateRegistrations()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public LevelStorageSource getLevelSource() {
        return this.levelSource;
    }

    private void openChatScreen(String p_91327_) {
        ChatStatus minecraft$chatstatus = this.getChatStatus();
        if (!minecraft$chatstatus.isChatAllowed(this.isLocalServer())) {
            if (this.gui.isShowingChatDisabledByPlayer()) {
                this.gui.setChatDisabledByPlayerShown(false);
                this.setScreen(new ConfirmLinkScreen(p_351635_ -> {
                    if (p_351635_) {
                        Util.getPlatform().openUri(CommonLinks.ACCOUNT_SETTINGS);
                    }
                    this.setScreen(null);
                }, ChatStatus.INFO_DISABLED_BY_PROFILE, CommonLinks.ACCOUNT_SETTINGS, true));
            } else {
                Component component = minecraft$chatstatus.getMessage();
                this.gui.setOverlayMessage(component, false);
                this.narrator.saySystemNow(component);
                this.gui.setChatDisabledByPlayerShown(minecraft$chatstatus == ChatStatus.DISABLED_BY_PROFILE);
            }
        } else {
            this.setScreen(new ChatScreen(p_91327_));
        }
    }

    public void setScreen(@Nullable Screen p_91153_) {
        if (SharedConstants.IS_RUNNING_IN_IDE && Thread.currentThread() != this.gameThread) {
            LOGGER.error("setScreen called from non-game thread");
        }
        if (this.screen == null) {
            this.setLastInputType(InputType.NONE);
        }
        if (p_91153_ == null && this.clientLevelTeardownInProgress) {
            throw new IllegalStateException("Trying to return to in-game GUI during disconnection");
        }
        if (p_91153_ == null && this.level == null) {
            p_91153_ = new TitleScreen();
        } else if (p_91153_ == null && this.player.isDeadOrDying()) {
            if (this.player.shouldShowDeathScreen()) {
                p_91153_ = new DeathScreen(null, this.level.getLevelData().isHardcore());
            } else {
                this.player.respawn();
            }
        }
        ClientHooks.clearGuiLayers((Minecraft)this);
        Screen old = this.screen;
        if (p_91153_ != null) {
            ScreenEvent.Opening event = new ScreenEvent.Opening(old, p_91153_);
            if (((ScreenEvent.Opening)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                return;
            }
            p_91153_ = event.getNewScreen();
        }
        if (old != null && p_91153_ != old) {
            NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Closing(old));
            old.removed();
        }
        this.screen = p_91153_;
        if (this.screen != null) {
            this.screen.added();
        }
        if (p_91153_ != null) {
            this.mouseHandler.releaseMouse();
            KeyMapping.releaseAll();
            p_91153_.init(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
            this.noRender = false;
        } else {
            this.soundManager.resume();
            this.mouseHandler.grabMouse();
        }
        this.updateTitle();
    }

    public void setOverlay(@Nullable Overlay p_91151_) {
        this.overlay = p_91151_;
    }

    public void destroy() {
        try {
            ClientLifecycleHooks.handleClientStopping((Minecraft)this);
            LOGGER.info("Stopping!");
            try {
                this.narrator.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.level != null) {
                    this.level.disconnect(ClientLevel.DEFAULT_QUIT_MESSAGE);
                }
                this.disconnectWithProgressScreen();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.screen != null) {
                this.screen.removed();
            }
            this.close();
            ClientLifecycleHooks.handleClientStopped((Minecraft)this);
        }
        finally {
            Util.timeSource = System::nanoTime;
            if (this.delayedCrash == null) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        if (this.currentFrameProfile != null) {
            this.currentFrameProfile.cancel();
        }
        try {
            this.telemetryManager.close();
            this.regionalCompliancies.close();
            this.modelManager.close();
            this.fontManager.close();
            this.gameRenderer.close();
            this.shaderManager.close();
            this.levelRenderer.close();
            this.soundManager.destroy();
            this.particleEngine.close();
            this.paintingTextures.close();
            this.mapDecorationTextures.close();
            this.guiSprites.close();
            this.mapTextureManager.close();
            this.textureManager.close();
            this.resourceManager.close();
            if (this.tracyFrameCapture != null) {
                this.tracyFrameCapture.close();
            }
            FreeTypeUtil.destroy();
            Util.shutdownExecutors();
            RenderSystem.getDevice().close();
        }
        catch (Throwable throwable) {
            LOGGER.error("Shutdown failure!", throwable);
            throw throwable;
        }
        finally {
            this.virtualScreen.close();
            this.window.close();
        }
    }

    private void runTick(boolean p_91384_) {
        boolean pause;
        boolean flag;
        Runnable runnable;
        this.window.setErrorSection("Pre render");
        if (this.window.shouldClose()) {
            this.stop();
        }
        if (this.pendingReload != null && !(this.overlay instanceof LoadingOverlay)) {
            CompletableFuture<Void> completablefuture = this.pendingReload;
            this.pendingReload = null;
            this.reloadResourcePacks().thenRun(() -> completablefuture.complete(null));
        }
        while ((runnable = this.progressTasks.poll()) != null) {
            runnable.run();
        }
        int i = this.deltaTracker.advanceTime(Util.getMillis(), p_91384_);
        ProfilerFiller profilerfiller = Profiler.get();
        if (p_91384_) {
            profilerfiller.push("scheduledExecutables");
            this.runAllTasks();
            profilerfiller.pop();
            profilerfiller.push("tick");
            for (int j = 0; j < Math.min(10, i); ++j) {
                profilerfiller.incrementCounter("clientTick");
                this.tick();
            }
            profilerfiller.pop();
        }
        this.window.setErrorSection("Render");
        profilerfiller.push("gpuAsync");
        RenderSystem.executePendingTasks();
        profilerfiller.popPush("sound");
        this.soundManager.updateSource(this.gameRenderer.getMainCamera());
        profilerfiller.popPush("toasts");
        this.toastManager.update();
        profilerfiller.popPush("render");
        long j1 = Util.getNanos();
        if (!this.getDebugOverlay().showDebugScreen() && !this.metricsRecorder.isRecording()) {
            flag = false;
            this.gpuUtilization = 0.0;
        } else {
            boolean bl = flag = this.currentFrameProfile == null || this.currentFrameProfile.isDone();
            if (flag) {
                TimerQuery.getInstance().ifPresent(TimerQuery::beginProfile);
            }
        }
        RenderTarget rendertarget = this.getMainRenderTarget();
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(rendertarget.getColorTexture(), 0, rendertarget.getDepthTexture(), 1.0);
        profilerfiller.push("mouse");
        this.mouseHandler.handleAccumulatedMovement();
        profilerfiller.pop();
        if (!this.noRender) {
            ClientHooks.fireRenderFramePre((DeltaTracker)this.deltaTracker);
            profilerfiller.popPush("gameRenderer");
            this.gameRenderer.render(this.deltaTracker, p_91384_);
            profilerfiller.pop();
            ClientHooks.fireRenderFramePost((DeltaTracker)this.deltaTracker);
        }
        profilerfiller.push("blit");
        if (!this.window.isMinimized()) {
            rendertarget.blitToScreen();
        }
        this.frameTimeNs = Util.getNanos() - j1;
        if (flag) {
            TimerQuery.getInstance().ifPresent(p_231363_ -> {
                this.currentFrameProfile = p_231363_.endProfile();
            });
        }
        profilerfiller.popPush("updateDisplay");
        if (this.tracyFrameCapture != null) {
            this.tracyFrameCapture.upload();
            this.tracyFrameCapture.capture(rendertarget);
        }
        this.window.updateDisplay(this.tracyFrameCapture);
        int k = this.framerateLimitTracker.getFramerateLimit();
        if (k < 260) {
            RenderSystem.limitDisplayFPS(k);
        }
        profilerfiller.popPush("yield");
        Thread.yield();
        profilerfiller.pop();
        this.window.setErrorSection("Post render");
        ++this.frames;
        boolean flag1 = this.pause;
        boolean bl = pause = this.hasSingleplayerServer() && (this.screen != null && this.screen.isPauseScreen() || this.overlay != null && this.overlay.isPauseScreen()) && !this.singleplayerServer.isPublished();
        if (pause != this.pause && !ClientHooks.onClientPauseChangePre((boolean)pause)) {
            this.pause = pause;
            ClientHooks.onClientPauseChangePost((boolean)pause);
        }
        if (!flag1 && this.pause) {
            this.soundManager.pauseAllExcept(SoundSource.MUSIC, SoundSource.UI);
        }
        this.deltaTracker.updatePauseState(this.pause);
        this.deltaTracker.updateFrozenState(!this.isLevelRunningNormally());
        long l = Util.getNanos();
        long i1 = l - this.lastNanoTime;
        if (flag) {
            this.savedCpuDuration = i1;
        }
        this.getDebugOverlay().logFrameDuration(i1);
        this.lastNanoTime = l;
        profilerfiller.push("fpsUpdate");
        if (this.currentFrameProfile != null && this.currentFrameProfile.isDone()) {
            this.gpuUtilization = (double)this.currentFrameProfile.get() * 100.0 / (double)this.savedCpuDuration;
        }
        while (Util.getMillis() >= this.lastTime + 1000L) {
            Object s = this.gpuUtilization > 0.0 ? " GPU: " + (this.gpuUtilization > 100.0 ? String.valueOf(ChatFormatting.RED) + "100%" : Math.round(this.gpuUtilization) + "%") : "";
            fps = this.frames;
            this.fpsString = String.format(Locale.ROOT, "%d fps T: %s%s%s%s B: %d%s", fps, k == 260 ? "inf" : Integer.valueOf(k), this.options.enableVsync().get() != false ? " vsync " : " ", this.options.graphicsMode().get(), this.options.cloudStatus().get() == CloudStatus.OFF ? "" : (this.options.cloudStatus().get() == CloudStatus.FAST ? " fast-clouds" : " fancy-clouds"), this.options.biomeBlendRadius().get(), s);
            this.lastTime += 1000L;
            this.frames = 0;
        }
        profilerfiller.pop();
    }

    private ProfilerFiller constructProfiler(boolean p_167971_, @Nullable SingleTickProfiler p_167972_) {
        ProfilerFiller profilerfiller;
        if (!p_167971_) {
            this.fpsPieProfiler.disable();
            if (!this.metricsRecorder.isRecording() && p_167972_ == null) {
                return InactiveProfiler.INSTANCE;
            }
        }
        if (p_167971_) {
            if (!this.fpsPieProfiler.isEnabled()) {
                this.fpsPieRenderTicks = 0;
                this.fpsPieProfiler.enable();
            }
            ++this.fpsPieRenderTicks;
            profilerfiller = this.fpsPieProfiler.getFiller();
        } else {
            profilerfiller = InactiveProfiler.INSTANCE;
        }
        if (this.metricsRecorder.isRecording()) {
            profilerfiller = ProfilerFiller.combine(profilerfiller, this.metricsRecorder.getProfiler());
        }
        return SingleTickProfiler.decorateFiller(profilerfiller, p_167972_);
    }

    private void finishProfilers(boolean p_91339_, @Nullable SingleTickProfiler p_91340_) {
        if (p_91340_ != null) {
            p_91340_.endTick();
        }
        ProfilerPieChart profilerpiechart = this.getDebugOverlay().getProfilerPieChart();
        if (p_91339_) {
            profilerpiechart.setPieChartResults(this.fpsPieProfiler.getResults());
        } else {
            profilerpiechart.setPieChartResults(null);
        }
    }

    @Override
    public void resizeDisplay() {
        RenderTarget rendertarget;
        int i = this.window.calculateScale(this.options.guiScale().get(), this.isEnforceUnicode());
        this.window.setGuiScale(i);
        if (this.screen != null) {
            this.screen.resize(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
            ClientHooks.resizeGuiLayers((Minecraft)this, (int)this.window.getGuiScaledWidth(), (int)this.window.getGuiScaledHeight());
        }
        if ((rendertarget = this.getMainRenderTarget()) != null) {
            rendertarget.resize(this.window.getWidth(), this.window.getHeight());
        }
        if (this.gameRenderer != null) {
            this.gameRenderer.resize(this.window.getWidth(), this.window.getHeight());
        }
        this.mouseHandler.setIgnoreFirstMove();
    }

    @Override
    public void cursorEntered() {
        this.mouseHandler.cursorEntered();
    }

    public int getFps() {
        return fps;
    }

    public long getFrameTimeNs() {
        return this.frameTimeNs;
    }

    private void emergencySave() {
        MemoryReserve.release();
        try {
            if (this.isLocalServer && this.singleplayerServer != null) {
                this.singleplayerServer.halt(true);
            }
            this.disconnectWithSavingScreen();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    public boolean debugClientMetricsStart(Consumer<Component> p_167947_) {
        Consumer<Path> consumer3;
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsStop();
            return false;
        }
        Consumer<ProfileResults> consumer = p_231435_ -> {
            if (p_231435_ != EmptyProfileResults.EMPTY) {
                int i = p_231435_.getTickDuration();
                double d0 = (double)p_231435_.getNanoDuration() / (double)TimeUtil.NANOSECONDS_PER_SECOND;
                this.execute(() -> p_167947_.accept(Component.translatable("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", d0), i, String.format(Locale.ROOT, "%.2f", (double)i / d0))));
            }
        };
        Consumer<Path> consumer1 = p_231438_ -> {
            MutableComponent component = Component.literal(p_231438_.toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_392490_ -> p_392490_.withClickEvent(new ClickEvent.OpenFile(p_231438_.getParent())));
            this.execute(() -> p_167947_.accept(Component.translatable("debug.profiling.stop", component)));
        };
        SystemReport systemreport = Minecraft.fillSystemReport(new SystemReport(), this, this.languageManager, this.launchedVersion, this.options);
        Consumer<List> consumer2 = p_231349_ -> {
            Path path = this.archiveProfilingReport(systemreport, (List<Path>)p_231349_);
            consumer1.accept(path);
        };
        if (this.singleplayerServer == null) {
            consumer3 = p_231404_ -> consumer2.accept((List)ImmutableList.of((Object)p_231404_));
        } else {
            this.singleplayerServer.fillSystemReport(systemreport);
            CompletableFuture completablefuture = new CompletableFuture();
            CompletableFuture completablefuture1 = new CompletableFuture();
            CompletableFuture.allOf(completablefuture, completablefuture1).thenRunAsync(() -> consumer2.accept((List)ImmutableList.of((Object)((Path)completablefuture.join()), (Object)((Path)completablefuture1.join()))), Util.ioPool());
            this.singleplayerServer.startRecordingMetrics(p_231351_ -> {}, completablefuture1::complete);
            consumer3 = completablefuture::complete;
        }
        this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ClientMetricsSamplersProvider(Util.timeSource, this.levelRenderer), Util.timeSource, Util.ioPool(), new MetricsPersister("client"), p_231401_ -> {
            this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
            consumer.accept((ProfileResults)p_231401_);
        }, consumer3);
        return true;
    }

    private void debugClientMetricsStop() {
        this.metricsRecorder.end();
        if (this.singleplayerServer != null) {
            this.singleplayerServer.finishRecordingMetrics();
        }
    }

    private void debugClientMetricsCancel() {
        this.metricsRecorder.cancel();
        if (this.singleplayerServer != null) {
            this.singleplayerServer.cancelRecordingMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path archiveProfilingReport(SystemReport p_167857_, List<Path> p_167858_) {
        Path path;
        ServerData serverdata;
        String s = this.isLocalServer() ? this.getSingleplayerServer().getWorldData().getLevelName() : ((serverdata = this.getCurrentServer()) != null ? serverdata.name : "unknown");
        try {
            String s2 = String.format(Locale.ROOT, "%s-%s-%s", Util.getFilenameFormattedDateTime(), s, SharedConstants.getCurrentVersion().id());
            String s1 = FileUtil.findAvailableName(MetricsPersister.PROFILING_RESULTS_DIR, s2, ".zip");
            path = MetricsPersister.PROFILING_RESULTS_DIR.resolve(s1);
        }
        catch (IOException ioexception1) {
            throw new UncheckedIOException(ioexception1);
        }
        try (FileZipper filezipper = new FileZipper(path);){
            filezipper.add(Paths.get("system.txt", new String[0]), p_167857_.toLineSeparatedString());
            filezipper.add(Paths.get("client", new String[0]).resolve(this.options.getFile().getName()), this.options.dumpOptionsForReport());
            p_167858_.forEach(filezipper::add);
        }
        finally {
            for (Path path1 : p_167858_) {
                try {
                    FileUtils.forceDelete((File)path1.toFile());
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to delete temporary profiling result {}", (Object)path1, (Object)ioexception);
                }
            }
        }
        return path;
    }

    public void stop() {
        if (this.isRunning()) {
            NeoForge.EVENT_BUS.post((Event)new GameShuttingDownEvent());
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void pauseGame(boolean p_91359_) {
        if (this.screen == null) {
            boolean flag;
            boolean bl = flag = this.hasSingleplayerServer() && !this.singleplayerServer.isPublished();
            if (flag) {
                this.setScreen(new PauseScreen(!p_91359_));
            } else {
                this.setScreen(new PauseScreen(true));
            }
        }
    }

    private void continueAttack(boolean p_91387_) {
        if (!p_91387_) {
            this.missTime = 0;
        }
        if (this.missTime <= 0 && !this.player.isUsingItem()) {
            if (p_91387_ && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                BlockPos blockpos = blockhitresult.getBlockPos();
                if (!this.level.getBlockState(blockpos).isAir()) {
                    InputEvent.InteractionKeyMappingTriggered inputEvent = ClientHooks.onClickInput((int)0, (KeyMapping)this.options.keyAttack, (InteractionHand)InteractionHand.MAIN_HAND);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.particleEngine.addBlockHitEffects(blockpos, blockhitresult);
                            this.player.swing(InteractionHand.MAIN_HAND);
                        }
                        return;
                    }
                    Direction direction = blockhitresult.getDirection();
                    if (this.gameMode.continueDestroyBlock(blockpos, direction) && inputEvent.shouldSwingHand()) {
                        this.particleEngine.addBlockHitEffects(blockpos, blockhitresult);
                        this.player.swing(InteractionHand.MAIN_HAND);
                    }
                }
            } else {
                this.gameMode.stopDestroyBlock();
            }
        }
    }

    private boolean startAttack() {
        if (this.missTime > 0) {
            return false;
        }
        if (this.hitResult == null) {
            LOGGER.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.gameMode.hasMissTime()) {
                this.missTime = 10;
            }
            return false;
        }
        if (this.player.isHandsBusy()) {
            return false;
        }
        ItemStack itemstack = this.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemstack.isItemEnabled(this.level.enabledFeatures())) {
            return false;
        }
        boolean flag = false;
        InputEvent.InteractionKeyMappingTriggered inputEvent = ClientHooks.onClickInput((int)0, (KeyMapping)this.options.keyAttack, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!inputEvent.isCanceled()) {
            switch (this.hitResult.getType()) {
                case ENTITY: {
                    this.gameMode.attack(this.player, ((EntityHitResult)this.hitResult).getEntity());
                    break;
                }
                case BLOCK: {
                    BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                    BlockPos blockpos = blockhitresult.getBlockPos();
                    if (!this.level.getBlockState(blockpos).isAir()) {
                        this.gameMode.startDestroyBlock(blockpos, blockhitresult.getDirection());
                        if (!this.level.getBlockState(blockpos).isAir()) break;
                        flag = true;
                        break;
                    }
                }
                case MISS: {
                    if (this.gameMode.hasMissTime()) {
                        this.missTime = 10;
                    }
                    this.player.resetAttackStrengthTicker();
                    CommonHooks.onEmptyLeftClick((Player)this.player);
                }
            }
        }
        if (inputEvent.shouldSwingHand()) {
            this.player.swing(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    private void startUseItem() {
        if (!this.gameMode.isDestroying()) {
            this.rightClickDelay = 4;
            if (!this.player.isHandsBusy()) {
                if (this.hitResult == null) {
                    LOGGER.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                for (InteractionHand interactionhand : InteractionHand.values()) {
                    InteractionResult interactionResult;
                    InputEvent.InteractionKeyMappingTriggered inputEvent = ClientHooks.onClickInput((int)1, (KeyMapping)this.options.keyUse, (InteractionHand)interactionhand);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.player.swing(interactionhand);
                        }
                        return;
                    }
                    ItemStack itemstack = this.player.getItemInHand(interactionhand);
                    if (!itemstack.isItemEnabled(this.level.enabledFeatures())) {
                        return;
                    }
                    if (this.hitResult != null) {
                        switch (this.hitResult.getType()) {
                            case ENTITY: {
                                EntityHitResult entityhitresult = (EntityHitResult)this.hitResult;
                                Entity entity = entityhitresult.getEntity();
                                if (!this.level.getWorldBorder().isWithinBounds(entity.blockPosition())) {
                                    return;
                                }
                                InteractionResult interactionresult = this.gameMode.interactAt(this.player, entity, entityhitresult, interactionhand);
                                if (!interactionresult.consumesAction()) {
                                    interactionresult = this.gameMode.interact(this.player, entity, interactionhand);
                                }
                                if (!(interactionresult instanceof InteractionResult.Success)) break;
                                InteractionResult.Success interactionresult$success2 = (InteractionResult.Success)interactionresult;
                                if (interactionresult$success2.swingSource() == InteractionResult.SwingSource.CLIENT && inputEvent.shouldSwingHand()) {
                                    this.player.swing(interactionhand);
                                }
                                return;
                            }
                            case BLOCK: {
                                BlockHitResult blockhitresult = (BlockHitResult)this.hitResult;
                                int i = itemstack.getCount();
                                InteractionResult interactionresult1 = this.gameMode.useItemOn(this.player, interactionhand, blockhitresult);
                                if (interactionresult1 instanceof InteractionResult.Success) {
                                    InteractionResult.Success interactionresult$success = (InteractionResult.Success)interactionresult1;
                                    if (interactionresult$success.swingSource() == InteractionResult.SwingSource.CLIENT && inputEvent.shouldSwingHand()) {
                                        this.player.swing(interactionhand);
                                        if (!itemstack.isEmpty() && (itemstack.getCount() != i || this.player.hasInfiniteMaterials())) {
                                            this.gameRenderer.itemInHandRenderer.itemUsed(interactionhand);
                                        }
                                    }
                                    return;
                                }
                                if (!(interactionresult1 instanceof InteractionResult.Fail)) break;
                                return;
                            }
                        }
                    }
                    if (itemstack.isEmpty() && (this.hitResult == null || this.hitResult.getType() == HitResult.Type.MISS)) {
                        CommonHooks.onEmptyClick((Player)this.player, (InteractionHand)interactionhand);
                    }
                    if (itemstack.isEmpty() || !((interactionResult = this.gameMode.useItem(this.player, interactionhand)) instanceof InteractionResult.Success)) continue;
                    InteractionResult.Success interactionresult$success1 = (InteractionResult.Success)interactionResult;
                    if (interactionresult$success1.swingSource() == InteractionResult.SwingSource.CLIENT) {
                        this.player.swing(interactionhand);
                    }
                    this.gameRenderer.itemInHandRenderer.itemUsed(interactionhand);
                    return;
                }
            }
        }
    }

    public MusicManager getMusicManager() {
        return this.musicManager;
    }

    public void tick() {
        ++this.clientTickCount;
        if (this.gameLoadFinished) {
            ClientHooks.fireClientTickPre();
        }
        if (this.level != null && !this.pause) {
            this.level.tickRateManager().tick();
        }
        if (this.rightClickDelay > 0) {
            --this.rightClickDelay;
        }
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("gui");
        this.chatListener.tick();
        this.gui.tick(this.pause);
        profilerfiller.pop();
        this.gameRenderer.pick(1.0f);
        this.tutorial.onLookAt(this.level, this.hitResult);
        profilerfiller.push("gameMode");
        if (!this.pause && this.level != null) {
            this.gameMode.tick();
        }
        profilerfiller.popPush("textures");
        if (this.isLevelRunningNormally()) {
            this.textureManager.tick();
        }
        if (this.screen != null || this.player == null) {
            Screen screen = this.screen;
            if (screen instanceof InBedChatScreen) {
                InBedChatScreen inbedchatscreen = (InBedChatScreen)screen;
                if (!this.player.isSleeping()) {
                    inbedchatscreen.onPlayerWokeUp();
                }
            }
        } else if (this.player.isDeadOrDying() && !(this.screen instanceof DeathScreen)) {
            this.setScreen(null);
        } else if (this.player.isSleeping() && this.level != null) {
            this.setScreen(new InBedChatScreen());
        }
        if (this.screen != null) {
            this.missTime = 10000;
        }
        if (this.screen != null) {
            try {
                this.screen.tick();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking screen");
                this.screen.fillCrashDetails(crashreport);
                throw new ReportedException(crashreport);
            }
        }
        if (!this.getDebugOverlay().showDebugScreen()) {
            this.gui.clearCache();
        }
        if (this.overlay == null && this.screen == null) {
            profilerfiller.popPush("Keybindings");
            this.handleKeybinds();
            if (this.missTime > 0) {
                --this.missTime;
            }
        }
        if (this.level != null) {
            profilerfiller.popPush("gameRenderer");
            if (!this.pause) {
                this.gameRenderer.tick();
            }
            profilerfiller.popPush("levelRenderer");
            if (!this.pause) {
                this.levelRenderer.tick();
            }
            profilerfiller.popPush("level");
            if (!this.pause) {
                this.level.tickEntities();
            }
        } else if (this.gameRenderer.currentPostEffect() != null) {
            this.gameRenderer.clearPostEffect();
        }
        this.musicManager.tick();
        this.soundManager.tick(this.pause);
        if (this.level != null) {
            ClientPacketListener clientpacketlistener;
            if (!this.pause) {
                if (!this.options.joinedFirstServer && this.isMultiplayerServer()) {
                    MutableComponent component = Component.translatable("tutorial.socialInteractions.title");
                    MutableComponent component1 = Component.translatable("tutorial.socialInteractions.description", Tutorial.key("socialInteractions"));
                    this.socialInteractionsToast = new TutorialToast(this.font, TutorialToast.Icons.SOCIAL_INTERACTIONS, component, component1, true, 8000);
                    this.toastManager.addToast(this.socialInteractionsToast);
                    this.options.joinedFirstServer = true;
                    this.options.save();
                }
                this.tutorial.tick();
                EventHooks.fireLevelTickPre((Level)this.level, () -> true);
                try {
                    this.level.tick(() -> true);
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.forThrowable(throwable1, "Exception in world tick");
                    if (this.level == null) {
                        CrashReportCategory crashreportcategory = crashreport1.addCategory("Affected level");
                        crashreportcategory.setDetail("Problem", "Level is null!");
                    } else {
                        this.level.fillReportDetails(crashreport1);
                    }
                    throw new ReportedException(crashreport1);
                }
                EventHooks.fireLevelTickPost((Level)this.level, () -> true);
            }
            profilerfiller.popPush("animateTick");
            if (!this.pause && this.isLevelRunningNormally()) {
                this.level.animateTick(this.player.getBlockX(), this.player.getBlockY(), this.player.getBlockZ());
            }
            profilerfiller.popPush("particles");
            if (!this.pause && this.isLevelRunningNormally()) {
                this.particleEngine.tick();
            }
            if ((clientpacketlistener = this.getConnection()) != null && !this.pause) {
                clientpacketlistener.send(ServerboundClientTickEndPacket.INSTANCE);
            }
        } else if (this.pendingConnection != null) {
            profilerfiller.popPush("pendingConnection");
            this.pendingConnection.tick();
        }
        profilerfiller.popPush("keyboard");
        this.keyboardHandler.tick();
        profilerfiller.pop();
        if (this.gameLoadFinished) {
            ClientHooks.fireClientTickPost();
        }
    }

    private boolean isLevelRunningNormally() {
        return this.level == null || this.level.tickRateManager().runsNormally();
    }

    private boolean isMultiplayerServer() {
        return !this.isLocalServer || this.singleplayerServer != null && this.singleplayerServer.isPublished();
    }

    private void handleKeybinds() {
        while (this.options.keyTogglePerspective.consumeClick()) {
            CameraType cameratype = this.options.getCameraType();
            this.options.setCameraType(this.options.getCameraType().cycle());
            if (cameratype.isFirstPerson() != this.options.getCameraType().isFirstPerson()) {
                this.gameRenderer.checkEntityPostEffect(this.options.getCameraType().isFirstPerson() ? this.getCameraEntity() : null);
            }
            this.levelRenderer.needsUpdate();
        }
        while (this.options.keySmoothCamera.consumeClick()) {
            this.options.smoothCamera = !this.options.smoothCamera;
        }
        for (int i = 0; i < 9; ++i) {
            boolean flag = this.options.keySaveHotbarActivator.isDown();
            boolean flag1 = this.options.keyLoadHotbarActivator.isDown();
            if (!this.options.keyHotbarSlots[i].consumeClick()) continue;
            if (this.player.isSpectator()) {
                this.gui.getSpectatorGui().onHotbarSelected(i);
                continue;
            }
            if (!this.player.hasInfiniteMaterials() || this.screen != null || !flag1 && !flag) {
                this.player.getInventory().setSelectedSlot(i);
                continue;
            }
            CreativeModeInventoryScreen.handleHotbarLoadOrSave(this, i, flag1, flag);
        }
        while (this.options.keySocialInteractions.consumeClick()) {
            if (!this.isMultiplayerServer()) {
                this.player.displayClientMessage(SOCIAL_INTERACTIONS_NOT_AVAILABLE, true);
                this.narrator.saySystemNow(SOCIAL_INTERACTIONS_NOT_AVAILABLE);
                continue;
            }
            if (this.socialInteractionsToast != null) {
                this.socialInteractionsToast.hide();
                this.socialInteractionsToast = null;
            }
            this.setScreen(new SocialInteractionsScreen());
        }
        while (this.options.keyInventory.consumeClick()) {
            if (this.gameMode.isServerControlledInventory()) {
                this.player.sendOpenInventory();
                continue;
            }
            this.tutorial.onOpenInventory();
            this.setScreen(new InventoryScreen(this.player));
        }
        while (this.options.keyAdvancements.consumeClick()) {
            this.setScreen(new AdvancementsScreen(this.player.connection.getAdvancements()));
        }
        while (this.options.keyQuickActions.consumeClick()) {
            this.getQuickActionsDialog().ifPresent(p_428041_ -> this.player.connection.showDialog((Holder<Dialog>)p_428041_, this.screen));
        }
        while (this.options.keySwapOffhand.consumeClick()) {
            if (this.player.isSpectator()) continue;
            this.getConnection().send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
        }
        while (this.options.keyDrop.consumeClick()) {
            if (this.player.isSpectator() || !this.player.drop(Screen.hasControlDown())) continue;
            this.player.swing(InteractionHand.MAIN_HAND);
        }
        while (this.options.keyChat.consumeClick()) {
            this.openChatScreen("");
        }
        if (this.screen == null && this.overlay == null && this.options.keyCommand.consumeClick()) {
            this.openChatScreen("/");
        }
        boolean flag2 = false;
        if (this.player.isUsingItem()) {
            if (!this.options.keyUse.isDown()) {
                this.gameMode.releaseUsingItem(this.player);
            }
            while (this.options.keyAttack.consumeClick()) {
            }
            while (this.options.keyUse.consumeClick()) {
            }
            while (this.options.keyPickItem.consumeClick()) {
            }
        } else {
            while (this.options.keyAttack.consumeClick()) {
                flag2 |= this.startAttack();
            }
            while (this.options.keyUse.consumeClick()) {
                this.startUseItem();
            }
            while (this.options.keyPickItem.consumeClick()) {
                this.pickBlock();
            }
        }
        if (this.options.keyUse.isDown() && this.rightClickDelay == 0 && !this.player.isUsingItem()) {
            this.startUseItem();
        }
        this.continueAttack(this.screen == null && !flag2 && this.options.keyAttack.isDown() && this.mouseHandler.isMouseGrabbed());
    }

    private Optional<Holder<Dialog>> getQuickActionsDialog() {
        HolderLookup.RegistryLookup registry = this.player.connection.registryAccess().lookupOrThrow(Registries.DIALOG);
        return registry.get(DialogTags.QUICK_ACTIONS).flatMap(arg_0 -> Minecraft.lambda$getQuickActionsDialog$39((Registry)registry, arg_0));
    }

    public ClientTelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    public double getGpuUtilization() {
        return this.gpuUtilization;
    }

    public ProfileKeyPairManager getProfileKeyPairManager() {
        return this.profileKeyPairManager;
    }

    public WorldOpenFlows createWorldOpenFlows() {
        return new WorldOpenFlows(this, this.levelSource);
    }

    public void doWorldLoad(LevelStorageSource.LevelStorageAccess p_261564_, PackRepository p_261826_, WorldStem p_261470_, boolean p_261465_) {
        this.disconnectWithProgressScreen();
        this.progressListener.set(null);
        Instant instant = Instant.now();
        try {
            p_261564_.saveDataTag(p_261470_.registries().compositeAccess(), p_261470_.worldData());
            Services services = Services.create(this.authenticationService, this.gameDirectory);
            services.profileCache().setExecutor(this);
            SkullBlockEntity.setup(services, this);
            GameProfileCache.setUsesAuthentication(false);
            this.singleplayerServer = MinecraftServer.spin(p_231361_ -> new IntegratedServer((Thread)p_231361_, this, p_261564_, p_261826_, p_261470_, services, p_319374_ -> {
                StoringChunkProgressListener storingchunkprogresslistener = StoringChunkProgressListener.createFromGameruleRadius(p_319374_ + 0);
                this.progressListener.set(storingchunkprogresslistener);
                return ProcessorChunkProgressListener.createStarted(storingchunkprogresslistener, this.progressTasks::add);
            }));
            this.isLocalServer = true;
            this.updateReportEnvironment(ReportEnvironment.local());
            this.quickPlayLog.setWorldData(QuickPlayLog.Type.SINGLEPLAYER, p_261564_.getLevelId(), p_261470_.worldData().getLevelName());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Starting integrated server");
            crashreportcategory.setDetail("Level ID", p_261564_.getLevelId());
            crashreportcategory.setDetail("Level Name", () -> p_261470_.worldData().getLevelName());
            throw new ReportedException(crashreport);
        }
        while (this.progressListener.get() == null) {
            Thread.yield();
        }
        LevelLoadingScreen levelloadingscreen = new LevelLoadingScreen(this.progressListener.get());
        ProfilerFiller profilerfiller = Profiler.get();
        this.setScreen(levelloadingscreen);
        profilerfiller.push("waitForServer");
        while (!this.singleplayerServer.isReady() || this.overlay != null) {
            levelloadingscreen.tick();
            this.runTick(false);
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException crashreportcategory) {
                // empty catch block
            }
            this.handleDelayedCrash();
        }
        GameTestTicker.SINGLETON.startTicking();
        profilerfiller.pop();
        Duration duration = Duration.between(instant, Instant.now());
        SocketAddress socketaddress = this.singleplayerServer.getConnection().startMemoryChannel();
        Connection connection = Connection.connectToLocalServer(socketaddress);
        connection.initiateServerboundPlayConnection(socketaddress.toString(), 0, new ClientHandshakePacketListenerImpl(connection, this, null, null, p_261465_, duration, p_231442_ -> {}, null));
        connection.send(new ServerboundHelloPacket(this.getUser().getName(), this.getUser().getProfileId()));
        this.pendingConnection = connection;
    }

    public void setLevel(ClientLevel p_91157_, ReceivingLevelScreen.Reason p_341652_) {
        if (this.level != null) {
            NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)this.level));
        }
        this.updateScreenAndTick(DimensionTransitionScreenManager.getScreenFromLevel((Level)p_91157_, (Level)this.level).create(() -> false, p_341652_));
        this.level = p_91157_;
        this.updateLevelInEngines(p_91157_);
        if (!this.isLocalServer) {
            Services services = Services.create(this.authenticationService, this.gameDirectory);
            services.profileCache().setExecutor(this);
            SkullBlockEntity.setup(services, this);
            GameProfileCache.setUsesAuthentication(false);
        }
    }

    public void disconnectWithSavingScreen() {
        this.disconnect(new GenericMessageScreen(SAVING_LEVEL), false);
    }

    public void disconnectWithProgressScreen() {
        this.disconnect(new ProgressScreen(true), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Screen p_320248_, boolean p_319814_) {
        ClientPacketListener clientpacketlistener = this.getConnection();
        if (clientpacketlistener != null) {
            this.dropAllTasks();
            clientpacketlistener.close();
            if (!p_319814_) {
                this.clearDownloadedResourcePacks();
            }
        }
        this.playerSocialManager.stopOnlineMode();
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsCancel();
        }
        IntegratedServer integratedserver = this.singleplayerServer;
        this.singleplayerServer = null;
        this.gameRenderer.resetData();
        ClientHooks.firePlayerLogout((MultiPlayerGameMode)this.gameMode, (LocalPlayer)this.player);
        this.gameMode = null;
        this.narrator.clear();
        this.clientLevelTeardownInProgress = true;
        boolean shouldRevertRegistriesToFrozen = this.getConnection() != null && this.getConnection().getConnection() != null;
        try {
            this.updateScreenAndTick(p_320248_);
            if (this.level != null) {
                NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)this.level));
                if (integratedserver != null) {
                    ProfilerFiller profilerfiller = Profiler.get();
                    profilerfiller.push("waitForServer");
                    while (!integratedserver.isShutdown()) {
                        this.runTick(false);
                    }
                    profilerfiller.pop();
                }
                this.gui.onDisconnected();
                this.isLocalServer = false;
            }
            this.level = null;
            this.updateLevelInEngines(null);
            this.player = null;
        }
        finally {
            this.clientLevelTeardownInProgress = false;
        }
        SkullBlockEntity.clear();
        if (shouldRevertRegistriesToFrozen) {
            RegistryManager.revertToFrozen();
        }
    }

    public void clearDownloadedResourcePacks() {
        this.downloadedPackSource.cleanupAfterDisconnect();
        this.runAllTasks();
    }

    public void clearClientLevel(Screen p_294558_) {
        ClientPacketListener clientpacketlistener = this.getConnection();
        if (clientpacketlistener != null) {
            clientpacketlistener.clearLevel();
        }
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsCancel();
        }
        this.gameRenderer.resetData();
        this.gameMode = null;
        this.narrator.clear();
        this.clientLevelTeardownInProgress = true;
        try {
            this.updateScreenAndTick(p_294558_);
            this.gui.onDisconnected();
            this.level = null;
            this.updateLevelInEngines(null);
            this.player = null;
        }
        finally {
            this.clientLevelTeardownInProgress = false;
        }
        SkullBlockEntity.clear();
    }

    private void updateScreenAndTick(Screen p_91363_) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("forcedTick");
        this.soundManager.stop();
        this.cameraEntity = null;
        this.pendingConnection = null;
        this.setScreen(p_91363_);
        this.runTick(false);
        profilerfiller.pop();
    }

    public void forceSetScreen(Screen p_91347_) {
        try (Zone zone = Profiler.get().zone("forcedTick");){
            this.setScreen(p_91347_);
            this.runTick(false);
        }
    }

    private void updateLevelInEngines(@Nullable ClientLevel p_91325_) {
        this.levelRenderer.setLevel(p_91325_);
        this.particleEngine.setLevel(p_91325_);
        this.blockEntityRenderDispatcher.setLevel(p_91325_);
        this.gameRenderer.setLevel(p_91325_);
        this.updateTitle();
    }

    private UserApiService.UserProperties userProperties() {
        return this.userPropertiesFuture.join();
    }

    public boolean telemetryOptInExtra() {
        return this.extraTelemetryAvailable() && this.options.telemetryOptInExtra().get() != false;
    }

    public boolean extraTelemetryAvailable() {
        return this.allowsTelemetry() && this.userProperties().flag(UserApiService.UserFlag.OPTIONAL_TELEMETRY_AVAILABLE);
    }

    public boolean allowsTelemetry() {
        return SharedConstants.IS_RUNNING_IN_IDE ? false : this.userProperties().flag(UserApiService.UserFlag.TELEMETRY_ENABLED);
    }

    public boolean allowsMultiplayer() {
        return this.allowsMultiplayer && this.userProperties().flag(UserApiService.UserFlag.SERVERS_ALLOWED) && this.multiplayerBan() == null && !this.isNameBanned();
    }

    public boolean allowsRealms() {
        return this.userProperties().flag(UserApiService.UserFlag.REALMS_ALLOWED) && this.multiplayerBan() == null;
    }

    @Nullable
    public BanDetails multiplayerBan() {
        return (BanDetails)this.userProperties().bannedScopes().get("MULTIPLAYER");
    }

    public boolean isNameBanned() {
        ProfileResult profileresult = this.profileFuture.getNow(null);
        return profileresult != null && profileresult.actions().contains(ProfileActionType.FORCED_NAME_CHANGE);
    }

    public boolean isBlocked(UUID p_91247_) {
        return this.getChatStatus().isChatAllowed(false) ? this.playerSocialManager.shouldHideMessageFrom(p_91247_) : (this.player == null || !p_91247_.equals(this.player.getUUID())) && !p_91247_.equals(Util.NIL_UUID);
    }

    public ChatStatus getChatStatus() {
        if (this.options.chatVisibility().get() == ChatVisiblity.HIDDEN) {
            return ChatStatus.DISABLED_BY_OPTIONS;
        }
        if (!this.allowsChat) {
            return ChatStatus.DISABLED_BY_LAUNCHER;
        }
        return !this.userProperties().flag(UserApiService.UserFlag.CHAT_ALLOWED) ? ChatStatus.DISABLED_BY_PROFILE : ChatStatus.ENABLED;
    }

    public final boolean isDemo() {
        return this.demo;
    }

    @Nullable
    public ClientPacketListener getConnection() {
        return this.player == null ? null : this.player.connection;
    }

    public static boolean renderNames() {
        return !Minecraft.instance.options.hideGui;
    }

    public static boolean useFancyGraphics() {
        return Minecraft.instance.options.graphicsMode().get().getId() >= GraphicsStatus.FANCY.getId();
    }

    public static boolean useShaderTransparency() {
        return !Minecraft.instance.gameRenderer.isPanoramicMode() && Minecraft.instance.options.graphicsMode().get().getId() >= GraphicsStatus.FABULOUS.getId();
    }

    public static boolean useAmbientOcclusion() {
        return Minecraft.instance.options.ambientOcclusion().get();
    }

    private void pickBlock() {
        if (this.hitResult != null && this.hitResult.getType() != HitResult.Type.MISS) {
            if (ClientHooks.onClickInput((int)2, (KeyMapping)this.options.keyPickItem, (InteractionHand)InteractionHand.MAIN_HAND).isCanceled()) {
                return;
            }
            boolean flag = Screen.hasControlDown();
            HitResult hitResult = this.hitResult;
            Objects.requireNonNull(hitResult);
            HitResult hitResult2 = hitResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHitResult.class, EntityHitResult.class}, (Object)hitResult2, n)) {
                case 0: {
                    BlockHitResult blockhitresult = (BlockHitResult)hitResult2;
                    this.gameMode.handlePickItemFromBlock(blockhitresult.getBlockPos(), flag);
                    break;
                }
                case 1: {
                    EntityHitResult entityhitresult = (EntityHitResult)hitResult2;
                    this.gameMode.handlePickItemFromEntity(entityhitresult.getEntity(), flag);
                    break;
                }
            }
        }
    }

    public CrashReport fillReport(CrashReport p_91355_) {
        SystemReport systemreport = p_91355_.getSystemReport();
        try {
            Minecraft.fillSystemReport(systemreport, this, this.languageManager, this.launchedVersion, this.options);
            this.fillUptime(p_91355_.addCategory("Uptime"));
            if (this.level != null) {
                this.level.fillReportDetails(p_91355_);
            }
            if (this.singleplayerServer != null) {
                this.singleplayerServer.fillSystemReport(systemreport);
            }
            this.reloadStateTracker.fillCrashReport(p_91355_);
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to collect details", throwable);
        }
        return p_91355_;
    }

    public static void fillReport(@Nullable Minecraft p_167873_, @Nullable LanguageManager p_167874_, String p_167875_, @Nullable Options p_167876_, CrashReport p_167877_) {
        SystemReport systemreport = p_167877_.getSystemReport();
        Minecraft.fillSystemReport(systemreport, p_167873_, p_167874_, p_167875_, p_167876_);
    }

    private static String formatSeconds(double p_304493_) {
        return String.format(Locale.ROOT, "%.3fs", p_304493_);
    }

    private void fillUptime(CrashReportCategory p_304858_) {
        p_304858_.setDetail("JVM uptime", () -> Minecraft.formatSeconds((double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0));
        p_304858_.setDetail("Wall uptime", () -> Minecraft.formatSeconds((double)(System.currentTimeMillis() - this.clientStartTimeMs) / 1000.0));
        p_304858_.setDetail("High-res time", () -> Minecraft.formatSeconds((double)Util.getMillis() / 1000.0));
        p_304858_.setDetail("Client ticks", () -> String.format(Locale.ROOT, "%d ticks / %.3fs", this.clientTickCount, (double)this.clientTickCount / 20.0));
    }

    private static SystemReport fillSystemReport(SystemReport p_167851_, @Nullable Minecraft p_167852_, @Nullable LanguageManager p_167853_, String p_167854_, @Nullable Options p_167855_) {
        p_167851_.setDetail("Launched Version", () -> p_167854_);
        String s = Minecraft.getLauncherBrand();
        if (s != null) {
            p_167851_.setDetail("Launcher name", s);
        }
        p_167851_.setDetail("Backend library", RenderSystem::getBackendDescription);
        p_167851_.setDetail("Backend API", RenderSystem::getApiDescription);
        p_167851_.setDetail("Window size", () -> p_167852_ != null ? p_167852_.window.getWidth() + "x" + p_167852_.window.getHeight() : "<not initialized>");
        p_167851_.setDetail("GFLW Platform", Window::getPlatform);
        p_167851_.setDetail("Render Extensions", () -> String.join((CharSequence)", ", RenderSystem.getDevice().getEnabledExtensions()));
        p_167851_.setDetail("GL debug messages", () -> {
            GpuDevice gpudevice = RenderSystem.tryGetDevice();
            if (gpudevice == null) {
                return "<no renderer available>";
            }
            return gpudevice.isDebuggingEnabled() ? String.join((CharSequence)"\n", gpudevice.getLastDebugMessages()) : "<debugging unavailable>";
        });
        p_167851_.setDetail("Is Modded", () -> Minecraft.checkModStatus().fullDescription());
        p_167851_.setDetail("Universe", () -> p_167852_ != null ? Long.toHexString(p_167852_.canary) : "404");
        p_167851_.setDetail("Type", "Client (map_client.txt)");
        if (p_167855_ != null) {
            String s1;
            if (p_167852_ != null && (s1 = p_167852_.getGpuWarnlistManager().getAllWarnings()) != null) {
                p_167851_.setDetail("GPU Warnings", s1);
            }
            p_167851_.setDetail("Graphics mode", p_167855_.graphicsMode().get().toString());
            p_167851_.setDetail("Render Distance", p_167855_.getEffectiveRenderDistance() + "/" + String.valueOf(p_167855_.renderDistance().get()) + " chunks");
        }
        if (p_167852_ != null) {
            p_167851_.setDetail("Resource Packs", () -> PackRepository.displayPackList(p_167852_.getResourcePackRepository().getSelectedPacks()));
        }
        if (p_167853_ != null) {
            p_167851_.setDetail("Current Language", () -> p_167853_.getSelected());
        }
        p_167851_.setDetail("Locale", String.valueOf(Locale.getDefault()));
        p_167851_.setDetail("System encoding", () -> System.getProperty("sun.jnu.encoding", "<not set>"));
        p_167851_.setDetail("File encoding", () -> System.getProperty("file.encoding", "<not set>"));
        p_167851_.setDetail("CPU", GLX::_getCpuInfo);
        return p_167851_;
    }

    public static Minecraft getInstance() {
        return instance;
    }

    public CompletableFuture<Void> delayTextureReload() {
        return this.submit(this::reloadResourcePacks).thenCompose(p_231391_ -> p_231391_);
    }

    public void updateReportEnvironment(ReportEnvironment p_239477_) {
        if (!this.reportingContext.matches(p_239477_)) {
            this.reportingContext = ReportingContext.create(p_239477_, this.userApiService);
        }
    }

    @Nullable
    public ServerData getCurrentServer() {
        return Optionull.map(this.getConnection(), ClientPacketListener::getServerData);
    }

    public boolean isLocalServer() {
        return this.isLocalServer;
    }

    public boolean hasSingleplayerServer() {
        return this.isLocalServer && this.singleplayerServer != null;
    }

    @Nullable
    public IntegratedServer getSingleplayerServer() {
        return this.singleplayerServer;
    }

    public boolean isSingleplayer() {
        IntegratedServer integratedserver = this.getSingleplayerServer();
        return integratedserver != null && !integratedserver.isPublished();
    }

    public boolean isLocalPlayer(UUID p_295141_) {
        return p_295141_.equals(this.getUser().getProfileId());
    }

    public User getUser() {
        return this.user;
    }

    public GameProfile getGameProfile() {
        ProfileResult profileresult = this.profileFuture.join();
        return profileresult != null ? profileresult.profile() : new GameProfile(this.user.getProfileId(), this.user.getName());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public ShaderManager getShaderManager() {
        return this.shaderManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public PackRepository getResourcePackRepository() {
        return this.resourcePackRepository;
    }

    public VanillaPackResources getVanillaPackResources() {
        return this.vanillaPackResources;
    }

    public DownloadedPackSource getDownloadedPackSource() {
        return this.downloadedPackSource;
    }

    public Path getResourcePackDirectory() {
        return this.resourcePackDirectory;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Function<ResourceLocation, TextureAtlasSprite> getTextureAtlas(ResourceLocation p_91259_) {
        return this.modelManager.getAtlas(p_91259_)::getSprite;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public GpuWarnlistManager getGpuWarnlistManager() {
        return this.gpuWarnlistManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public MusicInfo getSituationalMusic() {
        Music music = Optionull.map(this.screen, Screen::getBackgroundMusic);
        if (music != null) {
            return new MusicInfo(music);
        }
        if (this.player == null) {
            return new MusicInfo(Musics.MENU);
        }
        Level level = this.player.level();
        if (level.dimension() == Level.END) {
            return this.gui.getBossOverlay().shouldPlayMusic() ? new MusicInfo(Musics.END_BOSS) : new MusicInfo(Musics.END);
        }
        Holder holder = level.getBiome(this.player.blockPosition());
        Biome biome = (Biome)holder.value();
        float f = biome.getBackgroundMusicVolume();
        Optional<WeightedList<Music>> optional = biome.getBackgroundMusic();
        if (optional.isPresent()) {
            Optional<Music> optional1 = optional.get().getRandom(level.random);
            return new MusicInfo(optional1.orElse(null), f);
        }
        if (!(this.musicManager.isPlayingMusic(Musics.UNDER_WATER) || this.player.isUnderWater() && holder.is(BiomeTags.PLAYS_UNDERWATER_MUSIC))) {
            return level.dimension() != Level.NETHER && this.player.getAbilities().instabuild && this.player.getAbilities().mayfly ? new MusicInfo(Musics.CREATIVE, f) : new MusicInfo(Musics.GAME, f);
        }
        return new MusicInfo(Musics.UNDER_WATER, f);
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.minecraftSessionService;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    @Nullable
    public Entity getCameraEntity() {
        return this.cameraEntity;
    }

    public void setCameraEntity(Entity p_91119_) {
        this.cameraEntity = p_91119_;
        this.gameRenderer.checkEntityPostEffect(p_91119_);
    }

    public boolean shouldEntityAppearGlowing(Entity p_91315_) {
        return p_91315_.isCurrentlyGlowing() || this.player != null && this.player.isSpectator() && this.options.keySpectatorOutlines.isDown() && p_91315_.getType() == EntityType.PLAYER;
    }

    @Override
    protected Thread getRunningThread() {
        return this.gameThread;
    }

    @Override
    public Runnable wrapRunnable(Runnable p_91376_) {
        return p_91376_;
    }

    @Override
    protected boolean shouldRun(Runnable p_91365_) {
        return true;
    }

    public BlockRenderDispatcher getBlockRenderer() {
        return this.blockRenderer;
    }

    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return this.entityRenderDispatcher;
    }

    public BlockEntityRenderDispatcher getBlockEntityRenderDispatcher() {
        return this.blockEntityRenderDispatcher;
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public MapRenderer getMapRenderer() {
        return this.mapRenderer;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public DeltaTracker getDeltaTracker() {
        return this.deltaTracker;
    }

    public BlockColors getBlockColors() {
        return this.blockColors;
    }

    public boolean showOnlyReducedInfo() {
        return this.player != null && this.player.isReducedDebugInfo() || this.options.reducedDebugInfo().get() != false;
    }

    public ToastManager getToastManager() {
        return this.toastManager;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public boolean isWindowActive() {
        return this.windowActive;
    }

    public HotbarManager getHotbarManager() {
        return this.hotbarManager;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public PaintingTextureManager getPaintingTextures() {
        return this.paintingTextures;
    }

    public MapTextureManager getMapTextureManager() {
        return this.mapTextureManager;
    }

    public MapDecorationTextureManager getMapDecorationTextures() {
        return this.mapDecorationTextures;
    }

    public GuiSpriteManager getGuiSprites() {
        return this.guiSprites;
    }

    public WaypointStyleManager getWaypointStyles() {
        return this.waypointStyles;
    }

    @Override
    public void setWindowActive(boolean p_91261_) {
        this.windowActive = p_91261_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component grabPanoramixScreenshot(File p_167900_) {
        MutableComponent mutablecomponent;
        int i = 4;
        int j = 4096;
        int k = 4096;
        int l = this.window.getWidth();
        int i1 = this.window.getHeight();
        RenderTarget rendertarget = this.getMainRenderTarget();
        float f = this.player.getXRot();
        float f1 = this.player.getYRot();
        float f2 = this.player.xRotO;
        float f3 = this.player.yRotO;
        this.gameRenderer.setRenderBlockOutline(false);
        try {
            this.gameRenderer.setPanoramicMode(true);
            this.window.setWidth(4096);
            this.window.setHeight(4096);
            rendertarget.resize(4096, 4096);
            for (int j1 = 0; j1 < 6; ++j1) {
                switch (j1) {
                    case 0: {
                        this.player.setYRot(f1);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 1: {
                        this.player.setYRot((f1 + 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 2: {
                        this.player.setYRot((f1 + 180.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 3: {
                        this.player.setYRot((f1 - 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 4: {
                        this.player.setYRot(f1);
                        this.player.setXRot(-90.0f);
                        break;
                    }
                    default: {
                        this.player.setYRot(f1);
                        this.player.setXRot(90.0f);
                    }
                }
                this.player.yRotO = this.player.getYRot();
                this.player.xRotO = this.player.getXRot();
                this.gameRenderer.renderLevel(DeltaTracker.ONE);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.grab(p_167900_, "panorama_" + j1 + ".png", rendertarget, 4, p_231415_ -> {});
            }
            MutableComponent component = Component.literal(p_167900_.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_392492_ -> p_392492_.withClickEvent(new ClickEvent.OpenFile(p_167900_.getAbsoluteFile())));
            MutableComponent mutableComponent = Component.translatable("screenshot.success", component);
            return mutableComponent;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save image", (Throwable)exception);
            mutablecomponent = Component.translatable("screenshot.failure", exception.getMessage());
        }
        finally {
            this.player.setXRot(f);
            this.player.setYRot(f1);
            this.player.xRotO = f2;
            this.player.yRotO = f3;
            this.gameRenderer.setRenderBlockOutline(true);
            this.window.setWidth(l);
            this.window.setHeight(i1);
            rendertarget.resize(l, i1);
            this.gameRenderer.setPanoramicMode(false);
        }
        return mutablecomponent;
    }

    @Nullable
    public StoringChunkProgressListener getProgressListener() {
        return this.progressListener.get();
    }

    public SplashManager getSplashManager() {
        return this.splashManager;
    }

    @Nullable
    public Overlay getOverlay() {
        return this.overlay;
    }

    public PlayerSocialManager getPlayerSocialManager() {
        return this.playerSocialManager;
    }

    public Window getWindow() {
        return this.window;
    }

    public FramerateLimitTracker getFramerateLimitTracker() {
        return this.framerateLimitTracker;
    }

    public DebugScreenOverlay getDebugOverlay() {
        return this.gui.getDebugOverlay();
    }

    public RenderBuffers renderBuffers() {
        return this.renderBuffers;
    }

    public void updateMaxMipLevel(int p_91313_) {
        this.modelManager.updateMaxMipLevel(p_91313_);
    }

    public EntityModelSet getEntityModels() {
        return this.modelManager.entityModels().get();
    }

    public boolean isTextFilteringEnabled() {
        return this.userProperties().flag(UserApiService.UserFlag.PROFANITY_FILTER_ENABLED);
    }

    public void prepareForMultiplayer() {
        this.playerSocialManager.startOnlineMode();
        this.getProfileKeyPairManager().prepareKeyPair();
    }

    @Nullable
    public SignatureValidator getProfileKeySignatureValidator() {
        return SignatureValidator.from(this.authenticationService.getServicesKeySet(), ServicesKeyType.PROFILE_KEY);
    }

    public boolean canValidateProfileKeys() {
        return !this.authenticationService.getServicesKeySet().keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }

    public InputType getLastInputType() {
        return this.lastInputType;
    }

    public void setLastInputType(InputType p_265509_) {
        this.lastInputType = p_265509_;
    }

    public GameNarrator getNarrator() {
        return this.narrator;
    }

    public ChatListener getChatListener() {
        return this.chatListener;
    }

    public ReportingContext getReportingContext() {
        return this.reportingContext;
    }

    public RealmsDataFetcher realmsDataFetcher() {
        return this.realmsDataFetcher;
    }

    public QuickPlayLog quickPlayLog() {
        return this.quickPlayLog;
    }

    public CommandHistory commandHistory() {
        return this.commandHistory;
    }

    public DirectoryValidator directoryValidator() {
        return this.directoryValidator;
    }

    private float getTickTargetMillis(float p_308953_) {
        TickRateManager tickratemanager;
        if (this.level != null && (tickratemanager = this.level.tickRateManager()).runsNormally()) {
            return Math.max(p_308953_, tickratemanager.millisecondsPerTick());
        }
        return p_308953_;
    }

    public ItemModelResolver getItemModelResolver() {
        return this.itemModelResolver;
    }

    @Nullable
    public static String getLauncherBrand() {
        return System.getProperty("minecraft.launcher.brand");
    }

    private static /* synthetic */ Optional lambda$getQuickActionsDialog$39(Registry registry, HolderSet.Named p_428040_) {
        if (p_428040_.size() == 0) {
            return Optional.empty();
        }
        return p_428040_.size() == 1 ? Optional.of(p_428040_.get(0)) : registry.get(Dialogs.QUICK_ACTIONS);
    }

    static {
        LOGGER = LogUtils.getLogger();
        ON_OSX = Util.getPlatform() == Util.OS.OSX;
        DEFAULT_FONT = ResourceLocation.withDefaultNamespace("default");
        UNIFORM_FONT = ResourceLocation.withDefaultNamespace("uniform");
        ALT_FONT = ResourceLocation.withDefaultNamespace("alt");
        REGIONAL_COMPLIANCIES = ResourceLocation.withDefaultNamespace("regional_compliancies.json");
        RESOURCE_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
        SOCIAL_INTERACTIONS_NOT_AVAILABLE = Component.translatable("multiplayer.socialInteractions.not_available");
        SAVING_LEVEL = Component.translatable("menu.savingLevel");
    }

    @OnlyIn(value=Dist.CLIENT)
    record GameLoadCookie(RealmsClient realmsClient, GameConfig.QuickPlayData quickPlayData) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ChatStatus {
        ENABLED(CommonComponents.EMPTY){

            @Override
            public boolean isChatAllowed(boolean p_168045_) {
                return true;
            }
        }
        ,
        DISABLED_BY_OPTIONS(Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168051_) {
                return false;
            }
        }
        ,
        DISABLED_BY_LAUNCHER(Component.translatable("chat.disabled.launcher").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168057_) {
                return p_168057_;
            }
        }
        ,
        DISABLED_BY_PROFILE(Component.translatable("chat.disabled.profile", Component.keybind(Minecraft.instance.options.keyChat.getName())).withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168063_) {
                return p_168063_;
            }
        };

        static final Component INFO_DISABLED_BY_PROFILE;
        private final Component message;

        private ChatStatus(Component p_168033_) {
            this.message = p_168033_;
        }

        public Component getMessage() {
            return this.message;
        }

        public abstract boolean isChatAllowed(boolean var1);

        static {
            INFO_DISABLED_BY_PROFILE = Component.translatable("chat.disabled.profile.moreInfo");
        }
    }
}

